/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.http.HeaderElement;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.collections.AList;
import org.apache.juneau.http.Constants;
import org.apache.juneau.http.StringRange;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.StringUtils;

@BeanIgnore
public class StringRanges {
    private static final StringRanges DEFAULT = new StringRanges("");
    private static final Cache<String, StringRanges> CACHE = new Cache(Constants.NOCACHE, Constants.CACHE_MAX_SIZE);
    private final StringRange[] ranges;
    private final String string;
    private static final Comparator<StringRange> RANGE_COMPARATOR = new Comparator<StringRange>(){

        @Override
        public int compare(StringRange o1, StringRange o2) {
            int qCompare = Float.compare(o2.getQValue().floatValue(), o1.getQValue().floatValue());
            if (qCompare != 0) {
                return qCompare;
            }
            int i = o2.toString().compareTo(o1.toString());
            return i;
        }
    };

    public static StringRanges of(String value) {
        if (value == null || value.length() == 0) {
            return DEFAULT;
        }
        StringRanges mr = CACHE.get(value);
        if (mr == null) {
            mr = CACHE.put(value, new StringRanges(value));
        }
        return mr;
    }

    public StringRanges(String value) {
        this(StringRanges.parse(value));
    }

    public StringRanges(HeaderElement[] e) {
        AList<StringRange> l = AList.of();
        for (HeaderElement e2 : e) {
            l.add(new StringRange(e2));
        }
        l.sort(RANGE_COMPARATOR);
        this.ranges = l.toArray(new StringRange[l.size()]);
        this.string = this.ranges.length == 1 ? this.ranges[0].toString() : StringUtils.join(l, ',');
    }

    public int match(List<String> names) {
        StringRange mr;
        float q2;
        if (this.string.isEmpty()) {
            return -1;
        }
        int matchQuant = 0;
        int matchIndex = -1;
        float q = 0.0f;
        StringRange[] stringRangeArray = this.ranges;
        int n = stringRangeArray.length;
        for (int i = 0; i < n && !((q2 = (mr = stringRangeArray[i]).getQValue().floatValue()) < q) && q2 != 0.0f; ++i) {
            for (int i2 = 0; i2 < names.size(); ++i2) {
                String mt = names.get(i2);
                int matchQuant2 = mr.match(mt);
                if (matchQuant2 <= matchQuant) continue;
                matchIndex = i2;
                matchQuant = matchQuant2;
                q = q2;
            }
        }
        return matchIndex;
    }

    public StringRange getRange(int index) {
        if (index < 0 || index >= this.ranges.length) {
            return null;
        }
        return this.ranges[index];
    }

    public List<StringRange> getRanges() {
        return Collections.unmodifiableList(Arrays.asList(this.ranges));
    }

    private static HeaderElement[] parse(String value) {
        return BasicHeaderValueParser.parseElements((String)StringUtils.emptyIfNull(StringUtils.trim(value)), null);
    }

    public String toString() {
        return this.string;
    }
}

