/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock2;

import java.util.Collections;
import java.util.Map;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.internal.StateMachineState;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.util.UrlPathPattern;

class MockPathResolver {
    private String uri;
    private String target;
    private String contextPath;
    private String servletPath;
    private String remainder;
    private String error;

    public MockPathResolver(String target, String contextPath, String servletPath, String pathToResolve, Map<String, Object> pathVars) {
        try {
            this.init(target, contextPath, servletPath, pathToResolve, pathVars);
        }
        catch (Exception e) {
            this.error = e.getLocalizedMessage();
        }
    }

    private void init(String target, String contextPath, String servletPath, String pathToResolve, Map<String, Object> pathVars) {
        UrlPathPattern p;
        if ((target = StringUtils.trimTrailingSlashes((String)StringUtils.emptyIfNull((String)target))).isEmpty()) {
            target = "http://localhost";
        }
        contextPath = MockPathResolver.fixSegment(contextPath, pathVars);
        servletPath = MockPathResolver.fixSegment(servletPath, pathVars);
        if (!(pathToResolve = StringUtils.emptyIfNull((String)pathToResolve)).startsWith("http://") && !pathToResolve.startsWith("https://")) {
            pathToResolve = MockPathResolver.fixSegment(pathToResolve, Collections.emptyMap());
            this.uri = target + contextPath + servletPath + pathToResolve;
            this.target = target;
            this.contextPath = contextPath;
            this.servletPath = servletPath;
            this.remainder = pathToResolve;
            return;
        }
        this.uri = pathToResolve;
        StateMachineState state = StateMachineState.S03;
        int cpSegments = StringUtils.countChars((String)contextPath, (char)'/');
        int spSegments = StringUtils.countChars((String)servletPath, (char)'/');
        this.contextPath = "";
        this.servletPath = "";
        this.remainder = "";
        int mark = 0;
        for (int i = this.uri.indexOf("://") + 3; i < this.uri.length(); ++i) {
            char c = this.uri.charAt(i);
            if (state == StateMachineState.S03) {
                if (c == '/') break;
                state = StateMachineState.S04;
                continue;
            }
            if (state == StateMachineState.S04) {
                if (c != '/') continue;
                this.target = this.uri.substring(0, i);
                state = StateMachineState.S05;
                if (contextPath.isEmpty()) {
                    state = StateMachineState.S06;
                    if (servletPath.isEmpty()) {
                        state = StateMachineState.S07;
                    }
                }
                mark = i;
                continue;
            }
            if (state == StateMachineState.S05) {
                if (c != '/' || --cpSegments != 0) continue;
                this.contextPath = this.uri.substring(mark, i);
                mark = i;
                state = StateMachineState.S06;
                if (!servletPath.isEmpty()) continue;
                state = StateMachineState.S07;
                continue;
            }
            if (state != StateMachineState.S06 || c != '/' || --spSegments != 0) continue;
            this.servletPath = this.uri.substring(mark, i);
            mark = i;
            state = StateMachineState.S07;
        }
        if (state == StateMachineState.S04) {
            this.target = this.uri;
        } else if (state == StateMachineState.S05) {
            this.contextPath = this.uri.substring(mark);
        } else if (state == StateMachineState.S06) {
            this.servletPath = this.uri.substring(mark);
        } else if (state == StateMachineState.S07) {
            this.remainder = this.uri.substring(mark);
        } else {
            throw new RuntimeException("Invalid URI pattern encountered:  " + this.uri);
        }
        if (!contextPath.isEmpty() && (p = new UrlPathPattern(contextPath)).match(this.contextPath) == null) {
            throw new RuntimeException("Context path [" + contextPath + "] not found in URI:  " + this.uri);
        }
        if (!servletPath.isEmpty() && (p = new UrlPathPattern(servletPath)).match(this.servletPath) == null) {
            throw new RuntimeException("Servlet path [" + servletPath + "] not found in URI:  " + this.uri);
        }
    }

    private static String fixSegment(String s, Map<String, Object> pathVars) {
        if ((s = StringUtils.replaceVars((String)StringUtils.emptyIfNull((String)s), pathVars)).isEmpty() || s.equals("/")) {
            return "";
        }
        if ((s = StringUtils.trimTrailingSlashes((String)s)).charAt(0) != '/') {
            s = '/' + s;
        }
        return s;
    }

    public String getURI() {
        return this.uri;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getRemainder() {
        return this.remainder;
    }

    public String getTarget() {
        return this.target;
    }

    public String getError() {
        return this.error;
    }

    public String toString() {
        return OMap.of().a("uri", (Object)this.uri).a("contextPath", (Object)this.contextPath).a("servletPath", (Object)this.servletPath).a("remainder", (Object)this.remainder).a("target", (Object)this.target).a("error", (Object)this.error).toString();
    }
}

