/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.store;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.Context;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.config.store.WatcherSensitivity;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.utils.HashKey;

public class FileStore
extends ConfigStore {
    public static final FileStore DEFAULT = FileStore.create().build();
    final String directory;
    final String extensions;
    final Charset charset;
    final boolean enableWatcher;
    final boolean updateOnWrite;
    final WatcherSensitivity watcherSensitivity;
    private final File dir;
    private final WatcherThread watcher;
    private final ConcurrentHashMap<String, String> cache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> nameCache = new ConcurrentHashMap();
    private final String[] exts;

    public static Builder create() {
        return new Builder();
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    public FileStore(Builder builder) {
        super(builder);
        this.directory = builder.directory;
        this.extensions = builder.extensions;
        this.charset = builder.charset;
        this.enableWatcher = builder.enableWatcher;
        this.updateOnWrite = builder.updateOnWrite;
        this.watcherSensitivity = builder.watcherSensitivity;
        try {
            this.dir = new File(this.directory).getCanonicalFile();
            this.dir.mkdirs();
            this.exts = StringUtils.split(this.extensions);
            WatcherThread watcherThread = this.watcher = this.enableWatcher ? new WatcherThread(this.dir, this.watcherSensitivity) : null;
            if (this.watcher != null) {
                this.watcher.start();
            }
        }
        catch (Exception e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }

    @Override
    public synchronized String read(String name) throws IOException {
        OpenOption[] openOptionArray;
        name = this.resolveName(name);
        Path p = this.resolveFile(name);
        String s = this.cache.get(name = p.getFileName().toString());
        if (s != null) {
            return s;
        }
        this.dir.mkdirs();
        if (!Files.exists(p, new LinkOption[0])) {
            return "";
        }
        boolean isWritable = this.isWritable(p);
        if (isWritable) {
            OpenOption[] openOptionArray2 = new OpenOption[3];
            openOptionArray2[0] = StandardOpenOption.READ;
            openOptionArray2[1] = StandardOpenOption.WRITE;
            openOptionArray = openOptionArray2;
            openOptionArray2[2] = StandardOpenOption.CREATE;
        } else {
            OpenOption[] openOptionArray3 = new OpenOption[1];
            openOptionArray = openOptionArray3;
            openOptionArray3[0] = StandardOpenOption.READ;
        }
        OpenOption[] oo = openOptionArray;
        try (FileChannel fc = FileChannel.open(p, oo);
             FileLock lock = isWritable ? fc.lock() : null;){
            ByteBuffer buf = ByteBuffer.allocate(1024);
            StringBuilder sb = new StringBuilder();
            while (fc.read(buf) != -1) {
                sb.append(this.charset.decode((ByteBuffer)((Buffer)buf).flip()));
                ((Buffer)buf).clear();
            }
            s = sb.toString();
            this.cache.put(name, s);
        }
        return this.cache.get(name);
    }

    @Override
    public synchronized String write(String name, String expectedContents, String newContents) throws IOException {
        name = this.resolveName(name);
        if (StringUtils.eq(expectedContents, newContents)) {
            return null;
        }
        this.dir.mkdirs();
        Path p = this.resolveFile(name);
        name = p.getFileName().toString();
        boolean exists = Files.exists(p, new LinkOption[0]);
        if (!exists && StringUtils.isNotEmpty(expectedContents)) {
            return "";
        }
        if (this.isWritable(p)) {
            if (newContents == null) {
                Files.delete(p);
            } else {
                try (FileChannel fc = FileChannel.open(p, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                     FileLock lock = fc.lock();){
                    String currentContents = "";
                    if (exists) {
                        ByteBuffer buf = ByteBuffer.allocate(1024);
                        StringBuilder sb = new StringBuilder();
                        while (fc.read(buf) != -1) {
                            sb.append(this.charset.decode((ByteBuffer)((Buffer)buf).flip()));
                            ((Buffer)buf).clear();
                        }
                        currentContents = sb.toString();
                    }
                    if (expectedContents != null && !StringUtils.eq(currentContents, expectedContents)) {
                        if (currentContents == null) {
                            this.cache.remove(name);
                        } else {
                            this.cache.put(name, currentContents);
                        }
                        String string = currentContents;
                        return string;
                    }
                    fc.position(0L);
                    fc.write(this.charset.encode(newContents));
                }
            }
        }
        if (this.updateOnWrite) {
            this.update(name, newContents);
        } else {
            this.cache.remove(name);
        }
        return null;
    }

    @Override
    public synchronized boolean exists(String name) {
        return Files.exists(this.resolveFile(name), new LinkOption[0]);
    }

    private Path resolveFile(String name) {
        return this.dir.toPath().resolve(this.resolveName(name));
    }

    @Override
    protected String resolveName(String name) {
        if (!this.nameCache.containsKey(name)) {
            String n = null;
            if (FileUtils.exists(this.dir, name)) {
                n = name;
            }
            if (n == null) {
                for (String ext : this.exts) {
                    if (!FileUtils.hasExtension(name, ext)) continue;
                    n = name;
                    break;
                }
            }
            if (n == null) {
                for (String ext : this.exts) {
                    if (!FileUtils.exists(this.dir, name + '.' + ext)) continue;
                    n = name + '.' + ext;
                    break;
                }
            }
            if (n == null) {
                n = this.exts.length == 0 ? name : name + "." + this.exts[0];
            }
            this.nameCache.put(name, n);
        }
        return this.nameCache.get(name);
    }

    private synchronized boolean isWritable(Path p) {
        try {
            if (!Files.exists(p, new LinkOption[0])) {
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                if (!Files.exists(p, new LinkOption[0])) {
                    p.toFile().createNewFile();
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        return Files.isWritable(p);
    }

    @Override
    public synchronized FileStore update(String name, String newContents) {
        this.cache.put(name, newContents);
        super.update(name, newContents);
        return this;
    }

    @Override
    public synchronized void close() {
        if (this.watcher != null) {
            this.watcher.interrupt();
        }
    }

    protected synchronized void onFileEvent(WatchEvent<Path> e) throws IOException {
        String fn = e.context().getFileName().toString();
        String oldContents = this.cache.get(fn);
        this.cache.remove(fn);
        String newContents = this.read(fn);
        if (!StringUtils.eq(oldContents, newContents)) {
            this.update(fn, newContents);
        }
    }

    @Override
    protected JsonMap properties() {
        return JsonMap.filteredMap("charset", this.charset, "extensions", this.extensions, "updateOnWrite", this.updateOnWrite);
    }

    final class WatcherThread
    extends Thread {
        private final WatchService watchService = FileSystems.getDefault().newWatchService();

        WatcherThread(File dir, WatcherSensitivity s) throws Exception {
            WatchEvent.Kind[] kinds = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
            WatchEvent.Modifier modifier = this.lookupModifier(s);
            dir.toPath().register(this.watchService, kinds, modifier);
        }

        private WatchEvent.Modifier lookupModifier(WatcherSensitivity s) {
            try {
                switch (s) {
                    case LOW: {
                        return SensitivityWatchEventModifier.LOW;
                    }
                    case MEDIUM: {
                        return SensitivityWatchEventModifier.MEDIUM;
                    }
                    case HIGH: {
                        return SensitivityWatchEventModifier.HIGH;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void run() {
            try {
                WatchKey key;
                while ((key = this.watchService.take()) != null) {
                    for (WatchEvent<Path> watchEvent : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = watchEvent.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        FileStore.this.onFileEvent(watchEvent);
                    }
                    if (key.reset()) continue;
                    break;
                }
            }
            catch (Exception e) {
                throw ThrowableUtils.runtimeException(e);
            }
        }

        @Override
        public void interrupt() {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                throw ThrowableUtils.runtimeException(e);
            }
            finally {
                super.interrupt();
            }
        }
    }

    @FluentSetters
    public static class Builder
    extends ConfigStore.Builder {
        String directory;
        String extensions;
        Charset charset;
        boolean enableWatcher;
        boolean updateOnWrite;
        WatcherSensitivity watcherSensitivity;

        protected Builder() {
            this.directory = this.env("ConfigFileStore.directory", ".");
            this.charset = this.env("ConfigFileStore.charset", Charset.defaultCharset());
            this.enableWatcher = this.env("ConfigFileStore.enableWatcher", false);
            this.watcherSensitivity = this.env("ConfigFileStore.watcherSensitivity", WatcherSensitivity.MEDIUM);
            this.updateOnWrite = this.env("ConfigFileStore.updateOnWrite", false);
            this.extensions = this.env("ConfigFileStore.extensions", "cfg");
        }

        protected Builder(FileStore copyFrom) {
            super(copyFrom);
            this.type(copyFrom.getClass());
            this.directory = copyFrom.directory;
            this.charset = copyFrom.charset;
            this.enableWatcher = copyFrom.enableWatcher;
            this.watcherSensitivity = copyFrom.watcherSensitivity;
            this.updateOnWrite = copyFrom.updateOnWrite;
            this.extensions = copyFrom.extensions;
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.directory = copyFrom.directory;
            this.charset = copyFrom.charset;
            this.enableWatcher = copyFrom.enableWatcher;
            this.watcherSensitivity = copyFrom.watcherSensitivity;
            this.updateOnWrite = copyFrom.updateOnWrite;
            this.extensions = copyFrom.extensions;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public FileStore build() {
            return this.build(FileStore.class);
        }

        public Builder directory(String value) {
            this.directory = value;
            return this;
        }

        public Builder directory(File value) {
            this.directory = value.getAbsolutePath();
            return this;
        }

        public Builder charset(Charset value) {
            this.charset = value;
            return this;
        }

        public Builder enableWatcher() {
            this.enableWatcher = true;
            return this;
        }

        public Builder watcherSensitivity(WatcherSensitivity value) {
            this.watcherSensitivity = value;
            return this;
        }

        public Builder updateOnWrite() {
            this.updateOnWrite = true;
            return this;
        }

        public Builder extensions(String value) {
            this.extensions = value;
            return this;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations((Class[])fromClasses);
            return this;
        }

        @Override
        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }
    }
}

