/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.converter;

import org.apache.juneau.BeanSession;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.objecttools.ObjectRest;
import org.apache.juneau.objecttools.ObjectRestException;
import org.apache.juneau.parser.ParserMatch;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.rest.HttpRuntimeException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.converter.RestConverter;
import org.apache.juneau.swap.ObjectSwap;

public final class Traversable
implements RestConverter {
    @Override
    public Object convert(RestRequest req, Object o) throws BasicHttpException, InternalServerError {
        if (o == null) {
            return null;
        }
        String pathRemainder = req.getPathRemainder().orElse(null);
        if (pathRemainder != null) {
            try {
                BeanSession bs = req.getBeanSession();
                ObjectSwap<Object, ?> swap = bs.getClassMetaForObject(o).getSwap(bs);
                if (swap != null) {
                    o = swap.swap(bs, o);
                }
                ReaderParser rp = req.getContent().getParserMatch().map(ParserMatch::getParser).filter(ReaderParser.class::isInstance).map(ReaderParser.class::cast).orElse(null);
                ObjectRest or = ObjectRest.create(o, rp);
                o = or.get(pathRemainder);
            }
            catch (ObjectRestException e) {
                throw new BasicHttpException(e.getStatus(), (Throwable)e);
            }
            catch (Throwable t) {
                throw HttpRuntimeException.toHttpException(t, InternalServerError.class);
            }
        }
        return o;
    }
}

