/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.lang.reflect.InvocationTargetException;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.serializer.SerializerSession;

public class SerializeException
extends BasicRuntimeException {
    private static final long serialVersionUID = 1L;

    public static SerializeException create(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getCause();
        }
        if (e instanceof SerializeException) {
            return (SerializeException)e;
        }
        return new SerializeException(e);
    }

    public SerializeException(SerializerSession session, String message, Object ... args) {
        super(SerializeException.getMessage(session, message, args), new Object[0]);
    }

    public SerializeException(String message, Object ... args) {
        super(SerializeException.getMessage(null, message, args), new Object[0]);
    }

    public SerializeException(SerializerSession session, Exception causedBy) {
        super(causedBy, SerializeException.getMessage(session, causedBy.getMessage(), new Object[0]), new Object[0]);
    }

    public SerializeException(Throwable causedBy) {
        super(causedBy, SerializeException.getMessage(null, causedBy.getMessage(), new Object[0]), new Object[0]);
    }

    private static String getMessage(SerializerSession session, String msg, Object ... args) {
        JsonMap m;
        msg = StringUtils.format(msg, args);
        if (session != null && (m = session.getLastLocation()) != null && !m.isEmpty()) {
            msg = "Serialize exception occurred at " + SimpleJsonSerializer.DEFAULT.toString(m) + ".  " + msg;
        }
        return msg;
    }

    public SerializeException getRootCause() {
        SerializeException t = this;
        while (t.getCause() != null && t.getCause() instanceof SerializeException) {
            t = (SerializeException)t.getCause();
        }
        return t;
    }

    @Override
    public synchronized SerializeException initCause(Throwable cause) {
        super.initCause(cause);
        return this;
    }
}

