/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.annotation.SchemaAnnotation;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.annotation.TargetedAnnotationTMBuilder;
import org.apache.juneau.http.annotation.Content;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class ContentAnnotation {
    public static final Content DEFAULT = ContentAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return ContentAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return ContentAnnotation.create().on(on);
    }

    public static boolean empty(Content a) {
        return a == null || DEFAULT.equals(a);
    }

    public static class Builder
    extends TargetedAnnotationTMBuilder {
        Schema schema = SchemaAnnotation.DEFAULT;

        protected Builder() {
            super(Content.class);
        }

        public Content build() {
            return new Impl(this);
        }

        public Builder schema(Schema value) {
            this.schema = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Content[] value();
    }

    public static class Applier
    extends AnnotationApplier<Content, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Content.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Content> ai, BeanContext.Builder b) {
            Content a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on(), a.onClass())) {
                return;
            }
            b.annotations(a);
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements Content {
        private final Schema schema;

        Impl(Builder b) {
            super(b);
            this.schema = b.schema;
            this.postConstruct();
        }

        @Override
        public Schema schema() {
            return this.schema;
        }
    }
}

