/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.header.BasicHeader;

public class BasicCsvHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final String[] value;
    private final Supplier<String[]> supplier;

    public static BasicCsvHeader of(String name, String value) {
        return value == null ? null : new BasicCsvHeader(name, value);
    }

    public static BasicCsvHeader of(String name, String ... value) {
        return value == null ? null : new BasicCsvHeader(name, value);
    }

    public static BasicCsvHeader of(String name, Supplier<String[]> value) {
        return value == null ? null : new BasicCsvHeader(name, value);
    }

    public BasicCsvHeader(String name, String value) {
        super(name, value);
        this.value = StringUtils.splita(value);
        this.supplier = null;
    }

    public BasicCsvHeader(String name, String ... value) {
        super(name, StringUtils.join((Object[])value, ", "));
        this.value = CollectionUtils.copyOf(value);
        this.supplier = null;
    }

    public BasicCsvHeader(String name, Supplier<String[]> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    public Optional<String[]> asArray() {
        return Utils.opt(CollectionUtils.copyOf(this.value()));
    }

    public Optional<List<String>> asList() {
        return Utils.opt(CollectionUtils.u(CollectionUtils.l(this.value())));
    }

    public FluentListAssertion<String, BasicCsvHeader> assertList() {
        return new FluentListAssertion<String, BasicCsvHeader>(CollectionUtils.u(CollectionUtils.l(this.value())), this);
    }

    public boolean contains(String val) {
        String[] value2;
        if (Utils.nn(this.value)) {
            for (String v : this.value) {
                if (!Utils.eq(v, val)) continue;
                return true;
            }
        }
        if (Utils.nn(this.supplier) && Utils.nn(value2 = this.supplier.get())) {
            for (String v : this.supplier.get()) {
                if (!Utils.eq(v, val)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsIgnoreCase(String val) {
        String[] value2;
        if (Utils.nn(this.value)) {
            for (String v : this.value) {
                if (!Utils.eqic(v, val)) continue;
                return true;
            }
        }
        if (Utils.nn(this.supplier) && Utils.nn(value2 = this.supplier.get())) {
            for (String v : this.supplier.get()) {
                if (!Utils.eqic(v, val)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getValue() {
        return StringUtils.join((Object[])this.value(), ", ");
    }

    public String[] orElse(String[] other) {
        String[] x = this.value();
        return Utils.nn(x) ? x : other;
    }

    public String[] toArray() {
        return CollectionUtils.copyOf(this.value());
    }

    public List<String> toList() {
        return CollectionUtils.u(CollectionUtils.l(this.value()));
    }

    private String[] value() {
        if (Utils.nn(this.supplier)) {
            return this.supplier.get();
        }
        return this.value;
    }
}

