/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.help;

import aQute.bnd.build.model.BndEditModel;
import aQute.bnd.help.ProcessorHandler;
import aQute.bnd.help.SyntaxAnnotation;
import aQute.bnd.help.instructions.BuilderInstructions;
import aQute.bnd.help.instructions.LauncherInstructions;
import aQute.bnd.help.instructions.ResolutionInstructions;
import aQute.bnd.osgi.Constants;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.unmodifiable.Maps;
import aQute.bnd.version.Version;
import aQute.lib.strings.Strings;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;

public class Syntax
implements Constants {
    final String header;
    final String lead;
    final String example;
    final Pattern pattern;
    final String values;
    final Syntax[] children;
    static Syntax version = new Syntax("version", "A version range to select the version of an export definition. The default value is 0.0.0.", "version=\"[1.2,3.0)\"", null, Verifier.VERSIONRANGE, new Syntax[0]);
    static Syntax bundle_symbolic_name = new Syntax("bundle-symbolic-name", "The bundle symbolic name of the exporting bundle.", "bundle-symbolic-name=com.acme.foo.daffy", null, Verifier.SYMBOLICNAME, new Syntax[0]);
    static Syntax bundle_version = new Syntax("bundle-version", "A version range to select the bundle version of the exporting bundle. The default value is 0.0.0.", "bundle-version=1.3", null, Verifier.VERSIONRANGE, new Syntax[0]);
    static Syntax path_version = new Syntax("version", "Specifies the range in the repository, project or file.", "version=project", "project,type", Pattern.compile("project|type|" + Verifier.VERSIONRANGE.toString()), new Syntax[0]);
    static final Syntax[] syntaxes = new Syntax[]{new Syntax(".bnd", "Home directory usage (~/.bnd) in bnd.", null, null, null, new Syntax("build-deps", "Stores build dependencies of bnd from gradle, ant, etc. In general, bnd will be among this. The files in this directory must be fully versioned", "~/.bnd/biz.aQute.bnd-2.2.0.jar", null, null, new Syntax[0]), new Syntax("settings.json", "Contains the settings used by bnd in json format. These settings are maintained by bnd command line (bnd help settings). These settings can be used through macros and can provide passwords, user ids, and platform specific settings. Names starting witha dot (.) are considered protected", "{\"id\":\"30...001\",\"map\":{\".github.secret\":\"xxxxxx\",\"github.user\":\"minime\",\"email\":\"Peter.Kriens@aQute.biz\"},\"secret\":\"308...CC56\"}", null, null, new Syntax("email", "The user's email address", null, null, null, new Syntax[0]), new Syntax("id", "The public key for this machine", null, null, null, new Syntax[0]), new Syntax("secret", "The private key for this machine", null, null, null, new Syntax[0])), new Syntax("caches/shas", "Directory with sha artifacts. The sha is the name of the directory, it contains the artifact with a normal bsn-version.jar name", null, null, null, new Syntax[0])), new Syntax("Automatic-Module-Name", "The module name of an automatic module is derived from the JAR file used to include the artifact if it has the attribute Automatic-Module-Name in its main manifest entry.", "Automatic-Module-Name: com.foo.bar", null, Verifier.SYMBOLICNAME, new Syntax[0]), new Syntax("-baseline", "The -baseline instruction controls what bundles are enabled for baselining and optionally specify the baseline version or file.", "-baseline: com.example.*", null, null, new Syntax[0]), new Syntax("Bnd-AddXMLToTest", "The Bnd-AddXMLToTest instruction adds XML resources from the tested bundle to the output of a test report.", "Bnd-AddXMLToTest: a.xml", null, null, new Syntax[0]), new Syntax("Bundle-ActivationPolicy", "The Bundle-ActivationPolicy header specifies how the framework should activate the bundle once started.", "Bundle-ActivationPolicy: lazy", "lazy", Pattern.compile("lazy"), new Syntax[0]), new Syntax("Bundle-Activator", "The Bundle-Activator header specifies the name of the class used to start and stop the bundle.", "Bundle-Activator: com.acme.foo.Activator", "${classes;implementing;org.osgi.framework.BundleActivator}", Verifier.FQNPATTERN, new Syntax[0]), new Syntax("Bundle-Blueprint", "The Bundle-Blueprint header specifies the location of the blueprint descriptor files in the bundle", "Bundle-Blueprint: /blueprint/*.xml", null, null, new Syntax[0]), new Syntax("Bundle-Category", "The Bundle-Category header holds a comma-separated list of category names.", "Bundle-Category: test", "osgi,test,game,util,eclipse,netbeans,jdk,specification", null, new Syntax[0]), new Syntax("Bundle-ClassPath", "The Bundle-ClassPath header defines a comma-separated list of JAR file path names or directories (inside the bundle) containing classes and resources. The period (\u2019.\u2019) specifies the root directory of the bundle\u2019s JAR. The period is also the default.", "Bundle-ClassPath: /lib/libnewgen.so, .", null, Verifier.PATHPATTERN, new Syntax[0]), new Syntax("Bundle-ContactAddress", "The Bundle-ContactAddress header provides the contact address of the vendor.", "Bundle-ContactAddress: 2400 Oswego Road, Austin, TX 74563", null, null, new Syntax[0]), new Syntax("Bundle-Developers", "Defines the primary developers of this bundle", "Bundle-Developers: Peter.Kriens@aQute.biz;name='Peter Kriens Ing';organization=aQute;organizationUrl='http://www.aQute.biz';roles=ceo;timezone=+1", null, null, new Syntax[0]), new Syntax("Bundle-SCM", "Defines the information about the source code of the bundle", "Bundle-SCM: url=https://github.com/bndtools/bnd, connection=scm:git:https://github.com/bndtools/bnd.git, developerConnection=scm:git:git@github.com:bndtools/bnd.git", null, null, new Syntax[0]), new Syntax("Bundle-Contributors", "Defines the people that contrbuted to this bundle", "Bundle-Contributors: Peter.Kriens@aQute.biz;name='Peter Kriens Ing';organization=aQute;organizationUrl='http://www.aQute.biz';roles=ceo;timezone=+1", null, null, new Syntax("name", "The display name of the developer", "name='Peter Kriens'", null, null, new Syntax[0]), new Syntax("organization", "The display name of organization that employs the developer", "organization='aQute'", null, null, new Syntax[0]), new Syntax("roles", "Roles played by the developer in this bundle's project (see Maven)", "roles=ceo", null, null, new Syntax[0]), new Syntax("timezone", "Timezone in offset of UTC this developer usually resides in", "timezone+2", null, null, new Syntax[0]), new Syntax("organizationUrl", "The URL of the developer's organization", "organizationURL='http://www.aQute.biz'", null, null, new Syntax[0])), new Syntax("Bundle-Copyright", "The Bundle-Copyright header contains the copyright specification for this bundle.", "Bundle-Copyright: OSGi (c) 2002", null, null, new Syntax[0]), new Syntax("Bundle-Description", "The Bundle-Description header defines a short description of this bundle.", "Bundle-Description: Ceci ce n'est pas une bundle", null, null, new Syntax[0]), new Syntax("Bundle-DocURL", "The Bundle-DocURL header must contain a URL pointing to documentation about this bundle.", "Bundle-DocURL: http://www.aQute.biz/Code/Bnd", null, Verifier.URLPATTERN, new Syntax[0]), new Syntax("Bundle-Icon", "The optional Bundle-Icon header provides a list of (relative) URLs to icons representing this bundle in different sizes.", "Bundle-Icon: /icons/bnd.png;size=64", "/icons/bundle.png", Verifier.URLPATTERN, new Syntax("size", "Icons size in pixels, e.g. 64.", "size=64", "16,32,48,64,128", Verifier.NUMBERPATTERN, new Syntax[0])), new Syntax("Bundle-License", "The Bundle-License header provides an optional machine readable form of license information. The purpose of this header is to automate some of the license processing required by many organizations.", "Bundle-License: http://www.opensource.org/licenses/jabberpl.php", "http://www.apache.org/licenses/LICENSE-2.0,<<EXTERNAL>>", Pattern.compile("(" + Verifier.URLPATTERN + "|<<EXTERNAL>>)"), new Syntax("description", "Human readable description of the license.", "description=\"Describe the license here\"", null, Verifier.ANYPATTERN, new Syntax[0]), new Syntax("link", "", "", null, Verifier.URLPATTERN, new Syntax[0])), new Syntax("Bundle-Localization", "The Bundle-Localization header contains the location in the bundle where localization files can be found. The default value is OSGI-INF/l10n/bundle. Translations are by default therefore OSGI-INF/l10n/bundle_de.properties, OSGI-INF/l10n/bundle_nl.properties, etc.", "Bundle-Localization: OSGI-INF/l10n/bundle", "OSGI-INF/l10n/bundle", Verifier.URLPATTERN, new Syntax[0]), new Syntax("Bundle-ManifestVersion", "The Bundle-ManifestVersion header is set by bnd automatically to 2. The header defines that the bundle follows the rules of this specification.", "# Bundle-ManifestVersion: 2", "2", Verifier.NUMBERPATTERN, new Syntax[0]), new Syntax("Bundle-Name", "The Bundle-Name header will be derived from the Bundle-SymbolicName header if not set. The Bundle-Name header defines a readable name for this bundle. This should be a short, human-readable name that can contain spaces.", "Bundle-Name: My Bundle", null, Verifier.ANYPATTERN, new Syntax[0]), new Syntax("Bundle-NativeCode", "The Bundle-NativeCode header contains a specification of native code libraries contained in this bundle.", "Bundle-NativeCode: /lib/http.DLL; osname = QNX; osversion = 3.1", null, Verifier.PATHPATTERN, new Syntax("osname", "The name of the operating system.", "osname=MacOS", Processor.join(Verifier.OSNAMES, ","), Verifier.ANYPATTERN, new Syntax[0]), new Syntax("osversion", "Operating System Version.", "osversion=3.1", null, Verifier.ANYPATTERN, new Syntax[0]), new Syntax("language", "Language ISO 639 code.", "language=nl", null, Verifier.ISO639, new Syntax[0]), new Syntax("processor", "Processor name.", "processor=x86", Processor.join(Verifier.PROCESSORNAMES, ","), Verifier.ANYPATTERN, new Syntax[0]), new Syntax("selection-filter", "The value of this attribute must be a filter expression that indicates if the native code clause should be selected or not.", "selection-filter=\"(com.acme.windowing=win32)\"", null, Verifier.FILTERPATTERN, new Syntax[0])), new Syntax("Bundle-RequiredExecutionEnvironment", "The Bundle-RequiredExecutionEnvironment contains a comma-separated list of execution environments that must be present on the Service Platform.", "Bundle-RequiredExecutionEnvironment: CDC-1.0/Foundation-1.0", Processor.join(Verifier.EES, ","), Verifier.ANYPATTERN, new Syntax[0]), new Syntax("Bundle-SymbolicName", "The Bundle-SymbolicName header specifies a non-localizable name for this bundle. The bundle symbolic name together with a version must identify a unique bundle. The bundle symbolic name should be based on the reverse domain name convention.", "Bundle-SymbolicName: com.acme.foo.daffy;singleton:=true", "${p}", Verifier.SYMBOLICNAME, new Syntax("singleton:", "Indicates that the bundle can only have a single version resolved. A value of true indicates that the bundle is a singleton bundle. The default value is false. The Framework must resolve at most one bundle when multiple versions of a singleton bundle with the same symbolic name are installed. Singleton bundles do not affect the resolution of non-singleton bundles with the same symbolic name.", "singleton:=false", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("fragment-attachment:", "Defines how fragments are allowed to be attached, see the fragments in Fragment Bundles on page 73. The following values are valid for this directive:", "", "always|never|resolve-time", Pattern.compile("always|never|resolve-time"), new Syntax[0]), new Syntax("blueprint.wait-for-dependencies", "", "", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("blueprint.timeout", "", "", "30000,60000,300000", Verifier.NUMBERPATTERN, new Syntax[0])), new Syntax("Bundle-UpdateLocation", "The Bundle-UpdateLocation header specifies a URL where an update for this bundle should come from. If the bundle is updated, this location should be used, if present, to retrieve the updated JAR file.", "Bundle-UpdateLocation: http://www.acme.com/Firewall/bundle.jar", null, Verifier.URLPATTERN, new Syntax[0]), new Syntax("Bundle-Vendor", "The Bundle-Vendor header contains a human-readable description of the bundle vendor.", "Bundle-Vendor: OSGi Alliance", null, null, new Syntax[0]), new Syntax("Bundle-Version", "The Bundle-Version header specifies the version of this bundle.", "Bundle-Version: 1.23.4.build200903221000", null, Verifier.VERSION, new Syntax[0]), new Syntax("-classpath", "The -classpath instruction adds class path entries to a bnd file\u2019s processing.", "-baseline: jar/foo.jar, jar/bar.jar", null, null, new Syntax[0]), new Syntax("-compression", "Set the compression for writing JARs. Default is deflate", "-compression=store", "deflate,store", Pattern.compile("deflate|store"), new Syntax[0]), new Syntax("DynamicImport-Package", "The DynamicImport-Package header contains a comma-separated list of package names that should be dynamically imported when needed.", "DynamicImport-Package: com.acme.plugin.*", "", Verifier.WILDCARDNAMEPATTERN, version, bundle_symbolic_name, bundle_version), new Syntax("Export-Package", "The Export-Package header contains a declaration of exported packages.", "Export-Package: org.osgi.util.tracker;version=1.3", "${packages}", null, new Syntax("-noimport:", "By default, bnd makes all exports also imports. Adding a -noimport: to an exported package will make it export only.", "-noimport:=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("uses:", "Calculated by bnd: It is a comma-separated list of package names that are used by the exported package.", "Is calculated by bnd", null, null, new Syntax[0]), new Syntax("mandatory:", "A comma-separated list of attribute names. Note that the use of a comma in the value requires it to be enclosed in double quotes. A bundle importing the package must specify the mandatory attributes, with a value that matches, to resolve to the exported package.", "mandatory:=\"bar,foo\"", null, null, new Syntax[0]), new Syntax("include:", "A comma-separated list of class names that must be visible to an importer.", "include:=\"Qux*\"", null, null, new Syntax[0]), new Syntax("exclude:", "A comma-separated list of class names that must not be visible to an importer.", "exclude:=\"QuxImpl*,BarImpl\"", null, Verifier.WILDCARDNAMEPATTERN, new Syntax[0]), new Syntax("-import:", "Experimental.", "", null, null, new Syntax[0])), new Syntax("Test-Cases", "The Test-Cases instruction is used to specify the list of test cases to run.", "Test-Cases: com.foo.bar.MyTest", null, Verifier.FQNPATTERN, new Syntax[0]), new Syntax("Conditional-Package", "The Conditional-Package works as private package but will only include the packages when they are imported. When this header is used, bnd will recursively add packages that match the patterns until there are no more additions.", "Conditional-Package: com.*", "${packages}", null, new Syntax[0]), new Syntax("-conditionalpackage", "The -conditionalpackage works as private package but will only include the packages when they are imported. When this header is used, bnd will recursively add packages that match the patterns until there are no more additions.", "-conditionalpackage: com.*", "${packages}", null, new Syntax[0]), new Syntax("Meta-Persistence", "A bundle is regarded as a persistence bundle if it contains the header Meta-Persistence in it's Manifest.", "Meta-Persistence: persistence/myPu.xml", null, null, new Syntax[0]), new Syntax("-privatepackage", "The -privatepackage header contains a declaration of packages to be included in the resulting bundle, the only difference is, is that these packages will not be exported.", "-privatepackage: com.example.*, foo.bar", "${packages}", null, new Syntax[0]), new Syntax("Private-Package", "The Private-Package header contains a declaration of packages to be included in the resulting bundle, the only difference is, is that these packages will not be exported.", "Private-Package: com.*", "${packages}", null, new Syntax[0]), new Syntax("Ignore-Package", "The Ignore-Package is used to ignore a package from being packaged inside the bundle.", "Ignore-Package: com.foo.bar", "${packages}", null, new Syntax[0]), new Syntax("Export-Service", "Deprecated.", "Export-Service: org.osgi.service.log.LogService", "${classes;implementing;*}", null, new Syntax[0]), new Syntax("Fragment-Host", "The Fragment-Host header defines the host bundle for this fragment.", "Fragment-Host: org.eclipse.swt; bundle-version=\"[3.0.0,4.0.0)\"", null, null, new Syntax("extension:", "Indicates this extension is a system or boot class path extension. It is only applicable when the Fragment-Host is the System Bundle.", "extension:=framework", "framework,bootclasspath", Pattern.compile("framework|bootclasspath"), new Syntax[0]), bundle_version), new Syntax("Import-Package", "The Import-Package header is normally calculated by bnd, however, you can decorate packages or skip packages. The header declares the imported packages for this bundle.", "Import-Package: !com.exotic.*, com.acme.foo;vendor=ACME, *", "${exported_packages}", Verifier.WILDCARDNAMEPATTERN, new Syntax("-remove-attribute:", "Remove the given attributes from matching imported packages.", "-remove-attribute:=foo.*", null, Verifier.WILDCARDNAMEPATTERN, new Syntax[0]), new Syntax("resolution:", "Indicates that the packages must be resolved if the value is mandatory, which is the default. If mandatory packages cannot be resolved, then the bundle must fail to resolve. A value of optional indicates that the packages are optional.", "resolution:=optional", "mandatory,optional", Pattern.compile("mandatory|optional"), new Syntax[0]), version, bundle_symbolic_name, bundle_version), new Syntax("-library", "The -library instruction includes a library. A library is included in a bundle in a repository. It is identified by a capability, a bundle can contain multiple libraries. When used in a workspace, it will include the `workspace.bnd` file from the library by default. For a project, this is `project.bnd`. The `include` attribute can identify a file in the library. Libraries are versioned independently from the bundle. The library can contain additional files, also binary.", "-library: foo;version=1.2.3", null, null, new Syntax[0]), new Syntax("Require-Bundle", "The Require-Bundle header specifies the required exports from another bundle.", "Require-Bundle: com.acme.chess", null, Verifier.WILDCARDNAMEPATTERN, new Syntax("visibility:", "If the value is private (Default), then all visible packages from the required bundles are not re-exported. If the value is reexport then bundles that require this bundle will transitively have access to these required bundle\u2019s exported packages.", "visibility:=private", "private,reexport", Pattern.compile("private|reexport"), new Syntax[0]), new Syntax("resolution:", "If the value is mandatory (default) then the required bundle must exist for this bundle to resolve. If the value is optional, the bundle will resolve even if the required bundle does not exist.", "resolution:=optional", "mandatory,optional", Pattern.compile("mandatory|optional"), new Syntax[0]), new Syntax("-split-package:", "Indicates how an imported package should be merged when it is split between different exporters. The default is merge-first with warning.", "-split-package:=merge-first", "merge-first,merge-last,error,first", Pattern.compile("merge-first|merge-last|error|first"), new Syntax[0]), bundle_version), new Syntax("Provide-Capability", "The Provide-Capability header specifies that a bundle provides a set of Capabilities, other bundles can use Require-Capability to match this capability.", "Provide-Capability: com.acme.dictionary; from:String=nl; to=de; version:Version=3.4", null, Verifier.WILDCARDNAMEPATTERN, new Syntax("effective:", "(resolve) Specifies the time a capabiltity is available, either resolve (default) or another name. The OSGi framework resolver only considers Capabilities without an effective directive or effective:=resolve. Capabilties with other values for the effective directive can be considered by an external agent.", "effective:=resolve", "resolve or another word", null, new Syntax[0]), new Syntax("uses:", "The uses directive lists package names that are used by this Capability. This information is intended to be used for uses constraints.", "uses:='foo,bar,baz'", null, null, new Syntax[0])), new Syntax("Require-Capability", "The Require-Capability header specifies that a bundle requires other bundles to provide a Capability, see Provide-Capability", "Require-Capability: com.microsoft; filter:='(&(api=win32)(version=7))'", null, Verifier.WILDCARDNAMEPATTERN, new Syntax("effective:", "(resolve) Specifies the time a Requirement is considered, either resolve (default) or another name. The OSGi framework resolver only considers Requirements without an effective directive or effective:=resolve. Other Requirements can be considered by an external agent. Additonal names for the effective directive should be registered with the OSGi Alliance.", "effective:=resolve", "resolve or another word", null, new Syntax[0]), new Syntax("resolution:", "(mandatory|optional) A mandatory Requirement forbids the bundle to resolve when the Requirement is not satisfied; an optional Requirement allows a bundle to resolve even if the Requirement is not satisfied. No wirings are created when this Requirement cannot be resolved, this can result in Class Not Found Exceptions when the bundle attempts to use a package that was not resolved because it was optional.", "resolution:=optional", "mandatory,optional", Pattern.compile("mandatory|optional"), new Syntax[0]), new Syntax("filter:", " (Filter) A filter expression that is asserted on the Capabilities belonging to the given namespace. The matching of the filter against the Capability is done on one Capability at a time. A filter like (&(a=1)(b=2)) matches only a Capability that specifies both attributes at the required value, not two capabilties that each specify one of the attributes correctly. A filter is optional, if no filter directive is specified the Requirement always matches.", "filter:= (&(a=1)(b=2))", null, null, new Syntax[0])), new Syntax("-augment", "The -augment instruction can be used to augment resources in the repositories. Augmenting is adding additional capabilities and requirements", "-augment: com.example.prime; capability:='osgi.extender; osgi.extender=osgi.component; version:Version=1.2'", null, Verifier.WILDCARDNAMEPATTERN, new Syntax("capability:", "This directive specifies a Provide-Capability instruction, this will therefore likely have to be quoted. Any number of clauses can be specified.", "capability:=osgi.extender; osgi.extender=osgi.component; version:Version=1.2", null, null, new Syntax[0]), new Syntax("requirement:", "The directive specifies a Require-Capability instruction", "requirement:=osgi.identity;filter:=\"(osgi.identity=a.b.c)\"", null, null, new Syntax[0]), new Syntax("version:", " A version range. If a single version is given it will be used as [<version>,\u221e). The version range can be prefixed with an \u2018@\u2019 for a consumer range (to the next major) or a provider range (to the next minor) when the \u2018@\u2019 is a suffix of the version. The range can restrict the augmentation to a limited set of bundles.", null, null, null, new Syntax[0])), new Syntax("-buildpath", "Provides the class path for building the jar. The entries are references to the repository.", "-buildpath=osgi;version=4.1", "${repo;bsns}", Verifier.SYMBOLICNAME, path_version), new Syntax("-buildrepo", "After building a JAR, release the JAR to the given repositories.", "-buildrepo=Local", null, null, new Syntax[0]), new Syntax("-builderignore", "List of project-relative directories to be ignored by the builder. This is processed by the Bndtools builder in Eclipse and the Bnd Gradle plugin for workspace model builds.", "-builderignore=${if;${driver;gradle};bin,bin_test,generated;build}", null, null, new Syntax[0]), new Syntax("-bumppolicy", "Sets the version bump policy. This is a parameter to the ${version} macro.", "-bumppolicy==+0", "==+,=+0,+00", Pattern.compile("[=+-0][=+-0][=+-0]"), new Syntax[0]), new Syntax("-bundleannotations", "Selects the classes that need processing for standard OSGi Bundle annotations.", "-bundleannotations: com.foo.bar.MyClazz", null, Verifier.FQNPATTERN, new Syntax[0]), new Syntax("-baselinerepo", "Define the repository to calculate baselining against.", "-baselinerepo=Baseline", null, null, new Syntax[0]), new Syntax("-bnd-driver", "Sets the driver property.", "-bnd-driver:eclipse", "(ant | gradle|eclipsebndgradle_nativeintellijmavenosmorcsbt)", null, new Syntax[0]), new Syntax("-check", "Enable additional checking.", "-check=EXPORTS", "(ALL|EXPORTS|IMPORTS)", null, new Syntax[0]), new Syntax("-contract", "Establishes a link to a contract and handles the low level details.", "-contract!Servlet,*", null, Verifier.WILDCARDNAMEPATTERN, new Syntax[0]), new Syntax("-consumer-policy", "Specify the default version bump policy for a consumer when a binary incompatible change is detected.", "-consumer-policy${range;[==,+)}", null, null, new Syntax[0]), new Syntax("-provider-policy", "Specify the default version bump policy for a provider when a binary incompatible change is detected.", "-provider-policy${range;[==,=+)}", null, null, new Syntax[0]), new Syntax("-cdiannotations", "The -cdiannotations instruction tells bnd which bundle classes, if any, to search for OSGI CDI Integration (or plain CDI) annotation.", "-cdiannotations: *;discover=all", null, Verifier.WILDCARDNAMEPATTERN, new Syntax("discover", "Bean Discovery Mode.", "discover=all", "(all|annotated|annotated_by_bean|none)", null, new Syntax[0]), new Syntax("noservicecapabilities", "indicates that no service capabilities will be added for matches.", "noservicecapabilities=true", "true, false", Pattern.compile("true|false"), new Syntax[0])), new Syntax("-connection-settings", "Setting up the communications for bnd.", "-connection-settings= ~/.bnd/connection-settings.xml", null, null, new Syntax[0]), new Syntax("-conduit", "Allows a bnd file to point to files which will be returned when the bnd file is build.", "-conduit= jar/osgi.jar", null, null, new Syntax[0]), new Syntax("-dependson", "List of project names that this project directly depends on. These projects are always build ahead of this project.", "-dependson=org.acme.cm", "${projects}", null, new Syntax[0]), new Syntax("-deployrepo", "Specifies to which repo the project should be deployed.", "-deployrepo=cnf", "${repos}", null, new Syntax[0]), new Syntax("-diffignore", "Manifest header names and resource paths to ignore during baseline comparison.", "-diffignore=Bundle-Version", null, null, new Syntax[0]), new Syntax("-diffpackages", "The names of exported packages to baseline.", "-diffpackages=!*.internal.*, *", null, null, new Syntax[0]), new Syntax("-digests", "Set the digest algorithms to use.", "-digests: SHA-1 ", null, null, new Syntax[0]), new Syntax("-distro", "Resolve against pre-defined system capabilities.", "-distro: karaf-4.1.jar;version=file", null, null, new Syntax[0]), new Syntax("-donotcopy", "Regular expression for names of files and directories that should not be copied when discovered.", "-donotcopy=(CVS|\\.svn)", null, null, new Syntax[0]), new Syntax("-dsannotations", "The -dsannotations instruction tells bnd which bundle classes, if any, to search for Declarative Services (DS) annotations. bnd will then process those classes into DS XML descriptors.", "-dsannotations: *", null, Verifier.FQNPATTERN, new Syntax[0]), new Syntax("src", "The src instructs bnd to look for sources in the specified source directories", "src: src/main/java, src/main/resources", null, null, new Syntax[0]), new Syntax("bin", "The bin is used to specify the directory to generate the output binaries.", "bin: target/classes", null, null, new Syntax[0]), new Syntax("testsrc", "The testsrc instructs bnd to look for test sources in the specified directories", "testsrc: src/test/java", null, null, new Syntax[0]), new Syntax("testbin", "The testbin is used to specify the directory to generate the output binaries for test sources.", "testbin: target/test-classes", null, null, new Syntax[0]), new Syntax("target-dir", "The target-dir is used to specify the directory to generate output JAR.", "target-dir: target", null, null, new Syntax[0]), new Syntax("-dsannotations-options", "The -dsannotations-options instruction configures how DS component annotations are processed and what metadata is generated.", "-dsannotations-options: version;minimum=1.2.0", "(inherit|felixExtensions|extender|nocapabilities|norequirements|version)", null, new Syntax[0]), new Syntax("-export", "The -export instruction turns a bndrun file into its deployable format.", "-export: launcher.jar", "FILE ( ';' PARAMETER )* ( ',' FILE ( ';' PARAMETER )* )*", null, new Syntax[0]), new Syntax("-metatypeannotations", "The -metatypeannotations instruction tells bnd which bundle classes, if any, to search for Metatype annotations. bnd will then process those classes into Metatype XML descriptors.", "-metatypeannotations: *", null, Verifier.FQNPATTERN, new Syntax[0]), new Syntax("-metatypeannotations-options", "The -dsannotations-options instruction configures how Metatype annotations are processed and what metadata is generated.", "-metatypeannotations-options: version;minimum=1.2.0", "(inherit|felixExtensions|extender|nocapabilities|norequirements|version)", null, new Syntax[0]), new Syntax("-eeprofile", "Provides control over what Java 8 profile to use.", "-eeprofile: name=\"a,b,c\"", "name=\"a,b,c\", auto", null, new Syntax[0]), new Syntax("-extension", "A plugin that is loaded to its url, downloaded and then provides a header used instantiate the plugin.", null, null, null, new Syntax[0]), new Syntax("-executable", "Process an executable jar to strip optional directories of the contained bundles and/or change their compression.", "-executable: rejar=STORE, strip='OSGI-OPT,*.map'", "( rejar= STORE | DEFLATE ) ( ',' strip= matcher ( ',' matcher )* )", null, new Syntax[0]), new Syntax("-exportcontents", "Build the JAR in the normal way but use this header for the Export-Package header manifest generation, same format.", "-exportcontents=!*impl*,*;version=3.0", null, null, new Syntax[0]), new Syntax("-export-apiguardian", "Enable the APIGuardian plugin that searches for @API annotations for calculating the Export-Package header manifest generation, same format.", "-export-apiguardian=!*impl*,*;version=3.0", null, null, new Syntax[0]), new Syntax("-exporttype", "This specifies the type of the exported content", "-exporttype=bnd.executablejar;foo=bnd, bnd.runbundles;bar=bnd", null, null, new Syntax[0]), new Syntax("-failok", "Return with an ok status (0) even if the build generates errors.", "-failok=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-fixupmessages", "Rearrange and/or replace errors and warnings. Errors that should be ignore or be warnings (and vice versa for warnings) can be moved or rewritten by specifying a globbing pattern for the message.", "-fixupmessages='Version mismatch';replace:='************* ${@}';restrict:=error", null, null, new Syntax[0]), new Syntax("-gestalt", "provides access to the gestalt properties that describe the environment", "-gestalt=interactive", "(interactive|batch|ci|offline|shell)", null, new Syntax[0]), new Syntax("-groupid", "Specifies the Maven Group ID to be used for bundles", "-groupid=com.foo.bar", null, null, new Syntax[0]), new Syntax("-include", "Include files. If an entry starts with '-', it does not have to exist. If it starts with '~', it must not overwrite any existing properties.", "-include: -${java.user}/.bnd", null, null, new Syntax[0]), new Syntax("-invalidfilenames", "Specify a regular expressions to match against file or directory names. This is the segment, not the whole path. The intention is to provide a check for files and directories that cannot be used on Windows. However, it can also be used on other platforms. You can specify the ${@} macro to refer to the default regular expressions used for this.", "-invalidfilenames:" + Verifier.ReservedFileNames, null, null, new Syntax[0]), new Syntax("-includepackage", "Include a number of packages from the class path.", "-includepackage: !com.foo.bar, com.foo.* ", null, Verifier.WILDCARDNAMEPATTERN, new Syntax[0]), new Syntax("-includeresource", "Include resources from the file system. You can specify a directory, or file. All files are copied to the root, unless a destination directory is indicated.", "-includeresource: lib/=jar/, {preprocess.txt}, license.txt;literal:='ASL 2.0, -doesnotexit.txt'", null, null, new Syntax[0]), new Syntax("Include-Resource", "Include resources from the file system. You can specify a directory, or file. All files are copied to the root, unless a destination directory is indicated.", "Include-Resource: lib/=jar/, {preprocess.txt}, 'literal';literal;=true,", null, null, new Syntax[0]), new Syntax("-init", "Executes macros while initializing the project for building", "-init: ${my_macro} ", null, null, new Syntax[0]), new Syntax("-javaagent", "Specify if classpath jars with Premain-Class headers are to be used as java agents.", "-javaagent: true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("javac", "Java Compiler Specific Settings.", null, null, null, new Syntax[0]), new Syntax("javac.encoding", "Sets the Java Compiler Encoding Type.", "javac.encoding: UTF-8", null, null, new Syntax[0]), new Syntax("javac.source", "Sets the Java source compatibility version.", "javac.source: 1.8", null, null, new Syntax[0]), new Syntax("javac.profile", "When using compact profiles, this option specifies the profile name when compiling.", "javac.profile: compact1", null, null, new Syntax[0]), new Syntax("javac.target", "Sets the Java target compatibility version.", "javac.target: 1.8", null, null, new Syntax[0]), new Syntax("-make", "Set patterns for make plugins. These patterns are used to find a plugin that can make a resource that can not be found.", "-make: (*).jar;type=bnd; recipe=\"bnd/$1.bnd\"", null, null, new Syntax("type", "Type name for plugin.", "type=bnd", "bnd", null, new Syntax[0]), new Syntax("recipe", "Recipe for the plugin, can use back references.", "recipe=\"bnd/$1.bnd\"", "bnd", null, new Syntax[0])), new Syntax("-maven-release", "Set the Maven release options for the Maven Bnd Repository.", "-maven-release: local", "(local|remote)", null, new Syntax[0]), new Syntax("-maven-scope", "Set the default Maven scope for dependencies in the generated POM.", "-maven-scope: compile", "(compile|provided)", null, new Syntax[0]), new Syntax("-manifest", "Directly include a manifest, do not use the calculated manifest.", "-manifest=META-INF/MANIFEST.MF", null, null, new Syntax[0]), new Syntax("-nobuildincache", "Do not use a build in cache for the launcher and JUnit.", "-nobuildincache=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-nobundles", "Do not create a target JAR for the project", "-nobundles=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-nodefaultversion", "Do not add a default version to exported packages when no version is present.", "-nodefaultversion=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-noextraheaders", "Do not generate housekeeping headers.", "-noextraheaders=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-nojunit", "Indicates that this project does not have JUnit tests", "-nojunit=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-nojunitosgi", "Indicates that this project does not have JUnit OSGi tests", "-nojunitosgi=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-nomanifest", "Do not safe the manifest in the JAR.", "-nomanifest=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-nouses", "Do not calculate the uses: directive on package exports or on capabilities.", "-nouses=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-noclassforname", "Do not calculate Import-Package references for 'Class.forName(\"some.Class\")' usage found in method bodies during class processing.", "-noclassforname=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-noimportjava", "Do not calculate Import-Package references for java.* packages.", "-noimportjava=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-noee", "Do not calculate the osgi.ee name space Execution Environment from the class file version.", "-noee=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-namesection", "Create a name section (second part of manifest) with optional property expansion and addition of custom attributes. Patterns not ending with \"/\" target resources. Those ending with \"/\" target packages.", "-namesection=*;baz=true, abc/def/bar/X.class;bar=3", null, null, new Syntax[0]), new Syntax("-output", "Specify the output directory or file.", "-output=my_directory", null, null, new Syntax[0]), new Syntax("-outputmask", "If set, is used a template to calculate the output file. It can use any macro but the ${@bsn} and ${@version} macros refer to the current JAR being saved. The default is bsn + \".jar\".", "-outputmask=my_file.zip", null, null, new Syntax[0]), new Syntax("-packageinfotype", "Sets the different types of package info.", "-packageinfotype=osgi", null, null, new Syntax[0]), new Syntax("-pedantic", "Warn about things that are not really wrong but still not right.", "-pedantic=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-plugin", "Define the plugins.", "-plugin=aQute.lib.spring.SpringComponent,aQute.lib.deployer.FileRepo;location=${repo}", null, null, new Syntax[0]), new Syntax("-pluginpath", "Define the plugins load path.", "-pluginpath=${workspace}/cnf/cache/plugins-2.2.0.jar", null, null, new Syntax("url", "Specify a URL to download this file from if it does not exist", "url=http://example.com/download/plugins-2.2.0.jar", null, null, new Syntax[0])), new Syntax("-preprocessmatchers", "Specify which files can be preprocessed.", "-preprocessmatchers=!OSGI-INF/*,* ", null, null, new Syntax[0]), new Syntax("Service-Component", "The header for Declarative Services.", "Service-Component=com.acme.Foo?;activate='start'", null, null, new Syntax[0]), new Syntax("-pom", "Generate a maven pom.", "-pom=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-releaserepo", "Specifies to which repo the project should be released.", "-releaserepo=cnf", "${repos}", null, new Syntax[0]), new Syntax("-removeheaders", "Remove all headers that match the regular expressions.", "-removeheaders=FOO_.*,Proprietary", null, null, new Syntax[0]), new Syntax("-reproducible", "Use a fixed timestamp for all jar entries.", "-reproducible=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-resolve.effective", "Each requirement and capability has an effective or is effective=resolve. An effective of resolve is always processed by the resolver.", "-resolve.effective=resolve,active", "qname (',' qname )", null, new Syntax[0]), new Syntax("-resolve.preferences", "Override the default order and selection of repositories.", "-resolve.preferences=com.example.bundle.most.priority", "${packages}", null, new Syntax[0]), new Syntax("-runtimeout", "Specifies the test execution timeout.", "-runtimeout=10000", null, null, new Syntax[0]), new Syntax("-require-bnd", "Require a specific version of bnd.", "-require-bnd=\"(version>=4.1)\"", "(FILTER ( ',' FILTER )* )?", null, new Syntax[0]), new Syntax("-resourceonly", "Normally bnd warns when the JAR does not contain any classes, this option suppresses this warning.", "-resourceonly=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-savemanifest", "Write out the manifest to a separate file after it has been calculated.", "-savemanifest=file.txt", null, null, new Syntax[0]), new Syntax("-sources", "Include sources in the jar.", "-sources=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-sourcepath", "List of directory names that used to source sources for -sources.", "-sourcepath:= src, test", null, null, new Syntax[0]), new Syntax("-testpath", "List of bundles to be placed on the build path for local JUnit testing only. This content is never available for the bundle itself or any of its classes.", "-testpath=som.bundle.symbolicname;version=latest", null, null, new Syntax[0]), new Syntax("-tester", "The name of the tester. The preferred default is biz.aQute.tester, old style is biz.aQute.junit", "-tester=biz.aQute.tester;version=latest", null, null, new Syntax[0]), new Syntax("Tester-Plugin", "It points to a class that must extend the aQute.bnd.build.ProjectTester class. This class is loaded in the bnd environment and not in the target environment. This ProjectTester plugin then gets a chance to configure the launcher as it sees fit. It can get properties from the project and set these in the Project Launcher so they can be picked up in the target environment.", "Tester-Plugin= a.b.c.MyTester", null, Verifier.FQNPATTERN, new Syntax[0]), new Syntax("-sub", "Build a set of bnd files that use this bnd file as a basis. The list of bnd file can be specified with wildcards.", "-sub=com.acme.*.bnd", null, null, new Syntax[0]), new Syntax("-reportnewer", "Report any entries that were added to the build since the last JAR was made.", "-reportnewer=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-runproperties", "Properties that are set as system properties before the framework is started.", "-runproperties= foo=3, bar=4", null, null, new Syntax[0]), new Syntax("-runremote", "It provides remote debugging support for bnd projects.", "-runremote= local; shell=4003; jdb=1044; host=localhost ", null, null, new Syntax[0]), new Syntax("-runstorage", "Define the directory to use for the framework's work area.", "-runstorage= foo", null, null, new Syntax[0]), new Syntax("-runsystempackages", "Add additional system packages to a framework run.", "-runsystempackages=com.acme.foo,javax.management", null, null, new Syntax[0]), new Syntax("-runsystemcapabilities", "Define extra capabilities for the remote VM.", "-runsystemcapabilities=some.namespace; some.namespace=foo", null, null, new Syntax[0]), new Syntax("-runprovidedcapabilities", "Extra capabilities for a distro resolve.", "-runprovidedcapabilities=some.namespace; some.namespace=foo", null, null, new Syntax[0]), new Syntax("-runtimeout", "Define extra capabilities for the remote VM.", "-runsystemcapabilities=some.namespace; some.namespace=foo", null, null, new Syntax[0]), new Syntax("-runbuilds", "Defines if this should add the bundles build by this project to the -runbundles. For a bndrun file this is default false, for a bnd file this is default true.", "-runbuilds=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-runbundles", "Add additional bundles, specified with their bsn and version like in -buildpath, that are started before the project is run.", "-runbundles=osgi;version=\"[4.1,4.2)\", junit.junit, com.acme.foo;version=project", null, Verifier.SYMBOLICNAME, path_version), new Syntax("-runframework", "Sets the type of framework to run. If 'none', an internal dummy framework is used. Otherwise the Java META-INF/services model is used for the FrameworkFactory interface name.", "-runfw: none", "(none | services | ANY)", null, new Syntax[0]), new Syntax("-runenv", "Specify runtime properties for the framework.", "-runenv: org.osgi.service.http.port=9999, org.osgi.framework.bootdelegation=\"sun.*,com.sun.*,\"", null, null, new Syntax[0]), new Syntax("-runfw", "The -runfw instruction sets the framework to use.", "-runfw: org.eclipse.osgi; version=3.10", null, null, new Syntax[0]), new Syntax("-runjdb", "Specify a JDB socket transport address on invocation when launched outside a debugger so the debugger can attach later.", "-runjdb: localhost:10001", null, null, new Syntax[0]), new Syntax("-runkeep", "Decides to keep the framework storage directory between launching.", "-runkeep: true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-runpath", "Additional JARs for the VM path, can include a framework", "-runpath=org.eclipse.osgi;version=3.5", null, null, path_version), new Syntax("-runnoreferences", "Do not use the reference url for installing a bundle in the installer. This is the default for windows because it is quite obstinate about open files, on other platforms the more efficient reference urls are used.", "-runnoreferences: true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-runtrace", "Trace the launched process in detail.", "-runtrace: true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-remoteworkspace", "This setting enables the workspace to be available over a remote procedure call interface.", "-remoteworkspace: true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-runvm", "Additional comma-separated arguments for the VM invocation.", "-runvm=-Xmax=30, -DsecondOption=secondValue", null, null, new Syntax[0]), new Syntax("-runprogramargs", "Additional comma-separated arguments for the program invocation.", "-runprogramargs=/some/file, /another/file, some_argument", null, null, new Syntax[0]), new Syntax("-runrepos", "The -runrepos instruction is used to restrict or order the available repositories", "-runrepos=Maven Central, Main, Distro, ...", null, null, new Syntax[0]), new Syntax("-runrequires", "Comma seperated list of root requirements for a resolve operation.", "-runrequires=osgi.identity;filter:='(osgi.identity=<bsn>)', ...", null, null, new Syntax[0]), new Syntax("-runblacklist", "A set of requirements that is then removed from any result from the repositories, effectively making it impossible to use.", "-runblacklist=osgi.identity;filter:='(osgi.identity=<bsn>)', ...", null, null, new Syntax[0]), new Syntax("-runee", "Adds the capabilities of an execution environment to the system capabilities for a resolve operation.", "-runee=JavaSE-1.8", null, null, new Syntax[0]), new Syntax("-sign", "Sign the Jar File", "-sign=alias", "<alias> [ ';' 'password:=' <password> ] [ ';'* 'keystore:=' <keystore> ] [ ';' 'sign-password:=' <pw> ] ( ',' ... )*", null, new Syntax[0]), new Syntax("-snapshot", "When the bundle version\u2019s qualifier equals 'SNAPSHOT' or ends with '-SNAPSHOT', the STRING value of the -snapshot instruction is substituted for 'SNAPSHOT'.", "-snapshot=${tstamp}", null, null, new Syntax[0]), new Syntax("-standalone", "Used in bndrun files. Disconnects the bndrun file from the workspace and defines its own Capabilities repositories.", "-standalone=index.html;name=..., ...", null, null, new Syntax[0]), new Syntax("-strict", "If set to true, then extra verification is done.", "-strict=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-systemproperties", "Properties that are set as system properties.", "-systemproperties= foo=3, bar=4", null, null, new Syntax[0]), new Syntax("-testcontinuous", "Do not exit after running the test suites but keep watching the bundles and rerun the test cases if the bundle is updated.", "-testcontinuous=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-testsources", "Specification to find JUnit test cases by traversing the test src directory and looking for java classes.", "-testsources=*.java", "REGEX ( ',' REGEX )*", null, new Syntax[0]), new Syntax("-testpackages", "It automatically adds the test packages if and only if -undertest has been set to true", "-testpackages=test;presence:=optional", null, null, new Syntax[0]), new Syntax("-testunresolved", "Will execute a JUnit testcase ahead of any other test case that will abort if there are any unresolved bundles.", "-testunresolved=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-undertest", "Will be set by the project when it builds a JAR in test mode, intended to be used by plugins.", "-undertest=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-upto", "Limit bnd's behavior like it was up to the given version", "-upto: 2.3.1", null, Version.VERSION, new Syntax[0]), new Syntax("-wab", "Create a Web Archive Bundle (WAB) or a WAR.", "-wab=static-pages/", null, null, new Syntax[0]), new Syntax("-wablib", "Specify the libraries that must be included in a Web Archive Bundle (WAB) or WAR.", "-wablib=lib/a.jar, lib/b.jar", null, null, new Syntax[0]), new Syntax("-workingset", "Groups the workspace into different working sets.", "-workingset=Implementations, Drivers", null, null, new Syntax[0]), new Syntax("-x-overwritestrategy", "On windows we sometimes cannot delete a file because someone holds a lock in our or another process. So if we set the -overwritestrategy flag we use an avoiding strategy.", "-x-overwritestrategy=gc", "(classic|delay|gc|windows-only-disposable-names|disposable-names)", null, new Syntax[0])};
    static final Map<Class<?>, Pattern> BASE_PATTERNS = Maps.ofEntries(Maps.entry(Byte.class, Verifier.NUMBERPATTERN), Maps.entry(Byte.TYPE, Verifier.NUMBERPATTERN), Maps.entry(Short.class, Verifier.NUMBERPATTERN), Maps.entry(Short.TYPE, Verifier.NUMBERPATTERN), Maps.entry(Integer.class, Verifier.NUMBERPATTERN), Maps.entry(Integer.TYPE, Verifier.NUMBERPATTERN), Maps.entry(Long.class, Verifier.NUMBERPATTERN), Maps.entry(Long.TYPE, Verifier.NUMBERPATTERN), Maps.entry(Float.class, Verifier.FLOATPATTERN), Maps.entry(Float.TYPE, Verifier.FLOATPATTERN), Maps.entry(Double.class, Verifier.FLOATPATTERN), Maps.entry(Double.TYPE, Verifier.FLOATPATTERN), Maps.entry(Boolean.class, Verifier.BOOLEANPATTERN), Maps.entry(Boolean.TYPE, Verifier.BOOLEANPATTERN));
    public static final Map<String, Syntax> HELP;

    private static void add(Map<String, Syntax> help, Syntax s) {
        help.put(s.header, s);
    }

    private static void add(Map<String, Syntax> help, Class<?> class1) {
        for (Syntax syntax : Syntax.create(class1, Syntax::toInstruction, true)) {
            Syntax.add(help, syntax);
        }
    }

    private static Syntax[] create(Class<?> class1, Function<Method, String> naming, boolean instruction) {
        ArrayList<Syntax> syntaxes = new ArrayList<Syntax>();
        for (Method m : class1.getMethods()) {
            Object[] enumConstants;
            Class rtype;
            if (Modifier.isStatic(m.getModifiers()) || m.getDeclaringClass() == Object.class) continue;
            String name = naming.apply(m);
            SyntaxAnnotation ann = m.getAnnotation(SyntaxAnnotation.class);
            String lead = null;
            String example = null;
            Pattern pattern = null;
            String values = null;
            if (ann != null) {
                if (!ann.lead().isEmpty()) {
                    lead = ann.lead();
                }
                if (!ann.example().isEmpty()) {
                    example = ann.example();
                    example = instruction ? name + ": " + ann.example() : name + "=" + ann.example();
                }
                if (!ann.pattern().isEmpty()) {
                    pattern = Pattern.compile(ann.pattern());
                }
            }
            if ((rtype = m.getReturnType()) == Optional.class) {
                Type optionalType = ((ParameterizedType)m.getGenericReturnType()).getActualTypeArguments()[0];
                assert (optionalType instanceof Class) : "Generic types in optional not supported";
                rtype = (Class)optionalType;
            }
            if (rtype.isEnum()) {
                enumConstants = rtype.getEnumConstants();
                values = Strings.join(enumConstants);
            } else if (Boolean.class.isAssignableFrom(rtype)) {
                values = "true,false";
            }
            if (pattern == null) {
                pattern = BASE_PATTERNS.get(rtype);
            }
            if (rtype == Map.class) {
                ParameterizedType mapType = (ParameterizedType)m.getGenericReturnType();
                Type valueType = mapType.getActualTypeArguments()[1];
                assert (valueType instanceof Class) : "The type of the value of a parameters must be a class, not a generic type";
                Syntax[] clauses = Syntax.create((Class)valueType, Syntax::toProperty, false);
                syntaxes.add(new Syntax(name, lead, example, values, pattern, clauses));
            } else if (Iterable.class.isAssignableFrom(rtype)) {
                syntaxes.add(new Syntax(name, lead, example, values, pattern, new Syntax[0]));
            } else if (rtype.isInterface()) {
                Syntax[] clauses = Syntax.create(rtype, Syntax::toProperty, false);
                syntaxes.add(new Syntax(name, lead, example, values, pattern, clauses));
            }
            if (rtype.isEnum()) {
                enumConstants = rtype.getFields();
                Syntax[] fields = new Syntax[enumConstants.length];
                for (int i = 0; i < enumConstants.length; ++i) {
                    Object e = enumConstants[i];
                    fields[i] = Syntax.createEnumField((Field)e);
                }
                Syntax syntax = new Syntax(name, lead, example, values, pattern, fields);
                syntaxes.add(syntax);
                continue;
            }
            syntaxes.add(new Syntax(name, lead, example, values, pattern, new Syntax[0]));
        }
        return syntaxes.toArray(new Syntax[0]);
    }

    private static Syntax createEnumField(Field e) {
        String name = e.getName();
        String lead = null;
        String example = null;
        Pattern pattern = Pattern.compile(Pattern.quote(e.getName()));
        SyntaxAnnotation sa = e.getAnnotation(SyntaxAnnotation.class);
        if (sa != null) {
            if (!sa.name().isEmpty()) {
                name = sa.name();
            }
            if (!sa.lead().isEmpty()) {
                lead = sa.lead();
            }
            if (!sa.example().isEmpty()) {
                example = sa.example();
            }
            if (!sa.pattern().isEmpty()) {
                pattern = Pattern.compile(sa.pattern(), 16);
            }
        }
        return new Syntax(name, lead, example, name, pattern, new Syntax[0]);
    }

    static String toInstruction(Method m) {
        SyntaxAnnotation ann = m.getAnnotation(SyntaxAnnotation.class);
        if (ann != null && !ann.name().isEmpty()) {
            return ann.name();
        }
        return "-" + Syntax.preferDashes(m);
    }

    static String toProperty(Method m) {
        SyntaxAnnotation ann = m.getAnnotation(SyntaxAnnotation.class);
        if (ann != null && !ann.name().isEmpty()) {
            return ann.name();
        }
        return Syntax.preferDashes(m);
    }

    private static String preferDashes(Method m) {
        return m.getName().replace('_', '-');
    }

    public Syntax(String header, String lead, String example, String values, Pattern pattern, Syntax ... children) {
        this.header = header;
        this.children = children;
        this.lead = lead;
        this.example = example;
        this.values = values;
        this.pattern = pattern;
    }

    public String getLead() {
        return this.lead;
    }

    public String getExample() {
        return this.example;
    }

    public String getValues() {
        return this.values;
    }

    public String getPattern() {
        if (this.pattern == null) {
            return ".*";
        }
        return this.pattern.pattern();
    }

    public Syntax[] getChildren() {
        return this.children;
    }

    public String getHeader() {
        return this.header;
    }

    public String toString() {
        return this.header;
    }

    public static <T> T getInstructions(Processor processor, Class<T> type) {
        return ProcessorHandler.getInstructions(processor, type);
    }

    public String getInsert() {
        if (this.example != null) {
            try {
                String insert;
                Properties p = new Properties();
                p.load(new StringReader(this.example));
                String value = p.getProperty(this.header);
                if (value != null && (insert = BndEditModel.format(this.header, value)) != null) {
                    return this.header + ": " + insert;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.example;
        }
        return this.header + ":";
    }

    static {
        HashMap<String, Syntax> help = new HashMap<String, Syntax>();
        for (Syntax s : syntaxes) {
            Syntax.add(help, s);
        }
        Syntax.add(help, BuilderInstructions.class);
        Syntax.add(help, LauncherInstructions.class);
        Syntax.add(help, ResolutionInstructions.class);
        HELP = Maps.copyOf(help);
    }
}

