/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.lifecycle.LifecycleImpl;
import org.apache.myfaces.lifecycle.PhaseExecutor;
import org.apache.myfaces.portlet.MyFacesGenericPortlet;
import org.apache.myfaces.portlet.PortletUtil;
import org.apache.myfaces.shared_impl.util.RestoreStateUtils;
import org.apache.myfaces.util.DebugUtils;

class RestoreViewExecutor
implements PhaseExecutor {
    private static final Log log = LogFactory.getLog((Class)LifecycleImpl.class);

    RestoreViewExecutor() {
    }

    public boolean execute(FacesContext facesContext) {
        Application application;
        ViewHandler viewHandler;
        UIViewRoot viewRoot;
        if (facesContext.getViewRoot() != null) {
            facesContext.getViewRoot().setLocale(facesContext.getExternalContext().getRequestLocale());
            RestoreStateUtils.recursivelyHandleComponentReferencesAndSetValid(facesContext, (UIComponent)facesContext.getViewRoot());
            return false;
        }
        String viewId = RestoreViewExecutor.deriveViewId(facesContext);
        if (viewId == null) {
            ExternalContext externalContext = facesContext.getExternalContext();
            if (externalContext.getRequestServletPath() == null) {
                return true;
            }
            if (!externalContext.getRequestServletPath().endsWith("/")) {
                try {
                    externalContext.redirect(externalContext.getRequestServletPath() + "/");
                    facesContext.responseComplete();
                    return true;
                }
                catch (IOException e) {
                    throw new FacesException("redirect failed", (Throwable)e);
                }
            }
        }
        if ((viewRoot = (viewHandler = (application = facesContext.getApplication()).getViewHandler()).restoreView(facesContext, viewId)) == null) {
            viewRoot = viewHandler.createView(facesContext, viewId);
            viewRoot.setViewId(viewId);
            facesContext.renderResponse();
        }
        facesContext.setViewRoot(viewRoot);
        if (!this.isPostback(facesContext)) {
            facesContext.renderResponse();
        }
        RestoreStateUtils.recursivelyHandleComponentReferencesAndSetValid(facesContext, (UIComponent)viewRoot);
        return false;
    }

    private boolean isPostback(FacesContext facesContext) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        return requestParameterMap.containsKey("javax.faces.ViewState") || requestParameterMap.containsKey("org.apache.myfaces.trinidad.faces.STATE");
    }

    public PhaseId getPhase() {
        return PhaseId.RESTORE_VIEW;
    }

    private static String deriveViewId(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        if (PortletUtil.isPortletRequest(facesContext)) {
            PortletRequest request = (PortletRequest)externalContext.getRequest();
            return request.getParameter(MyFacesGenericPortlet.VIEW_ID);
        }
        String viewId = externalContext.getRequestPathInfo();
        if (viewId == null) {
            viewId = externalContext.getRequestServletPath();
            DebugUtils.assertError(viewId != null, log, "RequestServletPath is null, cannot determine viewId of current page.");
            if (viewId == null) {
                return null;
            }
            String defaultSuffix = externalContext.getInitParameter("javax.faces.DEFAULT_SUFFIX");
            String suffix = defaultSuffix != null ? defaultSuffix : ".jsp";
            DebugUtils.assertError(suffix.charAt(0) == '.', log, "Default suffix must start with a dot!");
            int slashPos = viewId.lastIndexOf(47);
            int extensionPos = viewId.lastIndexOf(46);
            if (extensionPos == -1 || extensionPos <= slashPos) {
                log.error((Object)("Assumed extension mapping, but there is no extension in " + viewId));
                viewId = null;
            } else {
                viewId = viewId.substring(0, extensionPos) + suffix;
            }
        }
        return viewId;
    }
}

