/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import java.util.Iterator;
import java.util.List;
import javax.faces.FactoryFinder;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.config.FacesConfigValidator;
import org.apache.myfaces.config.FacesConfigurator;
import org.apache.myfaces.context.servlet.ServletExternalContextImpl;
import org.apache.myfaces.shared_impl.util.StateUtils;
import org.apache.myfaces.shared_impl.webapp.webxml.WebXml;

public class StartupServletContextListener
implements ServletContextListener {
    private static final Log log = LogFactory.getLog((Class)StartupServletContextListener.class);
    static final String FACES_INIT_DONE = StartupServletContextListener.class.getName() + ".FACES_INIT_DONE";

    public void contextInitialized(ServletContextEvent event) {
        StartupServletContextListener.initFaces(event.getServletContext());
    }

    public static void initFaces(ServletContext servletContext) {
        try {
            Boolean b = (Boolean)servletContext.getAttribute(FACES_INIT_DONE);
            if (b == null || !b.booleanValue()) {
                log.trace((Object)"Initializing MyFaces");
                ServletExternalContextImpl externalContext = new ServletExternalContextImpl(servletContext, null, null);
                new FacesConfigurator(externalContext).configure();
                if ("true".equals(servletContext.getInitParameter("org.apache.myfaces.VALIDATE")) || "true".equals(servletContext.getInitParameter("org.apache.myfaces.VALIDATE".toLowerCase()))) {
                    List list = FacesConfigValidator.validate(externalContext, servletContext.getRealPath("/"));
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        log.warn(iterator.next());
                    }
                }
                WebXml.init(externalContext);
                servletContext.setAttribute(FACES_INIT_DONE, (Object)Boolean.TRUE);
            } else {
                log.info((Object)"MyFaces already initialized");
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error initializing ServletContext", (Throwable)ex);
            ex.printStackTrace();
        }
        log.info((Object)("ServletContext '" + servletContext.getRealPath("/") + "' initialized."));
        String useEncryption = servletContext.getInitParameter("org.apache.myfaces.USE_ENCRYPTION");
        if (!"false".equals(useEncryption)) {
            StateUtils.initSecret(servletContext);
        }
    }

    public void contextDestroyed(ServletContextEvent e) {
        FactoryFinder.releaseFactories();
    }
}

