/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.el;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.faces.view.Location;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.el.CompositeComponentELUtils;
import org.apache.myfaces.view.facelets.el.LocationValueExpression;
import org.apache.myfaces.view.facelets.el.LocationValueExpressionUEL;
import org.apache.myfaces.view.facelets.el.ResourceELUtils;
import org.apache.myfaces.view.facelets.el.ResourceLocationValueExpression;
import org.apache.myfaces.view.facelets.el.ResourceLocationValueExpressionUEL;

public class ELText {
    protected final String literal;

    public ELText(String literal) {
        this.literal = literal;
    }

    public boolean isLiteral() {
        return true;
    }

    public ELText apply(ExpressionFactory factory, ELContext ctx) {
        return this;
    }

    public void write(Writer out, ELContext ctx) throws ELException, IOException {
        out.write(this.literal);
    }

    public void writeText(ResponseWriter out, ELContext ctx) throws ELException, IOException {
        out.writeText(this.literal, null);
    }

    public String toString(ELContext ctx) throws ELException {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static boolean isLiteral(String in) {
        return ELText.isLiteral(null, null, in);
    }

    public static ELText parse(String in) throws ELException {
        return ELText.parse(null, null, in);
    }

    public static ELText parseAllowEmptyString(String in) throws ELException {
        if (in != null && in.length() == 0) {
            return new ELText(in);
        }
        return ELText.parse(null, null, in);
    }

    public static ELText parse(ExpressionFactory fact, ELContext ctx, String in) throws ELException {
        char[] ca = in.toCharArray();
        int i = 0;
        char c = '\u0000';
        int len = ca.length;
        int end = len - 1;
        boolean esc = false;
        int vlen = 0;
        StringBuffer buff = new StringBuffer(128);
        ArrayList<ELText> text = new ArrayList<ELText>();
        ELCacheableTextVariable t = null;
        ValueExpression ve = null;
        while (i < len) {
            c = ca[i];
            if ('\\' == c) {
                boolean bl = esc = !esc;
                if (esc && i < end && (ca[i + 1] == '$' || ca[i + 1] == '#')) {
                    ++i;
                    continue;
                }
            } else if (!(esc || '$' != c && '#' != c || i >= end || '{' != ca[i + 1])) {
                if (buff.length() > 0) {
                    text.add(new ELText(buff.toString()));
                    buff.setLength(0);
                }
                vlen = ELText.findVarLength(ca, i);
                if (ctx != null && fact != null) {
                    ve = fact.createValueExpression(ctx, new String(ca, i, vlen), String.class);
                    t = new ELCacheableTextVariable(ve);
                } else {
                    t = new ELCacheableTextVariable(new LiteralValueExpression(new String(ca, i, vlen)));
                }
                text.add(t);
                i += vlen;
                continue;
            }
            esc = false;
            buff.append(c);
            ++i;
        }
        if (buff.length() > 0) {
            text.add(new ELText(buff.toString()));
            buff.setLength(0);
        }
        if (text.size() == 0) {
            return null;
        }
        if (text.size() == 1) {
            return (ELText)text.get(0);
        }
        ELText[] ta = text.toArray(new ELText[text.size()]);
        return new ELTextComposite(ta);
    }

    public static ELText[] parseAsArray(String in) throws ELException {
        return ELText.parseAsArray(null, null, in);
    }

    public static ELText[] parseAsArray(ExpressionFactory fact, ELContext ctx, String in) throws ELException {
        char[] ca = in.toCharArray();
        int i = 0;
        char c = '\u0000';
        int len = ca.length;
        int end = len - 1;
        boolean esc = false;
        int vlen = 0;
        StringBuffer buff = new StringBuffer(128);
        ArrayList<ELText> text = new ArrayList<ELText>();
        ELCacheableTextVariable t = null;
        ValueExpression ve = null;
        while (i < len) {
            c = ca[i];
            if ('\\' == c) {
                boolean bl = esc = !esc;
                if (esc && i < end && (ca[i + 1] == '$' || ca[i + 1] == '#')) {
                    ++i;
                    continue;
                }
            } else if (!(esc || '$' != c && '#' != c || i >= end || '{' != ca[i + 1])) {
                if (buff.length() > 0) {
                    text.add(new ELText(buff.toString()));
                    buff.setLength(0);
                }
                vlen = ELText.findVarLength(ca, i);
                if (ctx != null && fact != null) {
                    ve = fact.createValueExpression(ctx, new String(ca, i, vlen), String.class);
                    t = new ELCacheableTextVariable(ve);
                } else {
                    t = new ELCacheableTextVariable(new LiteralValueExpression(new String(ca, i, vlen)));
                }
                text.add(t);
                i += vlen;
                continue;
            }
            esc = false;
            buff.append(c);
            ++i;
        }
        if (buff.length() > 0) {
            text.add(new ELText(buff.toString()));
            buff.setLength(0);
        }
        if (text.size() == 0) {
            return null;
        }
        if (text.size() == 1) {
            return new ELText[]{(ELText)text.get(0)};
        }
        ELText[] ta = text.toArray(new ELText[text.size()]);
        return ta;
    }

    public static boolean isLiteral(ExpressionFactory fact, ELContext ctx, String in) throws ELException {
        char[] ca = in.toCharArray();
        int i = 0;
        char c = '\u0000';
        int len = ca.length;
        int end = len - 1;
        boolean esc = false;
        while (i < len) {
            c = ca[i];
            if ('\\' == c) {
                boolean bl = esc = !esc;
                if (esc && i < end && (ca[i + 1] == '$' || ca[i + 1] == '#')) {
                    ++i;
                    continue;
                }
            } else if (!(esc || '$' != c && '#' != c || i >= end || '{' != ca[i + 1])) {
                return false;
            }
            esc = false;
            ++i;
        }
        return true;
    }

    private static int findVarLength(char[] ca, int s) throws ELException {
        int i;
        int len = ca.length;
        char c = '\u0000';
        char str = '\u0000';
        int nest = 0;
        for (i = s; i < len; ++i) {
            c = ca[i];
            if ('\\' == c && i < len - 1) {
                ++i;
                continue;
            }
            if ('\'' == c || '\"' == c) {
                if (str == c) {
                    str = '\u0000';
                    continue;
                }
                str = c;
                continue;
            }
            if ('{' == c && str == '\u0000') {
                ++nest;
                continue;
            }
            if ('}' == c && str == '\u0000' && nest > 1) {
                --nest;
                continue;
            }
            if (str != '\u0000' || '}' != c || nest != 1) continue;
            return i - s + 1;
        }
        throw new ELException("EL Expression Unbalanced: ... " + new String(ca, s, i - s));
    }

    private static final class ELCacheableTextVariable
    extends ELText {
        private final ValueExpression ve;
        private static final int EL_CC = 2;
        private static final int EL_RESOURCE = 8;
        private final int capabilities;
        private volatile ELTextVariable cached;

        public ELCacheableTextVariable(ValueExpression ve) {
            super(ve.getExpressionString());
            this.ve = ve;
            boolean compositeComponentExpression = CompositeComponentELUtils.isCompositeComponentExpression(ve.getExpressionString());
            boolean resourceExpression = ResourceELUtils.isResourceExpression(ve.getExpressionString());
            this.capabilities = (compositeComponentExpression ? 2 : 0) | (resourceExpression ? 8 : 0);
        }

        @Override
        public boolean isLiteral() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ELText apply(ExpressionFactory factory, ELContext ctx) {
            AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
            if (actx.isAllowCacheELExpressions() && this.cached != null) {
                if ((this.capabilities & 2) != 0) {
                    Location location;
                    UIComponent cc = actx.getFaceletCompositionContext().getCompositeComponentFromStack();
                    if (cc != null && (location = (Location)cc.getAttributes().get("org.apache.myfaces.compositecomponent.location")) != null) {
                        return new ELTextVariable(((LocationValueExpression)this.cached.ve).apply(actx.getFaceletCompositionContext().getCompositeComponentLevel(), location));
                    }
                    return new ELTextVariable(((LocationValueExpression)this.cached.ve).apply(actx.getFaceletCompositionContext().getCompositeComponentLevel()));
                }
                return this.cached;
            }
            actx.beforeConstructELExpression();
            try {
                Location location;
                UIComponent cc;
                ValueExpression valueExpression = factory.createValueExpression(ctx, this.ve.getExpressionString(), String.class);
                if ((this.capabilities & 2) != 0) {
                    cc = actx.getFaceletCompositionContext().getCompositeComponentFromStack();
                    if (cc != null && (location = (Location)cc.getAttributes().get("org.apache.myfaces.compositecomponent.location")) != null) {
                        valueExpression = ExternalSpecifications.isUnifiedELAvailable() ? new LocationValueExpressionUEL(location, valueExpression, actx.getFaceletCompositionContext().getCompositeComponentLevel()) : new LocationValueExpression(location, valueExpression, actx.getFaceletCompositionContext().getCompositeComponentLevel());
                    }
                } else if ((this.capabilities & 8) != 0 && (cc = actx.getFaceletCompositionContext().getCompositeComponentFromStack()) != null && (location = (Location)cc.getAttributes().get("org.apache.myfaces.compositecomponent.location")) != null) {
                    valueExpression = ExternalSpecifications.isUnifiedELAvailable() ? new ResourceLocationValueExpressionUEL(location, valueExpression) : new ResourceLocationValueExpression(location, valueExpression);
                }
                ELTextVariable eltv = new ELTextVariable(valueExpression);
                if (actx.isAllowCacheELExpressions() && !actx.isAnyFaceletsVariableResolved()) {
                    this.cached = eltv;
                }
                ELTextVariable eLTextVariable = eltv;
                return eLTextVariable;
            }
            finally {
                actx.afterConstructELExpression();
            }
        }

        @Override
        public void write(Writer out, ELContext ctx) throws ELException, IOException {
            Object v = this.ve.getValue(ctx);
            if (v != null) {
                out.write((String)v);
            }
        }

        @Override
        public String toString(ELContext ctx) throws ELException {
            Object v = this.ve.getValue(ctx);
            if (v != null) {
                return v.toString();
            }
            return null;
        }

        @Override
        public void writeText(ResponseWriter out, ELContext ctx) throws ELException, IOException {
            Object v = this.ve.getValue(ctx);
            if (v != null) {
                out.writeText((String)v, null);
            }
        }
    }

    private static final class ELTextVariable
    extends ELText {
        private final ValueExpression ve;

        public ELTextVariable(ValueExpression ve) {
            super(ve.getExpressionString());
            this.ve = ve;
        }

        @Override
        public boolean isLiteral() {
            return false;
        }

        @Override
        public ELText apply(ExpressionFactory factory, ELContext ctx) {
            return new ELTextVariable(factory.createValueExpression(ctx, this.ve.getExpressionString(), String.class));
        }

        @Override
        public void write(Writer out, ELContext ctx) throws ELException, IOException {
            Object v = this.ve.getValue(ctx);
            if (v != null) {
                out.write((String)v);
            }
        }

        @Override
        public String toString(ELContext ctx) throws ELException {
            Object v = this.ve.getValue(ctx);
            if (v != null) {
                return v.toString();
            }
            return null;
        }

        @Override
        public void writeText(ResponseWriter out, ELContext ctx) throws ELException, IOException {
            Object v = this.ve.getValue(ctx);
            if (v != null) {
                out.writeText((String)v, null);
            }
        }
    }

    private static final class ELTextComposite
    extends ELText {
        private final ELText[] txt;

        public ELTextComposite(ELText[] txt) {
            super(null);
            this.txt = txt;
        }

        @Override
        public void write(Writer out, ELContext ctx) throws ELException, IOException {
            for (int i = 0; i < this.txt.length; ++i) {
                this.txt[i].write(out, ctx);
            }
        }

        @Override
        public void writeText(ResponseWriter out, ELContext ctx) throws ELException, IOException {
            for (int i = 0; i < this.txt.length; ++i) {
                this.txt[i].writeText(out, ctx);
            }
        }

        @Override
        public String toString(ELContext ctx) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.txt.length; ++i) {
                sb.append(this.txt[i].toString(ctx));
            }
            return sb.toString();
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.txt.length; ++i) {
                sb.append(this.txt[i].toString());
            }
            return sb.toString();
        }

        @Override
        public boolean isLiteral() {
            return false;
        }

        @Override
        public ELText apply(ExpressionFactory factory, ELContext ctx) {
            int len = this.txt.length;
            ELText[] nt = new ELText[len];
            for (int i = 0; i < len; ++i) {
                nt[i] = this.txt[i].apply(factory, ctx);
            }
            return new ELTextComposite(nt);
        }
    }

    private static final class LiteralValueExpression
    extends ValueExpression {
        private static final long serialVersionUID = 1L;
        private final String text;

        public LiteralValueExpression(String text) {
            this.text = text;
        }

        public boolean isLiteralText() {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public String getExpressionString() {
            return this.text;
        }

        public boolean equals(Object obj) {
            return false;
        }

        public void setValue(ELContext context, Object value) {
        }

        public boolean isReadOnly(ELContext context) {
            return false;
        }

        public Object getValue(ELContext context) {
            return null;
        }

        public Class<?> getType(ELContext context) {
            return null;
        }

        public Class<?> getExpectedType() {
            return null;
        }
    }
}

