/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.cdi;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Producer;
import jakarta.faces.context.FacesContext;
import jakarta.faces.flow.Flow;
import jakarta.faces.flow.builder.FlowBuilder;
import jakarta.faces.flow.builder.FlowBuilderParameter;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.flow.builder.FlowBuilderImpl;
import org.apache.myfaces.flow.cdi.FlowBuilderCDIExtension;

@Named(value="oam_FLOW_BUILDER_FACTORY_BEAN_NAME")
@ApplicationScoped
public class FlowBuilderFactoryBean {
    public static final String FLOW_BUILDER_FACTORY_BEAN_NAME = "oam_FLOW_BUILDER_FACTORY_BEAN_NAME";
    private List<Flow> flowDefinitions = null;
    @Inject
    private FlowBuilderCDIExtension flowBuilderExtension;

    @Produces
    @FlowBuilderParameter
    public FlowBuilder createFlowBuilderInstance() {
        return new FlowBuilderImpl();
    }

    public synchronized List<Flow> getFlowDefinitions() {
        if (this.flowDefinitions == null) {
            this.flowDefinitions = new ArrayList<Flow>();
            BeanManager beanManager = CDIUtils.getBeanManager(FacesContext.getCurrentInstance().getExternalContext());
            Iterator<Producer<Flow>> it = this.flowBuilderExtension.getFlowProducers().iterator();
            if (it != null) {
                while (it.hasNext()) {
                    Flow flow = (Flow)it.next().produce(beanManager.createCreationalContext(null));
                    this.flowDefinitions.add(flow);
                }
            }
        }
        return this.flowDefinitions;
    }
}

