/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import jakarta.faces.context.ExternalContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.myfaces.spi.ServiceProviderFinder;
import org.apache.myfaces.util.lang.ClassUtils;

public class DefaultServiceProviderFinder
extends ServiceProviderFinder {
    private static final String META_INF_SERVICES = "META-INF/services/";
    private Map<String, List<String>> knownServicesMap = null;

    protected Set<URL> getURLs(String spiClass) {
        Enumeration<URL> profiles = null;
        try {
            profiles = ClassUtils.getContextClassLoader().getResources(META_INF_SERVICES + spiClass);
        }
        catch (IOException e) {
            return null;
        }
        if (null != profiles && profiles.hasMoreElements()) {
            LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
            while (profiles.hasMoreElements()) {
                URL url = profiles.nextElement();
                urls.add(url);
            }
            return urls;
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getServiceProviderList(String spiClass) {
        List<String> result;
        if (this.knownServicesMap != null && (result = this.knownServicesMap.get(spiClass)) != null) {
            return result;
        }
        Set<URL> urls = this.getURLs(spiClass);
        if (!urls.isEmpty()) {
            LinkedList<String> results = new LinkedList<String>();
            for (URL url : urls) {
                try {
                    InputStream is = this.openStreamWithoutCache(url);
                    try {
                        BufferedReader rd;
                        try {
                            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            rd = new BufferedReader(new InputStreamReader(is));
                        }
                        try {
                            String serviceImplName;
                            while ((serviceImplName = rd.readLine()) != null) {
                                int idx = serviceImplName.indexOf(35);
                                if (idx >= 0) {
                                    serviceImplName = serviceImplName.substring(0, idx);
                                }
                                if ((serviceImplName = serviceImplName.trim()).length() == 0) continue;
                                results.add(serviceImplName);
                            }
                        }
                        finally {
                            if (rd == null) continue;
                            rd.close();
                        }
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return results;
        }
        return Collections.emptyList();
    }

    private InputStream openStreamWithoutCache(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }

    @Override
    public <S> ServiceLoader<S> load(Class<S> spiClass) {
        return ServiceLoader.load(spiClass);
    }

    @Override
    public void initKnownServiceProviderMapInfo(ExternalContext ectx, Map<String, List<String>> map) {
        this.knownServicesMap = map;
    }
}

