/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.faces.FacesException;
import jakarta.faces.component.Doctype;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.FaceletHandler;
import jakarta.faces.view.facelets.TagDecorator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.myfaces.config.element.FaceletsProcessing;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.view.facelets.tag.BaseMultipleTagDecorator;
import org.apache.myfaces.view.facelets.tag.BaseTagDecorator;
import org.apache.myfaces.view.facelets.tag.CompositeTagDecorator;
import org.apache.myfaces.view.facelets.tag.CompositeTagLibrary;
import org.apache.myfaces.view.facelets.tag.TagLibrary;
import org.apache.myfaces.view.facelets.tag.faces.html.DefaultTagDecorator;

public abstract class Compiler {
    protected static final Logger log = Logger.getLogger(Compiler.class.getName());
    public static final String EXPRESSION_FACTORY = "compiler.ExpressionFactory";
    private static final TagLibrary EMPTY_LIBRARY = new CompositeTagLibrary(new TagLibrary[0]);
    private boolean validating = false;
    private boolean trimmingWhitespace = false;
    private boolean trimmingComments = false;
    private final List<TagLibrary> libraries = new ArrayList<TagLibrary>();
    private final List<TagDecorator> decorators = new ArrayList<TagDecorator>();
    private final Map<String, String> features = new HashMap<String, String>();
    private boolean developmentProjectStage = false;
    private Collection<FaceletsProcessing> faceletsProcessingConfigurations;

    public final CompilerResult compile(URL src, String alias) throws IOException, FaceletException, ELException, FacesException {
        return this.doCompile(src, alias);
    }

    public final CompilerResult compileViewMetadata(URL src, String alias) throws IOException, FaceletException, ELException, FacesException {
        return this.doCompileViewMetadata(src, alias);
    }

    public final CompilerResult compileCompositeComponentMetadata(URL src, String alias) throws IOException, FaceletException, ELException, FacesException {
        return this.doCompileCompositeComponentMetadata(src, alias);
    }

    public final CompilerResult compileComponent(String taglibURI, String tagName, Map<String, Object> attributes) {
        return this.doCompileComponent(taglibURI, tagName, attributes);
    }

    protected abstract CompilerResult doCompile(URL var1, String var2) throws IOException, FaceletException, ELException, FacesException;

    protected abstract CompilerResult doCompileViewMetadata(URL var1, String var2) throws IOException, FaceletException, ELException, FacesException;

    protected abstract CompilerResult doCompileCompositeComponentMetadata(URL var1, String var2) throws IOException, FaceletException, ELException, FacesException;

    protected abstract CompilerResult doCompileComponent(String var1, String var2, Map<String, Object> var3);

    public final TagDecorator createTagDecorator() {
        if (!this.decorators.isEmpty()) {
            return new BaseMultipleTagDecorator(new DefaultTagDecorator(), new CompositeTagDecorator(this.decorators.toArray(new TagDecorator[this.decorators.size()])));
        }
        return new BaseTagDecorator(new DefaultTagDecorator());
    }

    public final void addTagDecorator(TagDecorator decorator) {
        Assert.notNull((Object)decorator, (String)"decorator");
        if (!this.decorators.contains(decorator)) {
            this.decorators.add(decorator);
        }
    }

    public final ExpressionFactory createExpressionFactory() {
        ExpressionFactory el = (ExpressionFactory)this.featureInstance(EXPRESSION_FACTORY);
        if (el == null) {
            try {
                el = FacesContext.getCurrentInstance().getApplication().getExpressionFactory();
                if (el == null) {
                    log.warning("No default ExpressionFactory from Faces Implementation, attempting to load from Feature[compiler.ExpressionFactory]");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return el;
    }

    private Object featureInstance(String name) {
        String type = this.features.get(name);
        if (type != null) {
            try {
                return ClassUtils.forName((String)type).newInstance();
            }
            catch (Throwable t) {
                throw new FaceletException("Could not instantiate feature[" + name + "]: " + type);
            }
        }
        return null;
    }

    public final TagLibrary createTagLibrary() {
        if (!this.libraries.isEmpty()) {
            return new CompositeTagLibrary(this.libraries.toArray(new TagLibrary[this.libraries.size()]));
        }
        return EMPTY_LIBRARY;
    }

    public final void addTagLibrary(TagLibrary library) {
        Assert.notNull((Object)library, (String)"library");
        if (!this.libraries.contains(library)) {
            this.libraries.add(library);
        }
    }

    public final void setFeature(String name, String value) {
        this.features.put(name, value);
    }

    public final String getFeature(String name) {
        return this.features.get(name);
    }

    public final boolean isTrimmingComments() {
        return this.trimmingComments;
    }

    public final void setTrimmingComments(boolean trimmingComments) {
        this.trimmingComments = trimmingComments;
    }

    public final boolean isTrimmingWhitespace() {
        return this.trimmingWhitespace;
    }

    public final void setTrimmingWhitespace(boolean trimmingWhitespace) {
        this.trimmingWhitespace = trimmingWhitespace;
    }

    public final boolean isValidating() {
        return this.validating;
    }

    public final void setValidating(boolean validating) {
        this.validating = validating;
    }

    public final boolean isDevelopmentProjectStage() {
        return this.developmentProjectStage;
    }

    public final void setDevelopmentProjectStage(boolean developmentProjectStage) {
        this.developmentProjectStage = developmentProjectStage;
    }

    public Collection<FaceletsProcessing> getFaceletsProcessingConfigurations() {
        return this.faceletsProcessingConfigurations;
    }

    public void setFaceletsProcessingConfigurations(Collection<FaceletsProcessing> faceletsProcessingConfigurations) {
        this.faceletsProcessingConfigurations = faceletsProcessingConfigurations;
    }

    public static class CompilerResult {
        private FaceletHandler faceletHandler;
        private Doctype doctype;

        CompilerResult(FaceletHandler faceletHandler, Doctype doctype) {
            this.faceletHandler = faceletHandler;
            this.doctype = doctype;
        }

        public FaceletHandler getFaceletHandler() {
            return this.faceletHandler;
        }

        public void setFaceletHandler(FaceletHandler faceletHandler) {
            this.faceletHandler = faceletHandler;
        }

        public Doctype getDoctype() {
            return this.doctype;
        }

        public void setDoctypeUnit(Doctype doctype) {
            this.doctype = doctype;
        }
    }
}

