/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.listener.phase;

import java.lang.annotation.Annotation;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.AfterPhase;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.BeforePhase;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.JsfLifecyclePhaseInformation;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.JsfPhaseId;
import org.apache.myfaces.extensions.cdi.jsf.impl.listener.phase.AfterPhaseBinding;
import org.apache.myfaces.extensions.cdi.jsf.impl.listener.phase.BeforePhaseBinding;

@RequestScoped
@Named
public class JsfRequestLifecycleBroadcaster
implements JsfLifecyclePhaseInformation {
    private PhaseId facesPhaseId;
    @Inject
    private Event<PhaseEvent> phaseEvent;
    @Inject
    @BeforePhase(value=JsfPhaseId.ANY_PHASE)
    private Event<PhaseEvent> beforeAnyPhaseEvent;
    @Inject
    @AfterPhase(value=JsfPhaseId.ANY_PHASE)
    private Event<PhaseEvent> afterAnyPhaseEvent;

    public void broadcastBeforeEvent(PhaseEvent phaseEvent) {
        this.facesPhaseId = phaseEvent.getPhaseId();
        this.phaseEvent.select(new Annotation[]{this.createAnnotationLiteral(phaseEvent.getPhaseId(), true)}).fire((Object)phaseEvent);
        this.beforeAnyPhaseEvent.fire((Object)phaseEvent);
    }

    public void broadcastAfterEvent(PhaseEvent phaseEvent) {
        this.phaseEvent.select(new Annotation[]{this.createAnnotationLiteral(phaseEvent.getPhaseId(), false)}).fire((Object)phaseEvent);
        this.afterAnyPhaseEvent.fire((Object)phaseEvent);
    }

    private Annotation createAnnotationLiteral(PhaseId phaseId, boolean isBeforeEvent) {
        if (isBeforeEvent) {
            return this.createBeforeLiteral(phaseId);
        }
        return this.createAfterLiteral(phaseId);
    }

    private Annotation createBeforeLiteral(final PhaseId phaseId) {
        return new BeforePhaseBinding(){
            private static final long serialVersionUID = 849645435335842723L;

            public JsfPhaseId value() {
                return JsfPhaseId.convertFromFacesClass((PhaseId)phaseId);
            }
        };
    }

    private Annotation createAfterLiteral(final PhaseId phaseId) {
        return new AfterPhaseBinding(){
            private static final long serialVersionUID = 490037768660184656L;

            public JsfPhaseId value() {
                return JsfPhaseId.convertFromFacesClass((PhaseId)phaseId);
            }
        };
    }

    public boolean isRestoreViewPhase() {
        return PhaseId.RESTORE_VIEW.equals(this.facesPhaseId);
    }

    public boolean isApplyRequestValuesPhase() {
        return PhaseId.APPLY_REQUEST_VALUES.equals(this.facesPhaseId);
    }

    public boolean isProcessValidationsPhase() {
        return PhaseId.PROCESS_VALIDATIONS.equals(this.facesPhaseId);
    }

    public boolean isUpdateModelValuesPhase() {
        return PhaseId.UPDATE_MODEL_VALUES.equals(this.facesPhaseId);
    }

    public boolean isInvokeApplicationPhase() {
        return PhaseId.INVOKE_APPLICATION.equals(this.facesPhaseId);
    }

    public boolean isRenderResponsePhase() {
        return PhaseId.RENDER_RESPONSE.equals(this.facesPhaseId);
    }
}

