/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.security;

import javax.faces.FacesException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.myfaces.extensions.cdi.core.api.activation.Deactivatable;
import org.apache.myfaces.extensions.cdi.core.impl.util.ClassDeactivation;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.SecurityUtils;

public class SecurityViolationAwareActionListener
implements ActionListener,
Deactivatable {
    private ActionListener wrapped;
    private final boolean deactivated;

    public SecurityViolationAwareActionListener(ActionListener wrapped) {
        this.wrapped = wrapped;
        this.deactivated = !this.isActivated();
    }

    public void processAction(ActionEvent actionEvent) {
        try {
            this.wrapped.processAction(actionEvent);
        }
        catch (FacesException facesException) {
            if (this.deactivated) {
                throw facesException;
            }
            SecurityUtils.tryToHandleSecurityViolation((RuntimeException)((Object)facesException));
        }
    }

    public boolean isActivated() {
        return ClassDeactivation.isClassActivated(this.getClass());
    }
}

