/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf2.impl.navigation;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.cdi.core.api.activation.Deactivatable;
import org.apache.myfaces.extensions.cdi.core.api.config.view.DefaultErrorView;
import org.apache.myfaces.extensions.cdi.core.api.config.view.ViewConfig;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;
import org.apache.myfaces.extensions.cdi.core.impl.util.ClassDeactivation;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.api.config.JsfModuleConfig;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.Page;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.ViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.ViewConfigCache;
import org.apache.myfaces.extensions.cdi.jsf.impl.navigation.ViewConfigAwareNavigationHandler;
import org.apache.myfaces.extensions.cdi.jsf2.impl.navigation.AccessScopeAwareNavigationHandler;
import org.apache.myfaces.extensions.cdi.jsf2.impl.navigation.NavigationCaseMapWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodiNavigationHandler
extends ConfigurableNavigationHandler
implements Deactivatable {
    private Set<String> otherOutcomes = new CopyOnWriteArraySet<String>();
    private Map<String, NavigationCase> viewConfigBasedNavigationCaseCache = new ConcurrentHashMap<String, NavigationCase>();
    private final NavigationHandler wrapped;
    private final boolean deactivated;
    private final boolean addViewConfigsAsNavigationCase;

    public CodiNavigationHandler(NavigationHandler navigationHandler) {
        this.wrapped = navigationHandler;
        this.deactivated = !this.isActivated();
        this.addViewConfigsAsNavigationCase = !this.deactivated ? this.isAddViewConfigsAsNavigationCaseActivated() : false;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        if (this.deactivated || this.isUnhandledExceptionQueued(context)) {
            this.wrapped.handleNavigation(context, fromAction, outcome);
        } else if (context.getRenderResponse() || context.getViewRoot() == null) {
            new ViewConfigAwareNavigationHandler(this.wrapped, true).handleNavigation(context, fromAction, outcome);
        } else {
            this.getWrappedNavigationHandler().handleNavigation(context, fromAction, outcome);
        }
    }

    private boolean isUnhandledExceptionQueued(FacesContext context) {
        return context.getExceptionHandler().getUnhandledExceptionQueuedEvents() != null && context.getExceptionHandler().getUnhandledExceptionQueuedEvents().iterator().hasNext();
    }

    private NavigationHandler getWrappedNavigationHandler() {
        ViewConfigAwareNavigationHandler viewConfigAwareNavigationHandler = new ViewConfigAwareNavigationHandler(this.wrapped, true);
        return new AccessScopeAwareNavigationHandler(viewConfigAwareNavigationHandler);
    }

    public NavigationCase getNavigationCase(FacesContext context, String action, String outcome) {
        if (this.wrapped instanceof ConfigurableNavigationHandler) {
            if (action == null && outcome != null && outcome.contains(".") && outcome.startsWith("class ") && !this.otherOutcomes.contains(outcome)) {
                String originalOutcome = outcome;
                NavigationCase navigationCase = this.viewConfigBasedNavigationCaseCache.get(originalOutcome);
                if (navigationCase != null) {
                    return navigationCase;
                }
                outcome = outcome.substring(6);
                ViewConfigDescriptor entry = null;
                if (DefaultErrorView.class.getName().equals(originalOutcome)) {
                    entry = ViewConfigCache.getDefaultErrorViewConfigDescriptor();
                }
                if (entry == null) {
                    Class loadedClass = ClassUtils.tryToLoadClassForName((String)outcome);
                    if (loadedClass == null) {
                        this.otherOutcomes.add(originalOutcome);
                    } else if (ViewConfig.class.isAssignableFrom(loadedClass)) {
                        entry = ViewConfigCache.getViewConfigDescriptor(loadedClass);
                    }
                }
                if (entry != null) {
                    navigationCase = new NavigationCase("*", null, null, null, entry.getViewId(), null, Page.NavigationMode.REDIRECT.equals((Object)entry.getNavigationMode()), false);
                    this.viewConfigBasedNavigationCaseCache.put(originalOutcome, navigationCase);
                    return navigationCase;
                }
            }
            return ((ConfigurableNavigationHandler)this.wrapped).getNavigationCase(context, action, outcome);
        }
        return null;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        HashMap<String, Set<NavigationCase>> result = null;
        if (this.wrapped instanceof ConfigurableNavigationHandler) {
            result = ((ConfigurableNavigationHandler)this.wrapped).getNavigationCases();
        }
        if (result == null) {
            result = new HashMap<String, Set<NavigationCase>>();
        }
        if (!this.addViewConfigsAsNavigationCase || this.deactivated) {
            return result;
        }
        return new NavigationCaseMapWrapper(result, this.wrapped);
    }

    public boolean isActivated() {
        return ClassDeactivation.isClassActivated(((Object)((Object)this)).getClass());
    }

    private boolean isAddViewConfigsAsNavigationCaseActivated() {
        JsfModuleConfig config = (JsfModuleConfig)CodiUtils.getContextualReferenceByClass(JsfModuleConfig.class, (Annotation[])new Annotation[0]);
        return config.isUseViewConfigsAsNavigationCasesEnabled();
    }
}

