/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf2.impl.scope.mapped;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;
import javax.faces.bean.ViewScoped;
import org.apache.myfaces.extensions.cdi.core.api.activation.Deactivatable;
import org.apache.myfaces.extensions.cdi.core.api.projectstage.ProjectStage;
import org.apache.myfaces.extensions.cdi.core.api.startup.CodiStartupBroadcaster;
import org.apache.myfaces.extensions.cdi.core.impl.projectstage.ProjectStageProducer;
import org.apache.myfaces.extensions.cdi.core.impl.util.ClassDeactivation;
import org.apache.myfaces.extensions.cdi.jsf2.impl.scope.mapped.Jsf2BeanWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedJsf2ScopeExtension
implements Extension,
Deactivatable {
    private final Logger logger = Logger.getLogger(MappedJsf2ScopeExtension.class.getName());
    private Map<Class<? extends Annotation>, Class<? extends Annotation>> mappedJsfScopes = new HashMap<Class<? extends Annotation>, Class<? extends Annotation>>();

    public MappedJsf2ScopeExtension() {
        this.mappedJsfScopes.put(javax.faces.bean.ApplicationScoped.class, ApplicationScoped.class);
        this.mappedJsfScopes.put(javax.faces.bean.SessionScoped.class, SessionScoped.class);
        this.mappedJsfScopes.put(RequestScoped.class, javax.enterprise.context.RequestScoped.class);
        this.mappedJsfScopes.put(ViewScoped.class, ViewScoped.class);
    }

    protected void convertJsf2Scopes(@Observes ProcessAnnotatedType processAnnotatedType) {
        if (!this.isActivated()) {
            return;
        }
        CodiStartupBroadcaster.broadcastStartup();
        Class<? extends Annotation> jsf2ScopeAnnotation = this.getJsf2ScopeAnnotation(processAnnotatedType);
        if (jsf2ScopeAnnotation != null && !this.beanUsesUnsupportedManagedBeanAnnotation(processAnnotatedType)) {
            processAnnotatedType.setAnnotatedType(this.convertBean(processAnnotatedType.getAnnotatedType(), jsf2ScopeAnnotation));
        }
    }

    private AnnotatedType convertBean(AnnotatedType annotatedType, Class<? extends Annotation> jsf2ScopeAnnotation) {
        this.logConvertedBean(annotatedType, jsf2ScopeAnnotation);
        return new Jsf2BeanWrapper(annotatedType, this.mappedJsfScopes.get(jsf2ScopeAnnotation), jsf2ScopeAnnotation);
    }

    private Class<? extends Annotation> getJsf2ScopeAnnotation(ProcessAnnotatedType processAnnotatedType) {
        for (Class<? extends Annotation> currentJsfScope : this.mappedJsfScopes.keySet()) {
            if (!processAnnotatedType.getAnnotatedType().getJavaClass().isAnnotationPresent(currentJsfScope)) continue;
            return currentJsfScope;
        }
        return null;
    }

    private void logConvertedBean(AnnotatedType annotatedType, Class<? extends Annotation> jsf2ScopeAnnotation) {
        ProjectStage projectStage = ProjectStageProducer.getInstance().getProjectStage();
        if (projectStage == ProjectStage.Development) {
            this.logger.info("JSF2 bean was converted to a CDI bean. type: " + annotatedType.getJavaClass().getName() + " original scope: " + jsf2ScopeAnnotation.getName());
        }
    }

    private boolean beanUsesUnsupportedManagedBeanAnnotation(ProcessAnnotatedType processAnnotatedType) {
        Class beanClass = processAnnotatedType.getAnnotatedType().getJavaClass();
        if (!beanClass.isAnnotationPresent(ManagedBean.class)) {
            return false;
        }
        ManagedBean managedBeanAnnotation = beanClass.getAnnotation(ManagedBean.class);
        if (managedBeanAnnotation.eager()) {
            ProjectStage projectStage = ProjectStageProducer.getInstance().getProjectStage();
            if (projectStage == ProjectStage.Development) {
                this.logger.warning("Bean of type " + beanClass.getName() + " uses @" + ManagedBean.class.getName() + " in combination with #eager = true. That's not supported with CDI. " + "The bean won't get transformed to a CDI bean.");
            }
            return true;
        }
        return false;
    }

    public boolean isActivated() {
        return ClassDeactivation.isClassActivated(this.getClass());
    }
}

