/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.api.provider;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.cdi.core.api.UnhandledException;
import org.apache.myfaces.extensions.cdi.core.api.provider.ServiceProviderContext;
import org.apache.myfaces.extensions.cdi.core.api.tools.InvocationOrderComparator;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;
import org.apache.myfaces.extensions.cdi.core.api.util.ConfigUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceProvider<T> {
    private static final Logger LOGGER = Logger.getLogger(ServiceProvider.class.getName());
    protected static final String SERVICE_CONFIG = "META-INF/services/";
    protected static final String FILE_ENCODING = "UTF-8";
    protected Class<T> serviceType;
    protected ServiceProviderContext serviceProviderContext;
    private static final String API_PACKAGE = ".api.";
    private static final String IMPL_PACKAGE = ".impl.";
    private static final String CUSTOM_PACKAGE = ".custom.";
    private static final String CUSTOM_SERVICE_PROVIDER_NAME = ServiceProvider.class.getName().replace(".api.", ".custom.");
    private static final String DEFAULT_SERVICE_PROVIDER_NAME = ServiceProvider.class.getName().replace(".api.", ".impl.").replace(".ServiceProvider", ".DefaultServiceProvider");
    private static final String CUSTOM_SERVICE_PROVIDER_CONTEXT_NAME = ServiceProviderContext.class.getName().replace(".api.", ".custom.");
    private static final String DEFAULT_SERVICE_PROVIDER_CONTEXT_NAME = ServiceProviderContext.class.getName().replace(".api.", ".impl.").replace(".ServiceProviderContext", ".DefaultServiceProviderContext");
    protected static final Class<? extends ServiceProvider> SERVICE_PROVIDER_CLASS;
    protected static final Class<? extends ServiceProviderContext> SERVICE_PROVIDER_CONTEXT_CLASS;

    public static <S> List<S> loadServices(Class<S> serviceType) {
        ServiceProviderContext serviceProviderContext = ServiceProvider.createServiceProviderContext(serviceType);
        return ServiceProvider.loadServices(serviceType, serviceProviderContext);
    }

    public static <S> ServiceProviderContext createServiceProviderContext(Class<S> serviceType) {
        return ClassUtils.tryToInstantiateClass(SERVICE_PROVIDER_CONTEXT_CLASS);
    }

    public static <S> List<S> loadServices(Class<S> serviceType, ServiceProviderContext serviceProviderContext) {
        ServiceProvider<S> serviceProvider = ServiceProvider.getServiceProvider(serviceType, serviceProviderContext);
        return serviceProvider.loadServiceImplementations();
    }

    private static <S> ServiceProvider<S> getServiceProvider(Class<S> serviceType, ServiceProviderContext serviceProviderContext) {
        try {
            Constructor<? extends ServiceProvider> constructor = SERVICE_PROVIDER_CLASS.getDeclaredConstructor(Class.class, ServiceProviderContext.class);
            constructor.setAccessible(true);
            ServiceProvider customServiceProvider = constructor.newInstance(serviceType, serviceProviderContext);
            return customServiceProvider;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected ServiceProvider(Class<T> serviceType, ServiceProviderContext serviceProviderContext) {
        this.serviceType = serviceType;
        this.serviceProviderContext = serviceProviderContext;
    }

    protected abstract List<T> loadServiceImplementations();

    private static <S> Class<S> resolveImplementation(Class<S> type, String customName) {
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.add(customName);
        List<String> configuredClassNames = ConfigUtils.getConfiguredValue(type.getSimpleName() + "." + type.getName());
        if (configuredClassNames != null) {
            classNames.addAll(configuredClassNames);
        }
        ArrayList<Class> classList = new ArrayList<Class>(classNames.size());
        Class currentClass = null;
        for (String currentClassName : classNames) {
            block5: {
                try {
                    currentClass = ClassUtils.tryToLoadClassForName(currentClassName);
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block5;
                    LOGGER.warning("Couldn't load class: " + currentClassName);
                }
            }
            if (currentClass == null) continue;
            classList.add(currentClass);
        }
        Class result = null;
        if (!classList.isEmpty()) {
            Collections.sort(classList, new InvocationOrderComparator());
            result = (Class)classList.iterator().next();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class serviceProviderClass = null;
        Class serviceProviderContextClass = null;
        try {
            serviceProviderClass = ServiceProvider.resolveImplementation(ServiceProvider.class, CUSTOM_SERVICE_PROVIDER_NAME);
            serviceProviderContextClass = ServiceProvider.resolveImplementation(ServiceProviderContext.class, CUSTOM_SERVICE_PROVIDER_CONTEXT_NAME);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "An exception occurred during the initialization of the service provider", e);
            }
        }
        finally {
            try {
                if (serviceProviderClass == null) {
                    serviceProviderClass = ClassUtils.loadClassForName(DEFAULT_SERVICE_PROVIDER_NAME);
                }
                if (serviceProviderContextClass == null) {
                    serviceProviderContextClass = ClassUtils.loadClassForName(DEFAULT_SERVICE_PROVIDER_CONTEXT_NAME);
                }
            }
            catch (Exception exception) {
                throw new UnhandledException(exception);
            }
        }
        SERVICE_PROVIDER_CLASS = serviceProviderClass;
        SERVICE_PROVIDER_CONTEXT_CLASS = serviceProviderContextClass;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(SERVICE_PROVIDER_CLASS.getName() + " installed successfully.");
            LOGGER.info(SERVICE_PROVIDER_CONTEXT_CLASS.getName() + " installed successfully.");
        }
    }
}

