/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.metadata.extractor;

import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.metadata.extractor.MetaDataExtractor;
import org.apache.myfaces.extensions.validator.core.property.DefaultPropertyInformation;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.core.property.PropertyInformation;
import org.apache.myfaces.extensions.validator.core.storage.MetaDataStorage;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValAnnotationUtils;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultComponentMetaDataExtractor
implements MetaDataExtractor {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());

    public DefaultComponentMetaDataExtractor() {
        this.logger.fine(this.getClass().getName() + " instantiated");
    }

    @ToDo(value=Priority.MEDIUM)
    public PropertyInformation extract(FacesContext facesContext, Object object) {
        if (!(object instanceof UIComponent)) {
            if (object != null) {
                this.logger.warning(object.getClass() + " is no valid component");
            }
            return new DefaultPropertyInformation();
        }
        UIComponent uiComponent = (UIComponent)object;
        this.logger.finest("start extracting meta-data of " + uiComponent.getClass().getName());
        PropertyDetails propertyDetails = ExtValUtils.getELHelper().getPropertyDetailsOfValueBinding(uiComponent);
        if (propertyDetails == null) {
            return new DefaultPropertyInformation();
        }
        Class entityClass = ProxyUtils.getUnproxiedClass(propertyDetails.getBaseObject().getClass());
        PropertyInformation propertyInformation = this.getPropertyInformation(entityClass, propertyDetails);
        this.logger.finest("extract finished");
        return propertyInformation;
    }

    protected PropertyInformation getPropertyInformation(Class entityClass, PropertyDetails propertyDetails) {
        MetaDataStorage storage = this.getMetaDataStorage();
        PropertyInformation propertyInformation = new DefaultPropertyInformation();
        if (this.isCached(storage, entityClass, propertyDetails.getProperty())) {
            propertyInformation.setInformation("property_details", propertyDetails);
            for (MetaDataEntry metaDataEntry : this.getCachedMetaData(storage, entityClass, propertyDetails.getProperty())) {
                propertyInformation.addMetaDataEntry(metaDataEntry);
            }
        } else {
            propertyInformation = ExtValAnnotationUtils.extractAnnotations(entityClass, propertyDetails);
            this.cacheMetaData(storage, propertyInformation);
        }
        return propertyInformation;
    }

    protected boolean isCached(MetaDataStorage storage, Class entityClass, String property) {
        return storage.containsMetaDataFor(entityClass, property);
    }

    protected void cacheMetaData(MetaDataStorage storage, PropertyInformation propertyInformation) {
        storage.storeMetaDataOf(propertyInformation);
    }

    protected MetaDataEntry[] getCachedMetaData(MetaDataStorage storage, Class entityClass, String property) {
        return storage.getMetaData(entityClass, property);
    }

    protected MetaDataStorage getMetaDataStorage() {
        return ExtValUtils.getStorage(MetaDataStorage.class, MetaDataStorage.class.getName());
    }
}

