/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.requestParameterProvider.jsf;

import java.util.List;
import java.util.Map;

import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextWrapper;

import org.apache.myfaces.orchestra.requestParameterProvider.RequestParameterProviderManager;

public class RequestParameterExternalContextWrapper extends ExternalContextWrapper
{
    private ExternalContext _delegate;
    
    public RequestParameterExternalContextWrapper(ExternalContext delegate)
    {
        this._delegate = delegate;
    }

    @Override
    public String encodeRedirectURL(String baseUrl,
            Map<String, List<String>> parameters)
    {
        // Mojarra 2.1.3 does not call encodeURL internally, but MyFaces 2.0.x/2.1.x does.
        // Anyway, the place to add Orchestra parameters for redirect should be here.
        String url = super.encodeRedirectURL(baseUrl, parameters);
        if (url != null)
        {
            url = RequestParameterProviderManager.getInstance().encodeAndAttachParameters(url);
        }
        return url;
    }

    @Override
    public ExternalContext getWrapped()
    {
        return _delegate;
    }
}
