/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.context;

import org.apache.myfaces.tobago.internal.context.ClientPropertiesKey;

public final class ImageCacheKey {
    private final ClientPropertiesKey clientPropertiesKey;
    private final String name;
    private final String extension;
    private final int hashCode;

    public ImageCacheKey(ClientPropertiesKey clientPropertiesKey, String name, String extension) {
        this.name = name;
        this.extension = extension;
        this.clientPropertiesKey = clientPropertiesKey;
        this.hashCode = this.calcHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageCacheKey that = (ImageCacheKey)o;
        if (!this.clientPropertiesKey.equals(that.clientPropertiesKey)) {
            return false;
        }
        if (this.extension != null ? !this.extension.equals(that.extension) : that.extension != null) {
            return false;
        }
        return this.name.equals(that.name);
    }

    private int calcHashCode() {
        int result = this.clientPropertiesKey.hashCode();
        result = 31 * result + this.name.hashCode();
        if (this.extension != null) {
            result = 31 * result + this.extension.hashCode();
        }
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

