/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUILabel;
import org.apache.myfaces.tobago.internal.component.AbstractUISeparator;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SeparatorRenderer
extends RendererBase {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUISeparator separator = (AbstractUISeparator)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = separator.getClientId(facesContext);
        String label = this.getLabel(separator);
        Markup markup = separator.getMarkup();
        if (label != null) {
            writer.startElement(HtmlElements.P);
            writer.writeIdAttribute(clientId);
            writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
            writer.writeClassAttribute((CssItem)TobagoClass.SEPARATOR, TobagoClass.SEPARATOR.createMarkup(separator.getMarkup()), new CssItem[]{separator.getCustomClass()});
            writer.writeText(label);
            writer.endElement(HtmlElements.P);
        } else {
            writer.startElement(HtmlElements.HR);
            writer.writeIdAttribute(clientId);
            writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
            writer.writeClassAttribute((CssItem)TobagoClass.SEPARATOR, TobagoClass.SEPARATOR.createMarkup(separator.getMarkup()), new CssItem[]{separator.getCustomClass()});
            writer.endElement(HtmlElements.HR);
        }
    }

    private String getLabel(AbstractUISeparator separator) {
        String label = separator.getLabel();
        UIComponent facet = ComponentUtils.getFacet((UIComponent)separator, Facets.label);
        if (label == null && facet != null) {
            label = String.valueOf(((AbstractUILabel)facet).getValue());
        }
        return label;
    }
}

