/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUICommandBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIImage;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class ImageRenderer
extends RendererBase {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        AbstractUIImage image = (AbstractUIImage)component;
        String value = image.getUrl();
        boolean fontAwesome = StringUtils.startsWith(value, "fa-");
        boolean disabled = image.isDisabled() || image.getParent() instanceof AbstractUICommandBase && ((AbstractUICommandBase)image.getParent()).isDisabled();
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)image);
        Markup markup = image.getMarkup();
        if (fontAwesome) {
            writer.startElement(HtmlElements.I);
            writer.writeIdAttribute(image.getClientId(facesContext));
            writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
            writer.writeClassAttribute(Icons.FA, Icons.custom(value), disabled ? BootstrapClass.DISABLED : null, image.getCustomClass());
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
            writer.endElement(HtmlElements.I);
        } else {
            String alt = image.getAlt();
            writer.startElement(HtmlElements.IMG);
            writer.writeIdAttribute(image.getClientId(facesContext));
            writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)image);
            writer.writeAttribute(HtmlAttributes.SRC, value, true);
            writer.writeAttribute(HtmlAttributes.ALT, alt != null ? alt : "", true);
            writer.writeClassAttribute((CssItem)TobagoClass.IMAGE, TobagoClass.IMAGE.createMarkup(markup), new CssItem[]{disabled ? BootstrapClass.DISABLED : null, image.getCustomClass()});
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
            writer.endElement(HtmlElements.IMG);
        }
    }
}

