/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.dateformat;

import java.util.Date;
import java.util.LinkedList;
import org.apache.myfaces.dateformat.DateFormatSymbols;
import org.apache.myfaces.dateformat.ParserContext;
import org.apache.myfaces.dateformat.WeekDate;

public class SimpleDateFormatter {
    private static final long MSECS_PER_SEC = 1000L;
    private static final long MSECS_PER_MIN = 60000L;
    private static final long MSECS_PER_HOUR = 3600000L;
    private static final long MSECS_PER_DAY = 86400000L;
    private static final long MSECS_PER_WEEK = 604800000L;
    private static final int[] MONTH_LEN = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private DateFormatSymbols symbols;
    private String[] ops;
    boolean yearIsWeekYear;
    int firstDayOfWeek;

    public static WeekDate getIsoWeekDate(Date date) {
        int f;
        int e;
        int s;
        int b;
        int a;
        int year = SimpleDateFormatter.fullYearFromDate(date.getYear());
        int month = date.getMonth() + 1;
        int day = date.getDate();
        if (month <= 2) {
            a = year - 1;
            b = (int)Math.floor(a / 4) - (int)Math.floor(a / 100) + (int)Math.floor(a / 400);
            int c = (int)Math.floor((a - 1) / 4) - (int)Math.floor((a - 1) / 100) + (int)Math.floor((a - 1) / 400);
            s = b - c;
            e = 0;
            f = day - 1 + 31 * (month - 1);
        } else {
            a = year;
            b = (int)Math.floor(a / 4) - (int)Math.floor(a / 100) + (int)Math.floor(a / 400);
            int c = (int)Math.floor((a - 1) / 4) - (int)Math.floor((a - 1) / 100) + (int)Math.floor((a - 1) / 400);
            s = b - c;
            e = s + 1;
            f = day + (int)Math.floor((153 * (month - 3) + 2) / 5) + 58 + s;
        }
        int g = (a + b) % 7;
        int d = (f + g - e) % 7;
        int n = f + 3 - d;
        if (n < 0) {
            int resultWeek = 53 - (int)Math.floor((g - s) / 5);
            return new WeekDate(year - 1, resultWeek);
        }
        if (n > 364 + s) {
            int resultWeek = 1;
            return new WeekDate(year + 1, resultWeek);
        }
        int resultWeek = (int)Math.floor(n / 7) + 1;
        return new WeekDate(year, resultWeek);
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    private static int dayOfWeek(int year, int month, int day) {
        if ((month -= 2) < 1) {
            month += 12;
            --year;
        }
        int cent = year / 100;
        int base = (26 * month - 2) / 10 + day + (year %= 100) + year / 4 + cent / 4 + 5 * cent;
        int dow = base % 7;
        return dow;
    }

    public static WeekDate getWeekDate(Date date, int firstDayOfWeek) {
        int jan1Weekday;
        int pivotOffset;
        int year = SimpleDateFormatter.fullYearFromDate(date.getYear());
        int month = date.getMonth() + 1;
        int day = date.getDate();
        boolean thisIsLeapYear = SimpleDateFormatter.isLeapYear(year);
        int dayOfYear = day + MONTH_LEN[month - 1];
        if (thisIsLeapYear && month > 2) {
            ++dayOfYear;
        }
        if ((pivotOffset = firstDayOfWeek - (jan1Weekday = SimpleDateFormatter.dayOfWeek(year, 1, 1))) > 3) {
            pivotOffset -= 7;
        } else if (pivotOffset < -3) {
            pivotOffset += 7;
        }
        int dayOffset = dayOfYear - 1;
        if (dayOffset < pivotOffset) {
            boolean prevIsLeapYear = SimpleDateFormatter.isLeapYear(year - 1);
            if (pivotOffset == 3 || pivotOffset == 2 && prevIsLeapYear) {
                return new WeekDate(year - 1, 53);
            }
            return new WeekDate(year - 1, 52);
        }
        int daysFromFirstWeekStart = dayOfYear - 1 - pivotOffset;
        int weekNumber = daysFromFirstWeekStart / 7 + 1;
        if (weekNumber < 53 || pivotOffset == -3 || pivotOffset == -2 && thisIsLeapYear) {
            return new WeekDate(year, weekNumber);
        }
        return new WeekDate(year + 1, 1);
    }

    private static long getStartOfWeekYear(int year, int firstDayOfWeek) {
        Date d1 = new Date(SimpleDateFormatter.shortYearFromDate(year), 0, 1, 0, 0, 0);
        int firstDayOfYear = d1.getDay();
        int dayDiff = firstDayOfWeek - firstDayOfYear;
        int dayShift = dayDiff >= 4 ? 7 - dayDiff : (dayDiff >= 0 ? dayDiff : (dayDiff >= -3 ? dayDiff : 7 + dayDiff));
        long weekYearStartMsecs = d1.getTime() + (long)dayShift * 86400000L;
        return weekYearStartMsecs;
    }

    private static Date getDateForWeekDate(int year, int week, int day, int hour, int min, int sec, int firstDayOfWeek) {
        long msecsBase = SimpleDateFormatter.getStartOfWeekYear(year, firstDayOfWeek);
        long msecsOffset = (long)(week - 1) * 604800000L;
        msecsOffset += (long)(day - 1) * 86400000L;
        msecsOffset += (long)hour * 3600000L;
        msecsOffset += (long)min * 60000L;
        Date finalDate = new Date();
        finalDate.setTime(msecsBase + (msecsOffset += (long)sec * 1000L));
        return finalDate;
    }

    private static int fullYearFromDate(int year) {
        if (year < 1900) {
            return year + 1900;
        }
        return year;
    }

    private static int shortYearFromDate(int year) {
        if (year > 1900) {
            return year - 1900;
        }
        return year;
    }

    private static Date createDateFromContext(ParserContext context) {
        Date date = context.weekOfWeekYear != 0 ? SimpleDateFormatter.getDateForWeekDate(context.weekYear, context.weekOfWeekYear, context.day, context.hour, context.min, context.sec, context.firstDayOfWeek) : new Date(context.year - 1900, context.month, context.day, context.hour, context.min, context.sec);
        return date;
    }

    private static String substr(String s, int start, int len) {
        String s2 = s.substring(start);
        if (s2.length() <= len) {
            return s2;
        }
        return s2.substring(0, len);
    }

    private static ParserContext parseOps(DateFormatSymbols symbols, boolean yearIsWeekYear, int firstDayOfWeek, String[] ops, String dateStr) {
        ParserContext context = new ParserContext(firstDayOfWeek);
        int dateIndex = 0;
        int dateStrLen = dateStr.length();
        for (int i = 0; i < ops.length && dateIndex < dateStrLen; ++i) {
            String op = ops[i];
            String optype = op.substring(0, 2);
            String opval = op.substring(2);
            if (optype.equals("f:")) {
                SimpleDateFormatter.parsePattern(symbols, yearIsWeekYear, context, opval, dateStr, dateIndex);
                if (context.newIndex < 0 || context.invalid) break;
                dateIndex = context.newIndex;
                continue;
            }
            if (!optype.equals("q:") && !optype.equals("l:")) continue;
            int oplen = opval.length();
            String s = SimpleDateFormatter.substr(dateStr, dateIndex, oplen);
            if (!opval.equals(s)) {
                context.invalid = true;
                break;
            }
            dateIndex += oplen;
        }
        if (dateIndex < dateStrLen) {
            context.invalid = true;
        }
        return context;
    }

    private static void parsePattern(DateFormatSymbols symbols, boolean yearIsWeekYear, ParserContext context, String patternSub, String dateStr, int dateIndex) {
        char c = patternSub.charAt(0);
        int patlen = patternSub.length();
        context.newIndex = dateIndex;
        if (c == 'y') {
            int year = SimpleDateFormatter.parseNum(context, dateStr, 4, dateIndex);
            if (context.newIndex - dateIndex < 4) {
                context.year = year;
                context.ambiguousYear = true;
            } else {
                context.year = year;
            }
            if (yearIsWeekYear) {
                context.weekYear = context.year;
                context.ambiguousWeekYear = context.ambiguousYear;
            }
        } else if (c == 'x') {
            int year = SimpleDateFormatter.parseNum(context, dateStr, 4, dateIndex);
            if (context.newIndex - dateIndex < 4) {
                context.weekYear = year;
                context.ambiguousWeekYear = true;
            } else {
                context.weekYear = year;
            }
        } else if (c == 'M') {
            if (patlen == 3) {
                String fragment = SimpleDateFormatter.substr(dateStr, dateIndex, 3);
                int index = SimpleDateFormatter.parseIndexOf(context, symbols.shortMonths, fragment);
                if (index != -1) {
                    context.month = index;
                }
            } else if (patlen >= 4) {
                String fragment = dateStr.substring(dateIndex);
                int index = SimpleDateFormatter.parsePrefixOf(context, symbols.months, fragment);
                if (index != -1) {
                    context.month = index;
                }
            } else {
                context.month = SimpleDateFormatter.parseNum(context, dateStr, 2, dateIndex) - 1;
            }
        } else if (c == 'd') {
            context.day = SimpleDateFormatter.parseNum(context, dateStr, 2, dateIndex);
        } else if (c == 'E') {
            if (patlen <= 3) {
                String fragment = dateStr.substring(dateIndex, dateIndex + 3);
                int index = SimpleDateFormatter.parseIndexOf(context, symbols.shortWeekdays, fragment);
                if (index != -1) {
                    context.dayOfWeek = index;
                }
            } else {
                String fragment = dateStr.substring(dateIndex);
                int index = SimpleDateFormatter.parsePrefixOf(context, symbols.weekdays, fragment);
                if (index != -1) {
                    context.dayOfWeek = index;
                }
            }
        } else if (c == 'H') {
            context.hour = SimpleDateFormatter.parseNum(context, dateStr, 2, dateIndex);
        } else if (c == 'h') {
            context.hourAmpm = SimpleDateFormatter.parseNum(context, dateStr, 2, dateIndex);
        } else if (c == 'm') {
            context.min = SimpleDateFormatter.parseNum(context, dateStr, 2, dateIndex);
        } else if (c == 's') {
            context.sec = SimpleDateFormatter.parseNum(context, dateStr, 2, dateIndex);
        } else if (c == 'a') {
            context.ampm = SimpleDateFormatter.parseString(context, dateStr, dateIndex, symbols.ampms);
        } else if (c == 'w') {
            context.weekOfWeekYear = SimpleDateFormatter.parseNum(context, dateStr, 2, dateIndex);
        } else {
            context.invalid = true;
        }
    }

    private static int parseInt(String value) {
        int sum = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c < '0' || c > '9') {
                return -1;
            }
            sum = sum * 10 + (c - 48);
        }
        return sum;
    }

    private static int parseNum(ParserContext context, String dateStr, int nChars, int dateIndex) {
        int nToParse;
        for (int i = nToParse = Math.min(nChars, dateStr.length() - dateIndex); i > 0; --i) {
            String numStr = dateStr.substring(dateIndex, dateIndex + i);
            int value = SimpleDateFormatter.parseInt(numStr);
            if (value == -1) continue;
            context.newIndex = dateIndex + i;
            return value;
        }
        context.newIndex = -1;
        context.invalid = true;
        return -1;
    }

    private static int parseIndexOf(ParserContext context, String[] array, String value) {
        for (int i = 0; i < array.length; ++i) {
            String s = array[i];
            if (!value.equals(s)) continue;
            context.newIndex += s.length();
            return i;
        }
        context.invalid = true;
        context.newIndex = -1;
        return -1;
    }

    private static int parsePrefixOf(ParserContext context, String[] array, String value) {
        for (int i = 0; i < array.length; ++i) {
            String s = array[i];
            if (!value.startsWith(s)) continue;
            context.newIndex += s.length();
            return i;
        }
        context.invalid = true;
        context.newIndex = -1;
        return -1;
    }

    private static int parseString(ParserContext context, String dateStr, int dateIndex, String[] strings) {
        String fragment = dateStr.substring(dateIndex);
        return SimpleDateFormatter.parsePrefixOf(context, strings, fragment);
    }

    private static void parsePostProcess(DateFormatSymbols symbols, ParserContext context) {
        if (context.ambiguousYear) {
            context.year += 1900;
            Date date = SimpleDateFormatter.createDateFromContext(context);
            Date threshold = symbols.twoDigitYearStart;
            if (date.getTime() < threshold.getTime()) {
                context.year += 100;
            }
        }
        if (context.hourAmpm > 0) {
            if (context.ampm == 1) {
                context.hour = context.hourAmpm + 12;
                if (context.hour == 24) {
                    context.hour = 0;
                }
            } else {
                context.hour = context.hourAmpm;
            }
        }
    }

    private static String formatOps(DateFormatSymbols symbols, boolean yearIsWeekYear, int firstDayOfWeek, String[] ops, Date date) {
        ParserContext context = new ParserContext(firstDayOfWeek);
        context.year = SimpleDateFormatter.fullYearFromDate(date.getYear());
        context.month = date.getMonth();
        context.day = date.getDate();
        context.dayOfWeek = date.getDay();
        context.hour = date.getHours();
        context.min = date.getMinutes();
        context.sec = date.getSeconds();
        context.ampm = context.hour < 12 ? 0 : 1;
        WeekDate weekDate = SimpleDateFormatter.getWeekDate(date, firstDayOfWeek);
        context.weekYear = weekDate.getYear();
        context.weekOfWeekYear = weekDate.getWeek();
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < ops.length; ++i) {
            String op = ops[i];
            String optype = op.substring(0, 2);
            String opval = op.substring(2);
            if (optype.equals("f:")) {
                SimpleDateFormatter.formatPattern(symbols, context, opval, yearIsWeekYear, str);
                if (!context.invalid) continue;
                break;
            }
            if (optype.equals("l:")) {
                str.append(opval);
                continue;
            }
            if (!optype.equals("q:")) continue;
            str.append(opval);
        }
        if (context.invalid) {
            return null;
        }
        return str.toString();
    }

    private static void formatPattern(DateFormatSymbols symbols, ParserContext context, String patternSub, boolean yearIsWeekYear, StringBuffer out) {
        char c = patternSub.charAt(0);
        int patlen = patternSub.length();
        if (c == 'y') {
            if (!yearIsWeekYear) {
                SimpleDateFormatter.formatNum(context.year, patlen <= 3 ? 2 : 4, true, out);
            } else {
                SimpleDateFormatter.formatNum(context.weekYear, patlen <= 3 ? 2 : 4, true, out);
            }
        } else if (c == 'x') {
            SimpleDateFormatter.formatNum(context.weekYear, patlen <= 3 ? 2 : 4, true, out);
        } else if (c == 'M') {
            if (patlen == 3) {
                out.append(symbols.shortMonths[context.month]);
            } else if (patlen >= 4) {
                out.append(symbols.months[context.month]);
            } else {
                SimpleDateFormatter.formatNum(context.month + 1, patlen, false, out);
            }
        } else if (c == 'd') {
            SimpleDateFormatter.formatNum(context.day, patlen, false, out);
        } else if (c == 'E') {
            if (patlen <= 3) {
                out.append(symbols.shortWeekdays[context.dayOfWeek]);
            } else {
                out.append(symbols.weekdays[context.dayOfWeek]);
            }
        } else if (c == 'H') {
            SimpleDateFormatter.formatNum(context.hour, patlen, false, out);
        } else if (c == 'h') {
            int hour = context.hour;
            if (hour == 0) {
                hour = 12;
            } else if (hour > 12) {
                hour -= 12;
            }
            SimpleDateFormatter.formatNum(hour, patlen, false, out);
        } else if (c == 'm') {
            SimpleDateFormatter.formatNum(context.min, patlen, false, out);
        } else if (c == 's') {
            SimpleDateFormatter.formatNum(context.sec, patlen, false, out);
        } else if (c == 'a') {
            out.append(symbols.ampms[context.ampm]);
        } else if (c == 'w') {
            SimpleDateFormatter.formatNum(context.weekOfWeekYear, patlen, false, out);
        } else {
            context.invalid = true;
        }
    }

    private static void formatNum(int num, int length, boolean ensureLength, StringBuffer out) {
        String str = String.valueOf(num);
        while (str.length() < length) {
            str = "0" + str;
        }
        if (ensureLength && str.length() > length) {
            str = str.substring(str.length() - length);
        }
        out.append(str);
    }

    private static String[] analysePattern(String pattern) {
        int patternLen = pattern.length();
        int lastChar = 0;
        StringBuffer patternSub = null;
        boolean quoteMode = false;
        LinkedList<String> ops = new LinkedList<String>();
        for (int patternIndex = 0; patternIndex < patternLen; ++patternIndex) {
            char currentChar = pattern.charAt(patternIndex);
            char nextChar = patternIndex < patternLen - 1 ? pattern.charAt(patternIndex + 1) : (char)'\u0000';
            if (currentChar == '\'' && lastChar != 92) {
                if (patternSub != null) {
                    ops.add(patternSub.toString());
                    patternSub = null;
                }
                quoteMode = !quoteMode;
            } else if (quoteMode) {
                if (patternSub == null) {
                    patternSub = new StringBuffer("q:");
                }
                patternSub.append(currentChar);
            } else if (currentChar != '\\' || lastChar == 92) {
                if (patternSub == null) {
                    patternSub = Character.isLetter(currentChar) ? new StringBuffer("f:") : new StringBuffer("l:");
                }
                patternSub.append(currentChar);
                if (currentChar != nextChar) {
                    ops.add(patternSub.toString());
                    patternSub = null;
                }
            }
            lastChar = currentChar;
        }
        if (patternSub != null) {
            ops.add(patternSub.toString());
        }
        String[] data = new String[ops.size()];
        return ops.toArray(data);
    }

    private static boolean hasWeekPattern(String[] ops) {
        boolean wwPresent = false;
        boolean xxPresent = false;
        for (int i = 0; i < ops.length; ++i) {
            String s = ops[i];
            wwPresent = wwPresent || s.startsWith("f:ww");
            xxPresent = xxPresent || s.startsWith("f:xx");
        }
        return wwPresent && !xxPresent;
    }

    public SimpleDateFormatter(String pattern, DateFormatSymbols symbols, int firstDayOfWeek) {
        this.symbols = symbols == null ? new DateFormatSymbols() : symbols;
        this.ops = SimpleDateFormatter.analysePattern(pattern);
        this.yearIsWeekYear = SimpleDateFormatter.hasWeekPattern(this.ops);
        this.firstDayOfWeek = firstDayOfWeek;
    }

    public SimpleDateFormatter(String pattern, DateFormatSymbols symbols) {
        this(pattern, symbols, 1);
    }

    public void setFirstDayOfWeek(int dow) {
        this.firstDayOfWeek = dow;
    }

    public Date parse(String dateStr) {
        if (dateStr == null || dateStr.length() == 0) {
            return null;
        }
        ParserContext context = SimpleDateFormatter.parseOps(this.symbols, this.yearIsWeekYear, this.firstDayOfWeek, this.ops, dateStr);
        if (context.invalid) {
            return null;
        }
        SimpleDateFormatter.parsePostProcess(this.symbols, context);
        return SimpleDateFormatter.createDateFromContext(context);
    }

    public String format(Date date) {
        if (date instanceof java.sql.Date) {
            return SimpleDateFormatter.formatOps(this.symbols, this.yearIsWeekYear, this.firstDayOfWeek, this.ops, new Date(date.getTime()));
        }
        return SimpleDateFormatter.formatOps(this.symbols, this.yearIsWeekYear, this.firstDayOfWeek, this.ops, date);
    }

    public WeekDate getWeekDate(Date date) {
        if (date instanceof java.sql.Date) {
            return SimpleDateFormatter.getWeekDate(new Date(date.getTime()), this.firstDayOfWeek);
        }
        return SimpleDateFormatter.getWeekDate(date, this.firstDayOfWeek);
    }

    public Date getDateForWeekDate(WeekDate wdate) {
        return SimpleDateFormatter.getDateForWeekDate(wdate.getYear(), wdate.getWeek(), 1, 0, 0, 0, this.firstDayOfWeek);
    }
}

