/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import org.apache.myfaces.trinidad.change.DocumentChange;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeDocumentChange
implements DocumentChange {
    private final String _attributeName;
    private final String _attributeValueString;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(AttributeDocumentChange.class);

    public AttributeDocumentChange(String attributeName, String attributeValueString) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException(_LOG.getMessage("CANNOT_CONSTRUCT_ATTRIBUTECHANGE_WITH_NULL_NAME"));
        }
        this._attributeName = attributeName;
        this._attributeValueString = attributeValueString;
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public Object getAttributeStringValue() {
        return this._attributeValueString;
    }

    public void changeDocument(Node componentNode) {
        NamedNodeMap attributes = componentNode.getAttributes();
        if (attributes != null) {
            if (this._attributeValueString == null) {
                attributes.removeNamedItem(this._attributeName);
            } else {
                ((Element)componentNode).setAttribute(this._attributeName, this._attributeValueString);
            }
        }
    }

    public boolean getForcesDocumentReload() {
        return false;
    }
}

