/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.HierarchyUtils;
import org.apache.myfaces.trinidad.component.StampState;
import org.apache.myfaces.trinidad.component.TableUtils;
import org.apache.myfaces.trinidad.component.UIXColumn;
import org.apache.myfaces.trinidad.component.UIXTree;
import org.apache.myfaces.trinidad.event.FocusEvent;
import org.apache.myfaces.trinidad.event.RangeChangeEvent;
import org.apache.myfaces.trinidad.event.RangeChangeListener;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.util.ComponentUtils;

public class UIXTreeTable
extends UIXTree {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXTree.TYPE);
    public static final PropertyKey ROOT_NODE_RENDERED_KEY = TYPE.registerKey("rootNodeRendered", Boolean.class, Boolean.TRUE);
    public static final PropertyKey ROWS_BY_DEPTH_KEY = TYPE.registerKey("rowsByDepth", int[].class);
    public static final PropertyKey RANGE_CHANGE_LISTENER_KEY = TYPE.registerKey("rangeChangeListener", MethodBinding.class, 9);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.TreeTable";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.TreeTable";
    private Map<Object, Integer> _firstMap = Collections.emptyMap();

    public UIXTreeTable() {
        super("org.apache.myfaces.trinidad.BaseTreeTable");
    }

    public final int getRows() {
        int depth = this.getTreeModel().getDepth();
        assert (depth >= 0);
        if (depth == 0) {
            return 1;
        }
        int[] rows = this.getRowsByDepth();
        if (rows == null || rows.length == 0) {
            return 0;
        }
        return --depth >= rows.length ? rows[rows.length - 1] : rows[depth];
    }

    public final int getFirst() {
        Object container = this._getContainerPath();
        Integer first = this._firstMap.get(container);
        return first != null ? first : 0;
    }

    public void setFirst(int index) {
        Object container = this._getContainerPath();
        Map comparant = Collections.emptyMap();
        if (this._firstMap == comparant) {
            this._firstMap = new HashMap<Object, Integer>(3);
        }
        if (index <= 0) {
            this._firstMap.remove(container);
        } else {
            this._firstMap.put(container, index);
        }
    }

    public void addRangeChangeListener(RangeChangeListener listener) {
        this.addFacesListener(listener);
    }

    public void removeRangeChangeListener(RangeChangeListener listener) {
        this.removeFacesListener(listener);
    }

    public RangeChangeListener[] getRangeChangeListeners() {
        return (RangeChangeListener[])this.getFacesListeners(RangeChangeListener.class);
    }

    public Object saveState(FacesContext context) {
        Object[] array = new Object[2];
        array[0] = super.saveState(context);
        Map<Object, Integer> map = array[1] = this._firstMap.isEmpty() ? null : this._firstMap;
        if (array[0] == null && array[1] == null) {
            return null;
        }
        return array;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] array = (Object[])state;
        super.restoreState(context, array[0]);
        this._firstMap = (Map)array[1];
        if (this._firstMap == null) {
            this._firstMap = Collections.emptyMap();
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof FocusEvent) {
            this.setFocusRowKey(this.getRowKey());
            this.addAttributeChange("focusPath", this.getFocusRowKey());
            this.getDisclosedRowKeys().add();
            this.broadcastToMethodBinding(event, this.getFocusListener());
        } else if (event instanceof RangeChangeEvent) {
            RangeChangeEvent rce = (RangeChangeEvent)event;
            this.setFirst(rce.getNewStart());
            this.addAttributeChange("first", rce.getNewStart());
            this.broadcastToMethodBinding(event, this.getRangeChangeListener());
        }
        super.broadcast(event);
    }

    protected final List getStamps() {
        List children = this.getChildren();
        UIComponent nodeStamp = this.getNodeStamp();
        if (nodeStamp != null) {
            ArrayList<UIComponent> stamps = new ArrayList<UIComponent>(children.size() + 1);
            stamps.addAll(children);
            stamps.add(nodeStamp);
            return stamps;
        }
        return children;
    }

    protected final void restoreStampState(FacesContext context, UIComponent stamp, Object stampState) {
        if (stamp instanceof UIXColumn) {
            StampState.restoreChildStampState(context, stamp, this, stampState);
        } else {
            super.restoreStampState(context, stamp, stampState);
        }
    }

    protected final Object saveStampState(FacesContext context, UIComponent stamp) {
        if (stamp instanceof UIXColumn) {
            return StampState.saveChildStampState(context, stamp, this);
        }
        return super.saveStampState(context, stamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processFacetsAndChildren(FacesContext context, PhaseId phaseId) {
        TableUtils.__processFacets(context, this, this, phaseId, "nodeStamp");
        UIComponent nodeStamp = this.getNodeStamp();
        TableUtils.__processFacets(context, this, nodeStamp, phaseId, null);
        TableUtils.__processColumnFacets(context, this, this, phaseId);
        TableUtils.__processColumnFacets(context, this, nodeStamp, phaseId);
        Object oldPath = this.getRowKey();
        RowKeySet state = this.getDisclosedRowKeys();
        try {
            Object path = this.getFocusRowKey();
            this.setRowKey(path);
            if (path == null) {
                HierarchyUtils.__iterateOverTree(context, phaseId, this, state, true);
            } else {
                TableUtils.__processStampedChildren(context, this, phaseId);
                this.processComponent(context, nodeStamp, phaseId);
                if (state.isContained()) {
                    this.enterContainer();
                    HierarchyUtils.__iterateOverTree(context, phaseId, this, state, true);
                }
            }
        }
        finally {
            this.setRowKey(oldPath);
        }
    }

    private Object _getContainerPath() {
        Object parentKey = this.getTreeModel().getContainerRowKey();
        return parentKey;
    }

    Object __getMyStampState() {
        Object[] state = new Object[]{super.__getMyStampState(), this._firstMap.isEmpty() ? null : this._firstMap};
        return state;
    }

    void __setMyStampState(Object stampState) {
        Object[] state = (Object[])stampState;
        super.__setMyStampState(state[0]);
        this._firstMap = (Map)state[1];
        if (this._firstMap == null) {
            this._firstMap = Collections.emptyMap();
        }
    }

    public final boolean isRootNodeRendered() {
        return ComponentUtils.resolveBoolean(this.getProperty(ROOT_NODE_RENDERED_KEY), true);
    }

    public final void setRootNodeRendered(boolean rootNodeRendered) {
        this.setProperty(ROOT_NODE_RENDERED_KEY, rootNodeRendered ? Boolean.TRUE : Boolean.FALSE);
    }

    public final int[] getRowsByDepth() {
        return (int[])this.getProperty(ROWS_BY_DEPTH_KEY);
    }

    public final void setRowsByDepth(int[] rowsByDepth) {
        this.setProperty(ROWS_BY_DEPTH_KEY, rowsByDepth);
    }

    public final MethodBinding getRangeChangeListener() {
        return (MethodBinding)this.getProperty(RANGE_CHANGE_LISTENER_KEY);
    }

    public final void setRangeChangeListener(MethodBinding rangeChangeListener) {
        this.setProperty(RANGE_CHANGE_LISTENER_KEY, rangeChangeListener);
    }

    public String getFamily() {
        return "org.apache.myfaces.trinidad.TreeTable";
    }

    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXTreeTable(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.TreeTable", "org.apache.myfaces.trinidad.BaseTreeTable");
    }
}

