/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.io;

import java.io.IOException;
import java.io.Writer;

public class XMLEscapes {
    public static void writeAttribute(Appendable out, CharSequence text) throws IOException {
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch <= '\u007f') {
                if (ch == '>') {
                    out.append("&gt;");
                    continue;
                }
                if (ch == '<') {
                    out.append("&lt;");
                    continue;
                }
                if (ch == '\"') {
                    out.append("&quot;");
                    continue;
                }
                if (ch == '&') {
                    out.append("&amp;");
                    continue;
                }
                out.append(ch);
                continue;
            }
            XMLEscapes._writeHexRef(out, ch);
        }
    }

    public static void writeText(Writer out, char[] text) throws IOException {
        XMLEscapes.writeText(out, text, 0, text.length);
    }

    public static void writeText(Writer out, char[] text, int start, int length) throws IOException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char ch = text[i];
            if (ch <= '\u007f') {
                if (ch == '>') {
                    out.write("&gt;");
                    continue;
                }
                if (ch == '<') {
                    out.write("&lt;");
                    continue;
                }
                if (ch == '\"') {
                    out.write("&quot;");
                    continue;
                }
                if (ch == '&') {
                    out.write("&amp;");
                    continue;
                }
                out.write(ch);
                continue;
            }
            XMLEscapes._writeHexRef(out, ch);
        }
    }

    public static void writeAttribute(Writer out, char[] text) throws IOException {
        XMLEscapes.writeText(out, text);
    }

    public static void writeAttribute(Writer out, char[] text, int start, int length) throws IOException {
        XMLEscapes.writeText(out, text, start, length);
    }

    private static void _writeHexRef(Appendable out, char ch) throws IOException {
        out.append("&#x");
        out.append(Integer.toHexString(ch));
        out.append(';');
    }

    private XMLEscapes() {
    }
}

