/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.config;

import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.trinidad.context.RequestContext;

public class UIXCookie {
    private RequestContext.Accessibility _accessibilityMode;
    private TimeZone _timeZone;
    private Cookie _cookie;
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private static final String _COOKIE_KEY = "org.apache.myfaces.trinidadinternal.share.Cookie";
    private static final String _COOKIE_NAME = "oracle.uix";
    private static final int _MAXIMUM_AGE = 315360000;
    private static final String _VERSION_1 = "0";
    private static final String _CURRENT_VERSION = "0";
    private static boolean _DEFAULT_WIDE_COOKIE_SCOPE = false;

    public static UIXCookie getUIXCookie(HttpServletRequest request, HttpServletResponse response) {
        return UIXCookie.getUIXCookie(request, response, true);
    }

    public static UIXCookie getUIXCookie(HttpServletRequest request, HttpServletResponse response, boolean createIfNew) {
        if (request == null) {
            return null;
        }
        UIXCookie cookie = (UIXCookie)request.getAttribute(_COOKIE_KEY);
        if (cookie == null && response != null && (createIfNew || UIXCookie._cookieExists(request))) {
            cookie = new UIXCookie(request, response);
            request.setAttribute(_COOKIE_KEY, (Object)cookie);
        }
        return cookie;
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public void setTimeZone(TimeZone zone) {
        if (this._timeZone == null && zone != null || this._timeZone != null && !this._timeZone.equals(zone)) {
            this._timeZone = zone;
            this._updateValue();
        }
    }

    public RequestContext.Accessibility getAccessibilityMode() {
        return this._accessibilityMode;
    }

    public void setAccessibilityMode(RequestContext.Accessibility accessibilityMode) {
        if (accessibilityMode != this._accessibilityMode) {
            this._accessibilityMode = accessibilityMode;
            this._updateValue();
        }
    }

    private static boolean _cookieExists(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!_COOKIE_NAME.equals(cookies[i].getName())) continue;
                return true;
            }
        }
        return false;
    }

    private UIXCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!_COOKIE_NAME.equals(cookies[i].getName())) continue;
                this._cookie = cookies[i];
                this._decodeValues(this._cookie.getValue());
                break;
            }
        }
        this._response = response;
        this._request = request;
    }

    private Cookie _getCookie() {
        if (this._cookie == null) {
            this._cookie = new Cookie(_COOKIE_NAME, "");
        }
        return this._cookie;
    }

    private void _updateValue() {
        Cookie cookie = this._getCookie();
        String value = this._encodeValue();
        this._setCookieValue(cookie, value);
    }

    private void _setCookieValue(Cookie cookie, String value) {
        int periodIndex;
        cookie.setPath("/");
        String domain = this._request.getServerName();
        if (_DEFAULT_WIDE_COOKIE_SCOPE && domain != null && (periodIndex = domain.indexOf(".")) > 0 && domain.indexOf(".", periodIndex + 1) > 0) {
            String startOfDomain = domain.substring(0, periodIndex);
            try {
                Integer.parseInt(startOfDomain);
            }
            catch (NumberFormatException nfe) {
                domain = domain.substring(periodIndex);
            }
        }
        cookie.setDomain(domain);
        cookie.setMaxAge(315360000);
        cookie.setValue(value);
        this._response.addCookie(this._cookie);
    }

    private void _decodeValues(String value) {
        if (value == null || "".equals(value)) {
            return;
        }
        int length = value.length();
        int nextCaret = value.indexOf(94);
        if (nextCaret < 0) {
            return;
        }
        int previousCaret = nextCaret;
        String version = value.substring(0, nextCaret);
        if (version.equals("0")) {
            nextCaret = value.indexOf(94, previousCaret + 1);
            if (nextCaret < 0) {
                nextCaret = length;
            }
            this._accessibilityMode = this._decodeAccessibilityMode(value.substring(previousCaret + 1, nextCaret));
            if (nextCaret != length) {
                previousCaret = nextCaret;
                if ((nextCaret = value.indexOf(94, previousCaret + 1)) < 0) {
                    nextCaret = length;
                }
                this._timeZone = this._decodeTimeZone(value.substring(previousCaret + 1, nextCaret));
            }
        }
    }

    private String _encodeValue() {
        StringBuffer buffer = new StringBuffer(40);
        buffer.append("0");
        buffer.append('^');
        buffer.append(this._encodeAccessibilityMode());
        buffer.append('^');
        buffer.append(this._encodeTimeZone());
        return buffer.toString();
    }

    private String _encodeAccessibilityMode() {
        RequestContext.Accessibility mode = this.getAccessibilityMode();
        if (mode == null) {
            return "";
        }
        if (mode == RequestContext.Accessibility.DEFAULT) {
            return "D";
        }
        if (mode == RequestContext.Accessibility.INACCESSIBLE) {
            return "I";
        }
        if (mode == RequestContext.Accessibility.SCREEN_READER) {
            return "S";
        }
        return "";
    }

    private RequestContext.Accessibility _decodeAccessibilityMode(String value) {
        if ("".equals(value)) {
            return null;
        }
        if ("D".equals(value)) {
            return RequestContext.Accessibility.DEFAULT;
        }
        if ("I".equals(value)) {
            return RequestContext.Accessibility.INACCESSIBLE;
        }
        if ("S".equals(value)) {
            return RequestContext.Accessibility.SCREEN_READER;
        }
        return null;
    }

    private String _encodeTimeZone() {
        TimeZone zone = this.getTimeZone();
        if (zone == null) {
            return "";
        }
        String id = zone.getID();
        return id;
    }

    private TimeZone _decodeTimeZone(String value) {
        if (value == null || "".equals(value)) {
            return null;
        }
        TimeZone zone = TimeZone.getTimeZone(value);
        if (!value.equals(zone.getID())) {
            if (value.startsWith("GMT")) {
                zone.setID(value);
            } else {
                return null;
            }
        }
        return zone;
    }
}

