/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.component.visit.VisitCallback;
import org.apache.myfaces.trinidad.component.visit.VisitContext;
import org.apache.myfaces.trinidad.component.visit.VisitResult;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class PanelPartialRootRenderer
extends XhtmlRenderer {
    private static final String _PARTIAL_DIV_ID = "tr_pprBlockingDiv";
    private static final String _PARTIAL_DIV_CLICK_HANDLER = "return _pprConsumeClick(event);";
    private static final String _PARTIAL_DIV_EAT_KEY_HANDLER = "return false;";
    private static final String _PARTIAL_DIV_STYLE = "position:absolute;left:0;top:0;width:0;height:0;cursor:wait;";
    private static final VisitCallback _ENCODE_ALL_CALLBACK = new EncodeAllCallback();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PanelPartialRootRenderer.class);

    protected PanelPartialRootRenderer(FacesBean.Type type) {
        super(type);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderContent(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        boolean encodeAllChildren;
        boolean bl = encodeAllChildren = !PartialPageUtils.isOptimizedPPREnabled(context, true);
        if (encodeAllChildren) {
            this.encodeAllChildren(context, component);
        } else {
            PartialPageContext pprContext = arc.getPartialPageContext();
            VisitContext visitContext = pprContext.getVisitContext();
            try {
                UIComponent currChild;
                Iterator i$ = component.getChildren().iterator();
                while (i$.hasNext() && !UIXComponent.visitTree((VisitContext)visitContext, (UIComponent)(currChild = (UIComponent)i$.next()), (VisitCallback)_ENCODE_ALL_CALLBACK)) {
                }
            }
            catch (FacesException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw e;
            }
        }
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        XhtmlUtils.addLib(context, arc, "openWindow()");
        if (PartialPageUtils.isPartialRenderingPass(arc)) {
            PartialPageUtils.markPPRActive(context);
            try {
                this.renderContent(context, arc, component, bean);
            }
            catch (RuntimeException re) {
                _LOG.severe("ERR_PARTIAL_PAGE_RENDERING", (Throwable)re);
                throw re;
            }
            catch (Error error) {
                _LOG.severe("ERR_PARTIAL_PAGE_RENDERING", (Throwable)error);
                throw error;
            }
            this.renderAtEnd(context, arc);
        } else {
            boolean alreadyRenderedPPR = PartialPageUtils.isPPRActive(context);
            if (!alreadyRenderedPPR && !PartialPageUtils.isPartialRenderingPass(arc) && PartialPageUtils.supportsPartialRendering(arc)) {
                PartialPageUtils.markPPRActive(context);
                this.renderPPRSupport(context, arc, component, bean);
            }
            this.renderContent(context, arc, component, bean);
            this.renderAtEnd(context, arc);
        }
    }

    protected void renderAtEnd(FacesContext context, RenderingContext arc) throws IOException {
    }

    protected boolean isEmbedded() {
        return true;
    }

    protected static boolean isPartialPass(RenderingContext arc) {
        return PartialPageUtils.isPartialRenderingPass(arc);
    }

    protected void renderPPRSupport(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        PanelPartialRootRenderer._renderPartialBlocking(context, arc, component);
    }

    private static void _renderPartialBlocking(FacesContext context, RenderingContext arc, UIComponent component) throws IOException {
        if (PartialPageUtils.supportsBlocking(arc)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("div", component);
            writer.writeAttribute("id", (Object)_PARTIAL_DIV_ID, null);
            writer.writeAttribute("onclick", (Object)_PARTIAL_DIV_CLICK_HANDLER, null);
            writer.writeAttribute("style", (Object)_PARTIAL_DIV_STYLE, null);
            writer.writeAttribute("onkeydown", (Object)_PARTIAL_DIV_EAT_KEY_HANDLER, null);
            writer.writeAttribute("onkeyup", (Object)_PARTIAL_DIV_EAT_KEY_HANDLER, null);
            writer.writeAttribute("onmousedown", (Object)_PARTIAL_DIV_EAT_KEY_HANDLER, null);
            writer.writeAttribute("onmouseup", (Object)_PARTIAL_DIV_EAT_KEY_HANDLER, null);
            writer.writeAttribute("onkeypress", (Object)_PARTIAL_DIV_EAT_KEY_HANDLER, null);
            writer.endElement("div");
        }
    }

    private static final class EncodeAllCallback
    implements VisitCallback {
        private EncodeAllCallback() {
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            try {
                target.encodeAll(context.getFacesContext());
            }
            catch (IOException ioe) {
                throw new FacesException((Throwable)ioe);
            }
            PartialPageContext pprContext = RenderingContext.getCurrentInstance().getPartialPageContext();
            if (pprContext.areAllTargetsProcessed()) {
                return VisitResult.COMPLETE;
            }
            return VisitResult.REJECT;
        }
    }
}

