/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.convert.ClientConverter;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.convert.DateTimeConverter;
import org.apache.myfaces.trinidadinternal.convert.GenericConverterFactory;
import org.apache.myfaces.trinidadinternal.util.JsonUtils;

public class NumberConverter
extends org.apache.myfaces.trinidad.convert.NumberConverter
implements ClientConverter {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(NumberConverter.class);
    private static final Collection<String> _IMPORT_NAMES = Collections.singletonList("TrNumberConverter()");

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        Object number = super.getAsObject(context, component, value);
        if (number == null) {
            return null;
        }
        number = DateTimeConverter.__typeConvert(context, (Converter)this, component, value, number);
        return number;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        if (value == null) {
            return null;
        }
        GenericConverterFactory fac = GenericConverterFactory.getCurrentInstance();
        if (!(value instanceof Number) && fac.isConvertible(value, Number.class)) {
            value = fac.convert(value, Number.class);
        }
        return super.getAsString(context, component, value);
    }

    public String getClientConversion(FacesContext context, UIComponent component) {
        String hintPattern = this.getHintPattern();
        String messageDetailConvertNumber = this.getMessageDetailConvertNumber();
        String messageDetailConvertPercent = this.getMessageDetailConvertPercent();
        String messageDetailConvertCurrency = this.getMessageDetailConvertCurrency();
        HashMap<String, String> cMessages = null;
        if (hintPattern != null || messageDetailConvertNumber != null || messageDetailConvertPercent != null || messageDetailConvertCurrency != null) {
            cMessages = new HashMap<String, String>();
            cMessages.put("hintPattern", hintPattern);
            cMessages.put("number", messageDetailConvertNumber);
            cMessages.put("percent", messageDetailConvertPercent);
            cMessages.put("currency", messageDetailConvertCurrency);
        }
        return this._getTrNumberConverter(context, component, cMessages);
    }

    public Collection<String> getClientImportNames() {
        if (this._isDifferentLocale()) {
            ArrayList<String> names = new ArrayList<String>(2);
            names.add("TrNumberConverter()");
            String sloc = this.getLocale().toString();
            StringBuffer sb = new StringBuffer(11 + sloc.length());
            sb.append("LocaleInfo_");
            sb.append(sloc);
            names.add(sb.toString());
            return names;
        }
        return _IMPORT_NAMES;
    }

    public String getClientLibrarySource(FacesContext context) {
        return null;
    }

    public String getClientScript(FacesContext context, UIComponent component) {
        return null;
    }

    private Object[] _getClientConstructorParams(FacesContext context, Map<?, ?> messages) {
        boolean formating = this._formatingAttributesSet();
        Object[] params = formating ? new Object[12] : new Object[4];
        params[0] = this.getLocalizedPattern(context, this.getPattern(), null);
        params[1] = this.getType();
        params[2] = this.getLocale() != null ? this.getLocale().toString() : null;
        params[3] = messages;
        if (formating) {
            params[4] = this.isIntegerOnly();
            params[5] = this.isGroupingUsed();
            params[6] = this.getCurrencyCode();
            params[7] = this.getCurrencySymbol();
            params[8] = this.isMaximumFractionDigitsSet() ? Integer.valueOf(this.getMaxFractionDigits()) : null;
            params[9] = this.isMaximumIntegerDigitsSet() ? Integer.valueOf(this.getMaxIntegerDigits()) : null;
            params[10] = this.isMinimumFractionDigitsSet() ? Integer.valueOf(this.getMinFractionDigits()) : null;
            params[11] = this.isMinimumIntegerDigitsSet() ? Integer.valueOf(this.getMinIntegerDigits()) : null;
        }
        return params;
    }

    private boolean _formatingAttributesSet() {
        return this.getCurrencyCode() != null || this.getCurrencySymbol() != null || !this.isGroupingUsed() || this.isIntegerOnly() || this.isMaximumFractionDigitsSet() || this.isMaximumIntegerDigitsSet() || this.isMinimumFractionDigitsSet() || this.isMinimumIntegerDigitsSet();
    }

    private String _getTrNumberConverter(FacesContext context, UIComponent component, Map<?, ?> messages) {
        StringBuilder outBuffer = new StringBuilder(250);
        outBuffer.append("new TrNumberConverter(");
        Object[] params = this._getClientConstructorParams(context, messages);
        for (int i = 0; i < params.length; ++i) {
            try {
                JsonUtils.writeObject(outBuffer, params[i], false);
            }
            catch (Exception e) {
                outBuffer.append("null");
            }
            if (i >= params.length - 1) continue;
            outBuffer.append(',');
        }
        outBuffer.append(')');
        return outBuffer.toString();
    }

    private boolean _isDifferentLocale() {
        Locale converterLocale = this.getLocale();
        if (converterLocale != null) {
            Locale defaultLocale = RenderingContext.getCurrentInstance().getLocaleContext().getFormattingLocale();
            return !converterLocale.equals(defaultLocale);
        }
        return false;
    }
}

