/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.xml.parse;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.share.io.InputStreamProvider;
import org.apache.myfaces.trinidad.util.URLUtils;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.XMLUtils;
import org.apache.myfaces.trinidadinternal.style.StyleConstants;
import org.apache.myfaces.trinidadinternal.style.xml.XMLConstants;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class StyleSheetDocumentParser
extends BaseNodeParser
implements XMLConstants,
StyleConstants {
    private Vector<StyleSheetNode> _styleSheets;
    private ArrayList<StyleSheetDocument> _imports;
    private String _documentVersion;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StyleSheetDocumentParser.class);

    @Override
    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        this._documentVersion = attrs.getValue("documentVersion");
        if ("${trinidad-version}".equals(this._documentVersion)) {
            Class<StyleSheetDocumentParser> implClass = StyleSheetDocumentParser.class;
            Package implPkg = implClass.getPackage();
            this._documentVersion = implPkg != null && implPkg.getImplementationVersion() != null ? implPkg.getImplementationVersion().replace('.', '_') : "unknown-version";
        }
    }

    @Override
    public Object endElement(ParseContext context, String namespaceURI, String localName) {
        StyleSheetNode[] styleSheets = this._getStyleSheets();
        String documentVersion = this._getDocumentVersion();
        long documentTimestamp = this._getDocumentTimestamp(context);
        return new StyleSheetDocument(styleSheets, documentVersion, documentTimestamp);
    }

    @Override
    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        if (localName.equals("styleSheet")) {
            return context.getParser(StyleSheetNode.class, namespaceURI, localName);
        }
        if (localName.equals("import")) {
            String href = attrs.getValue("href");
            try {
                this._handleImport(context, href);
            }
            catch (IOException e) {
                if (_LOG.isWarning()) {
                    _LOG.warning("CANNOT_PARSE_IMPORT", (Object)href);
                }
                _LOG.warning((Throwable)e);
            }
            return this;
        }
        return null;
    }

    @Override
    public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) {
        if (child != null && localName.equals("styleSheet")) {
            if (this._styleSheets == null) {
                this._styleSheets = new Vector();
            }
            this._styleSheets.addElement((StyleSheetNode)child);
        }
    }

    private StyleSheetNode[] _getStyleSheets() {
        Object[] styleSheets = null;
        if (this._imports == null) {
            if (this._styleSheets != null) {
                styleSheets = new StyleSheetNode[this._styleSheets.size()];
                this._styleSheets.copyInto(styleSheets);
            }
        } else {
            Vector<StyleSheetNode> v = new Vector<StyleSheetNode>();
            for (StyleSheetDocument doc : this._imports) {
                Iterator<StyleSheetNode> e = doc.getStyleSheets();
                while (e.hasNext()) {
                    v.addElement(e.next());
                }
            }
            if (this._styleSheets != null) {
                for (int i = 0; i < this._styleSheets.size(); ++i) {
                    v.addElement(this._styleSheets.elementAt(i));
                }
            }
            styleSheets = new StyleSheetNode[v.size()];
            v.copyInto(styleSheets);
        }
        return styleSheets;
    }

    private void _handleImport(ParseContext context, String href) throws SAXParseException, IOException {
        if (href == null) {
            _LOG.warning("MISSING_REQUIRED_HREF");
            return;
        }
        StyleSheetDocument doc = null;
        try {
            doc = (StyleSheetDocument)XMLUtils.parseInclude(context, href, StyleSheetDocument.class);
        }
        catch (SAXException e) {
            _LOG.severe((Throwable)e);
        }
        if (doc != null) {
            if (this._imports == null) {
                this._imports = new ArrayList();
            }
            this._imports.add(doc);
        }
    }

    private String _getDocumentVersion() {
        StringBuffer buffer = new StringBuffer();
        if (this._documentVersion != null) {
            buffer.append(this._documentVersion);
        }
        if (this._imports != null) {
            for (StyleSheetDocument document : this._imports) {
                String documentVersion = document.getDocumentVersion();
                if (documentVersion == null) continue;
                buffer.append(documentVersion);
            }
        }
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    private long _getDocumentTimestamp(ParseContext context) {
        long timestamp = -1L;
        InputStreamProvider provider = XMLUtils.getInputStreamProvider(context);
        if (provider != null) {
            Object identifier = provider.getIdentifier();
            if (identifier instanceof File) {
                timestamp = ((File)identifier).lastModified();
            } else if (identifier instanceof URL) {
                try {
                    timestamp = URLUtils.getLastModified((URL)((URL)identifier));
                }
                catch (IOException io) {
                    _LOG.warning("CANNOT_GET_STYLESHEET_DOCUMENT_TIMESTAMP");
                }
            }
        }
        if (this._imports != null) {
            for (StyleSheetDocument document : this._imports) {
                long importTimestamp = document.getDocumentTimestamp();
                if (importTimestamp <= timestamp) continue;
                timestamp = importTimestamp;
            }
        }
        return timestamp;
    }
}

