/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image;

import java.util.Map;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidadinternal.image.ImageType;
import org.apache.myfaces.trinidadinternal.image.PropertyInstantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageTypeImpl
implements ImageType {
    private String _namespace;
    private String _name;
    private ArrayMap<Object, Object> _properties;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ImageTypeImpl.class);

    public ImageTypeImpl(String namespaceURI, String name, Map<Object, Object> properties) {
        this._namespace = namespaceURI;
        this._name = name;
        this._properties = new ArrayMap();
        this.setProperties(properties);
    }

    @Override
    public String getNamespaceURI() {
        return this._namespace;
    }

    @Override
    public String getLocalName() {
        return this._name;
    }

    @Override
    public synchronized Object getProperty(Object key) {
        Object renderer;
        Object value = this._properties.get(key);
        if (value instanceof PropertyInstantiator) {
            value = ((PropertyInstantiator)value).instantiate();
            assert (value != null);
            this._properties.put(key, value);
        }
        if (value == null && IMAGE_RENDERER_NAME_PROPERTY.equals(key) && (renderer = this.getProperty(IMAGE_RENDERER_PROPERTY)) != null) {
            value = renderer.getClass().getName();
        }
        return value;
    }

    @Override
    public synchronized void setProperty(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_VALUE"));
        }
        this._properties.put(key, value);
    }

    public void setProperties(Map<Object, Object> properties) {
        if (properties == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this._namespace + ", " + this._name + "]";
    }
}

