/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.FormElementRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;

public abstract class FormInputRenderer
extends FormElementRenderer {
    private static final String _CONTENT_PSEUDO_ELEMENT = "::content";
    private PropertyKey _showRequiredKey;
    private PropertyKey _simpleKey;

    protected FormInputRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._showRequiredKey = type.findKey("showRequired");
        this._simpleKey = type.findKey("simple");
    }

    protected void renderId(FacesContext context, UIComponent component) throws IOException {
        String clientId = this.getClientId(context, component);
        context.getResponseWriter().writeAttribute("id", (Object)clientId, "id");
        if (this.shouldRenderName(context, component)) {
            context.getResponseWriter().writeAttribute("name", (Object)clientId, "id");
        }
    }

    protected boolean shouldRenderName(FacesContext context, UIComponent component) {
        FacesBean bean = this.getFacesBean(component);
        return !this.getReadOnly(context, bean);
    }

    protected void renderDisabledAttribute(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        if (this.getDisabled(bean)) {
            context.getResponseWriter().writeAttribute("disabled", (Object)Boolean.TRUE, "disabled");
        }
    }

    protected void renderAllAttributes(FacesContext context, RenderingContext arc, FacesBean bean, boolean renderStyleAttrs) throws IOException {
        super.renderAllAttributes(context, arc, bean, renderStyleAttrs);
        this.renderDisabledAttribute(context, arc, bean);
        FormInputRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)this.getContentStyleClass(bean));
        FormInputRenderer.renderInlineStyleAttribute(context, arc, this.getContentStyle(bean));
    }

    protected boolean getSimple(FacesBean bean) {
        Object o = bean.getProperty(this._simpleKey);
        if (o == null) {
            o = this._simpleKey.getDefault();
        }
        return !Boolean.FALSE.equals(o);
    }

    protected void renderRootDomElementStyles(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        List<String> parsedStyleClasses;
        String styleClass = this.getStyleClass(bean);
        String contentStyleClass = this.getRootStyleClass(bean);
        String disabledStyleClass = null;
        String readOnlyStyleClass = null;
        String requiredStyleClass = null;
        if (this.getReadOnly(context, bean)) {
            readOnlyStyleClass = "p_AFReadOnly";
        } else if (this.getDisabled(bean)) {
            disabledStyleClass = "p_AFDisabled";
        }
        if (this._isConsideredRequired(bean)) {
            requiredStyleClass = "p_AFRequired";
        }
        int userStyleClassCount = (parsedStyleClasses = OutputUtils.parseStyleClassList(styleClass)) == null ? (styleClass == null ? 0 : 1) : parsedStyleClasses.size();
        String[] styleClasses = new String[userStyleClassCount + 4];
        if (parsedStyleClasses != null) {
            for (int i = 0; i < userStyleClassCount; ++i) {
                styleClasses[i] = parsedStyleClasses.get(i);
            }
        } else if (styleClass != null) {
            styleClasses[i++] = styleClass;
        }
        styleClasses[i++] = contentStyleClass;
        styleClasses[i++] = disabledStyleClass;
        styleClasses[i++] = readOnlyStyleClass;
        styleClasses[i++] = requiredStyleClass;
        FormInputRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)arc, (String[])styleClasses);
        this.renderInlineStyle(context, arc, bean);
    }

    protected String getContentStyleClass(FacesBean bean) {
        String styleClass = this.getRootStyleClass(bean);
        if (styleClass != null) {
            styleClass = styleClass + _CONTENT_PSEUDO_ELEMENT;
        }
        return styleClass;
    }

    protected abstract String getRootStyleClass(FacesBean var1);

    protected boolean getShowRequired(FacesBean bean) {
        if (this._showRequiredKey == null) {
            return false;
        }
        Object o = bean.getProperty(this._showRequiredKey);
        if (o == null) {
            o = this._showRequiredKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    private boolean _isConsideredRequired(FacesBean bean) {
        return this.getRequired(bean) || this.getShowRequired(bean);
    }
}

