/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.Scriptlet;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.XhtmlScriptletFactory;
import org.apache.myfaces.trinidadinternal.share.util.FastMessageFormat;

public class XhtmlUtils {
    public static final String CORE_LIB = "Core";
    private static Map<Object, Scriptlet> _sScriptletTable = Collections.synchronizedMap(new HashMap(37));
    private static final Object _PORTLET_LIB_TABLE_KEY = new Object();
    private static final Set<String> _NON_STRUCTURAL_COMPONENT_FAMILIES = new HashSet<String>();
    private static final TrinidadLogger _LOG;

    public static UIComponent getStructuralParent(UIComponent component) {
        do {
            if ((component = component.getParent()) != null) continue;
            return null;
        } while (_NON_STRUCTURAL_COMPONENT_FAMILIES.contains(component.getFamily()));
        return component;
    }

    public static final boolean supportsSeparateWindow(Agent agent) {
        return Boolean.TRUE.equals(agent.getCapabilities().get(TrinidadAgent.CAP_MULTIPLE_WINDOWS)) && Boolean.TRUE.equals(agent.getCapabilities().get(TrinidadAgent.CAP_PARTIAL_RENDERING));
    }

    public static String getCompositeId(String baseid, String suffix) {
        int length = baseid.length() + "__xc_".length();
        if (suffix != null) {
            length += suffix.length();
        }
        StringBuilder compID = new StringBuilder(length);
        compID.append(baseid);
        compID.append("__xc_");
        if (suffix != null) {
            compID.append(suffix);
        }
        return compID.toString();
    }

    public static void registerScriptlet(Object key, Scriptlet scriptlet) {
        _sScriptletTable.put(key, scriptlet);
    }

    public static void addLib(FacesContext context, RenderingContext arc, Object libKey) throws IOException {
        if (XhtmlRenderer.supportsScripting(arc) && libKey != null) {
            Scriptlet scriptlet = _sScriptletTable.get(libKey);
            if (scriptlet == null) {
                if (_LOG.isWarning()) {
                    _LOG.warning("CANNOT_FIND_SCRIPTLET", libKey);
                }
            } else {
                scriptlet.outputScriptlet(context, arc);
            }
        }
    }

    public static void writeLibImport(FacesContext context, RenderingContext rc, Object libURL) throws IOException {
        Map props = rc.getProperties();
        if (props.containsKey(libURL)) {
            return;
        }
        props.put(libURL, Boolean.TRUE);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", null);
        XhtmlRenderer.renderScriptDeferAttribute(context, rc);
        XhtmlRenderer.renderScriptTypeAttribute(context, rc);
        libURL = context.getExternalContext().encodeResourceURL(libURL.toString());
        if ("portlet".equals(rc.getOutputMode())) {
            if (rc.getProperties().get(_PORTLET_LIB_TABLE_KEY) == null) {
                rc.getProperties().put(_PORTLET_LIB_TABLE_KEY, Boolean.TRUE);
                writer.writeText((Object)"var _uixJSL;if(!_uixJSL)_uixJSL={};function _addJSL(u){if(!_uixJSL[u]){_uixJSL[u]=1;document.write(\"<scrip\"+\"t src=\\\"\"+u+\"\\\"></scrip\"+\"t>\")}}", null);
            }
            writer.writeText((Object)"_addJSL(\"", null);
            writer.writeText(libURL, null);
            writer.writeText((Object)"\")", null);
        } else {
            writer.writeURIAttribute("src", libURL, null);
        }
        writer.endElement("script");
    }

    public static String getChainedJS(String evh1, String evh2, boolean shortCircuit) {
        if (evh1 == null) {
            return evh2;
        }
        if (evh2 == null) {
            return evh1;
        }
        int evh1Length = evh1.length();
        if (evh1Length == 0) {
            return evh2;
        }
        int evh2Length = evh2.length();
        if (evh2Length == 0) {
            return evh1;
        }
        StringBuilder outBuilder = new StringBuilder(15 + evh1Length * 2 + 3 + evh2Length * 2 + 18);
        outBuilder.append("return _chain('");
        XhtmlUtils._escapeSingleQuotes(outBuilder, evh1);
        outBuilder.append("','");
        XhtmlUtils._escapeSingleQuotes(outBuilder, evh2);
        RenderingContext arc = RenderingContext.getCurrentInstance();
        boolean isDesktop = arc.getAgent().getType().equals(Agent.TYPE_DESKTOP);
        if (isDesktop) {
            if (shortCircuit) {
                outBuilder.append("',this,event,true)");
            } else {
                outBuilder.append("',this,event)");
            }
        } else if (shortCircuit) {
            outBuilder.append("',this,null,true)");
        } else {
            outBuilder.append("',this,null)");
        }
        return outBuilder.toString();
    }

    public static String escapeJS(String inString) {
        return XhtmlUtils.escapeJS(inString, false);
    }

    public static String escapeJS(String inString, boolean inQuotes) {
        int charCount = inString.length();
        StringBuilder outBuilder = new StringBuilder(charCount * 2);
        XhtmlUtils.escapeJS(outBuilder, inString, inQuotes);
        if (charCount != outBuilder.length()) {
            return outBuilder.toString();
        }
        return inString;
    }

    public static void escapeJS(StringBuilder outBuilder, String inString) {
        XhtmlUtils.escapeJS(outBuilder, inString, false);
    }

    public static void escapeJS(StringBuilder outBuilder, String inString, boolean inQuotes) {
        XhtmlUtils.escapeJS(outBuilder, inString, inQuotes, 1);
    }

    public static void escapeJS(StringBuilder outBuilder, String inString, boolean inQuotes, int escapeCount) {
        int leadSlashCount = (int)Math.pow(2.0, escapeCount) - 2;
        int charCount = inString.length();
        int prevChar = 0;
        for (int i = 0; i < charCount; ++i) {
            char currChar = inString.charAt(i);
            if (currChar == '\'') {
                if (!inQuotes || prevChar != 92) {
                    inQuotes = !inQuotes;
                }
                for (int j = 0; j < leadSlashCount; ++j) {
                    outBuilder.append('\\');
                }
                outBuilder.append('\\');
                outBuilder.append(currChar);
            } else if (inQuotes) {
                if (currChar > '\u00ff') {
                    outBuilder.append("\\u");
                    XhtmlUtils._appendHexString(outBuilder, currChar, 4);
                } else if (currChar > '\u001f' && currChar < '\u0080') {
                    if (currChar == '\\') {
                        outBuilder.append('\\');
                    }
                    outBuilder.append(currChar);
                } else {
                    outBuilder.append("\\x");
                    XhtmlUtils._appendHexString(outBuilder, currChar, 2);
                }
            } else {
                if (currChar == '\\') {
                    outBuilder.append('\\');
                }
                outBuilder.append(currChar);
            }
            prevChar = currChar;
        }
    }

    private static void _appendHexString(StringBuilder builder, int number, int minDigits) {
        String hexString = Integer.toHexString(number);
        int hexLength = hexString.length();
        int zeroPadding = minDigits - hexLength;
        if (zeroPadding > 0) {
            builder.append('0');
            while (zeroPadding > 1) {
                builder.append('0');
                --zeroPadding;
            }
        } else if (zeroPadding < 0) {
            throw new IllegalArgumentException();
        }
        builder.append(hexString);
    }

    private static void _escapeSingleQuotes(StringBuilder outBuilder, String inString) {
        int charCount = inString.length();
        int prevChar = 0;
        boolean inQuotes = false;
        for (int i = 0; i < charCount; ++i) {
            char currChar = inString.charAt(i);
            if (currChar == '\'') {
                if (!inQuotes || prevChar != 92) {
                    inQuotes = !inQuotes;
                }
                outBuilder.append('\\');
            } else if (currChar == '\\' && inQuotes) {
                outBuilder.append('\\');
            }
            outBuilder.append(currChar);
            prevChar = currChar;
        }
    }

    public static String getJSIdentifier(String clientId) {
        if (clientId == null) {
            return null;
        }
        return clientId.replace(':', '_');
    }

    public static String getFormattedString(String pattern, String[] parameters) {
        FastMessageFormat formatter = new FastMessageFormat(pattern);
        return formatter.format(parameters);
    }

    public static String getEncodedParameter(String param) {
        return param + "_parameterkey";
    }

    public static String getEncodedNameAttribute(String[] param) {
        int noOfParam = param.length;
        int bufferLen = 0;
        for (int i = 0; i < noOfParam; ++i) {
            bufferLen += param[i].length();
        }
        StringBuilder nameAttri = new StringBuilder(bufferLen += (noOfParam - 1) * "_parameterkey".length());
        for (int i = 0; i < noOfParam - 1; ++i) {
            nameAttri.append(XhtmlUtils.getEncodedParameter(param[i]));
        }
        nameAttri.append(param[noOfParam - 1]);
        return nameAttri.toString();
    }

    static {
        _NON_STRUCTURAL_COMPONENT_FAMILIES.add("org.apache.myfaces.trinidad.Iterator");
        _NON_STRUCTURAL_COMPONENT_FAMILIES.add("org.apache.myfaces.trinidad.ComponentRef");
        _NON_STRUCTURAL_COMPONENT_FAMILIES.add("org.apache.myfaces.trinidad.Subform");
        _NON_STRUCTURAL_COMPONENT_FAMILIES.add("org.apache.myfaces.trinidad.Switcher");
        XhtmlScriptletFactory.registerAllScriptlets();
        _LOG = TrinidadLogger.createTrinidadLogger(XhtmlUtils.class);
    }
}

