/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.ui.NodeUtils;
import org.apache.myfaces.trinidadinternal.ui.Renderer;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.laf.base.BaseLafUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.FormElementRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafUtils;
import org.apache.myfaces.trinidadinternal.ui.path.Path;
import org.apache.myfaces.trinidadinternal.ui.state.BaseSelection;
import org.apache.myfaces.trinidadinternal.ui.state.Selection;

@Deprecated
public abstract class OptionContainerRenderer
extends FormElementRenderer {
    private static final Object _OPTION_INFO_PROPERTY = new Object();
    private static final Object _OPTION_SELECTED_PROPERTY = new Object();
    private static final Object _AS_ELEMENT_KEY = new Object();

    @Override
    protected void renderAsNonElement(UIXRenderingContext context, UINode node) throws IOException {
        OptionContainerRenderer.pushRenderingProperty(context, _OPTION_INFO_PROPERTY, this.createOptionInfo(context, node));
        super.renderAsNonElement(context, node);
        OptionContainerRenderer.popRenderingProperty(context, _OPTION_INFO_PROPERTY);
    }

    @Override
    protected void prerender(UIXRenderingContext context, UINode node) throws IOException {
        super.prerender(context, node);
        this.addOnSubmitRequiredValidator(context, node, "org.apache.myfaces.trinidad.UIXSelectOne.REQUIRED");
        OptionInfo info = this.createOptionInfo(context, node);
        if (!Boolean.TRUE.equals(info.readOnly) && !Boolean.TRUE.equals(info.disabled)) {
            context.getFormEncoder().registerFormParameter(info.transformedName);
        }
        OptionContainerRenderer.pushRenderingProperty(context, _OPTION_INFO_PROPERTY, info);
    }

    @Override
    protected void postrender(UIXRenderingContext context, UINode node) throws IOException {
        OptionContainerRenderer.popRenderingProperty(context, _OPTION_INFO_PROPERTY);
        super.postrender(context, node);
    }

    @Override
    protected void renderEventHandlers(UIXRenderingContext context, UINode node) throws IOException {
        super.renderEventHandlers(context, node);
        this.renderAttribute(context, "onchange", this.getOnChange(context, node));
    }

    protected abstract Boolean isMultipleSelection(UIXRenderingContext var1, UINode var2);

    protected Object getOnChange(UIXRenderingContext context, UINode node) throws IOException {
        return node.getAttributeValue(context, ON_CHANGE_ATTR);
    }

    protected String getSelectedValue(UIXRenderingContext context, UINode node) {
        return BaseLafUtils.getLocalTextAttribute(context, node, SELECTED_VALUE_ATTR);
    }

    protected Integer getSelectedIndex(UIXRenderingContext context, UINode node) {
        return (Integer)BaseLafUtils.getLocalAttribute(context, node, SELECTED_INDEX_ATTR);
    }

    protected Selection getSelection(UIXRenderingContext context, UINode node) {
        return (BaseSelection)BaseLafUtils.getLocalAttribute(context, node, SELECTION_ATTR);
    }

    protected OptionInfo createOptionInfo(UIXRenderingContext context, UINode node) {
        OptionInfo info = new OptionInfo();
        this.populateOptionInfo(context, node, info);
        return info;
    }

    protected final void populateOptionInfo(UIXRenderingContext context, UINode node, OptionInfo info) {
        info.name = this.getNodeName(context, node);
        info.transformedName = this.getTransformedName(context, node);
        info.multiple = this.isMultipleSelection(context, node);
        info.selectedCount = 0;
        info.styleClass = this.getStyleClass(context, node);
        info.selection = this.getSelection(context, node);
        info.selectedValue = this.getSelectedValue(context, node);
        info.selectedIndex = this.getSelectedIndex(context, node);
        info.disabled = this.getDisabled(context, node);
        info.readOnly = this.getReadOnly(context, node);
        info.renderer = this.getOptionRenderer(context);
    }

    protected OptionInfo getOptionInfo(UIXRenderingContext context) {
        return (OptionInfo)OptionContainerRenderer.getRenderingProperty(context, _OPTION_INFO_PROPERTY);
    }

    protected abstract Renderer getOptionRenderer(UIXRenderingContext var1);

    protected void renderSelectItemOptions(UIXRenderingContext context, UINode node, UIComponent component, List<SelectItem> items) throws IOException {
        Object submittedValue;
        if (items == null || items.isEmpty()) {
            return;
        }
        Converter converter = ((ValueHolder)component).getConverter();
        List<Object> selectedValues = null;
        boolean isSubmitted = false;
        if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
            if (submittedValue instanceof Object[]) {
                selectedValues = Arrays.asList((Object[])submittedValue);
            } else {
                selectedValues = new ArrayList<Object>(1);
                selectedValues.add(submittedValue);
            }
            isSubmitted = true;
        }
        if (!isSubmitted) {
            selectedValues = OptionContainerRenderer._getSelectedValues(component);
        }
        Object valuePassThruObj = component.getAttributes().get("valuePassThru");
        boolean valuePassThru = Boolean.TRUE.equals(valuePassThruObj);
        boolean renderedOne = false;
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            SelectItem item = items.get(i);
            Object valueObj = null;
            if (item != null) {
                valueObj = item.getValue();
            }
            String value = null;
            boolean isSelected = false;
            if (valueObj == null) continue;
            value = "".equals(valueObj) ? valueObj.toString() : (!valuePassThru ? String.valueOf(i) : (converter == null ? valueObj.toString() : converter.getAsString(context.getFacesContext(), component, valueObj)));
            isSelected = selectedValues != null && selectedValues.contains(isSubmitted ? value : valueObj);
            boolean result = this.renderSelectItem(context, node, component, item, value, isSelected, renderedOne, i);
            renderedOne = renderedOne || result;
        }
    }

    protected boolean renderSelectItem(UIXRenderingContext context, UINode node, UIComponent component, SelectItem item, String value, boolean isSelected, boolean renderedOne, int index) throws IOException {
        if (item == null) {
            return false;
        }
        boolean agentSupportsDisabledOptions = Boolean.TRUE.equals(OptionContainerRenderer.getAgentCapability(context, TrinidadAgent.CAP_SUPPORTS_DISABLED_OPTIONS));
        boolean isParentDisabled = Boolean.TRUE.equals(component.getAttributes().get(DISABLED_ATTR.getAttributeName()));
        if (!isParentDisabled && item.isDisabled() && !agentSupportsDisabledOptions) {
            return false;
        }
        FacesContext fContext = context.getFacesContext();
        ResponseWriter out = fContext.getResponseWriter();
        if (!this.renderAsElement(context, node)) {
            if (isSelected) {
                if (renderedOne) {
                    out.startElement("br", null);
                    out.endElement("br");
                }
                out.writeText((Object)item.getLabel(), null);
                return true;
            }
        } else {
            out.startElement("option", null);
            if (item.isDisabled()) {
                out.writeAttribute("disabled", (Object)Boolean.TRUE, null);
            }
            out.writeAttribute("value", (Object)value, null);
            if (isSelected) {
                out.writeAttribute("selected", (Object)Boolean.TRUE, null);
            }
            out.writeAttribute("title", (Object)item.getDescription(), null);
            out.writeText((Object)item.getLabel(), null);
            out.endElement("option");
        }
        return false;
    }

    static UIComponent __getUIComponent(UIXRenderingContext context, UINode node) {
        UIXRenderingContext parentContext;
        UIComponent component = node.getUIComponent();
        if (component == null && (parentContext = context.getParentContext()) != null) {
            UINode parentNode = parentContext.getAncestorNode(0);
            component = NodeUtils.getUIComponent(parentContext, parentNode);
        }
        return component;
    }

    private static List<Object> _getSelectedValues(UIComponent component) {
        Object value = ((ValueHolder)component).getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(value, i));
            }
            return list;
        }
        ArrayList<Object> list = new ArrayList<Object>(1);
        list.add(value);
        return list;
    }

    protected static class OptionInfo {
        public Renderer renderer;
        public Object name;
        public Object transformedName;
        public Boolean multiple;
        public int selectedCount;
        public Boolean disabled;
        public Boolean readOnly;
        public Object styleClass;
        public Selection selection;
        public String selectedValue;
        public Integer selectedIndex;

        protected OptionInfo() {
        }

        public OptionInfo toOptionInfo() {
            return this;
        }
    }

    @Deprecated
    protected static class OptionRenderer
    extends XhtmlLafRenderer {
        protected OptionRenderer() {
        }

        protected OptionInfo getOptionInfo(UIXRenderingContext context) {
            return (OptionInfo)OptionRenderer.getRenderingProperty(context, _OPTION_INFO_PROPERTY);
        }

        @Override
        protected void renderAttributes(UIXRenderingContext context, UINode node) throws IOException {
            super.renderAttributes(context, node);
            this._renderDisabledAttribute(context, node);
            this.renderSelectedAttribute(context, node);
            Object transName = this.getTransformedName(context, node);
            boolean readOnly = Boolean.TRUE.equals(this.getReadOnly(context, node));
            boolean disabled = Boolean.TRUE.equals(this.getDisabled(context, node));
            Object value = this.getValue(context, node);
            if (!readOnly && !disabled) {
                value = XhtmlLafUtils.getFormEncodedValue(context, transName, value);
            }
            if (!OptionRenderer.supportsScripting(context)) {
                FacesContext fContext = context.getFacesContext();
                ResponseWriter out = fContext.getResponseWriter();
                out.writeAttribute("value", value, null);
            } else {
                this.renderValue(context, node, value);
            }
        }

        protected void renderValue(UIXRenderingContext context, UINode node, Object value) throws IOException {
            this.renderAttribute(context, "value", value);
        }

        private void _renderDisabledAttribute(UIXRenderingContext context, UINode node) throws IOException {
            boolean isReadOnly = BaseLafUtils.getLocalBooleanAttribute(context, node, READ_ONLY_ATTR, false);
            boolean isDisabled = BaseLafUtils.getLocalBooleanAttribute(context, node, DISABLED_ATTR, false);
            if (isReadOnly || isDisabled) {
                ResponseWriter writer = context.getResponseWriter();
                writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
            }
        }

        protected void renderSelectedAttribute(UIXRenderingContext context, UINode node) throws IOException {
        }

        protected boolean renderAsElement(UIXRenderingContext context, UINode node) {
            Object o = context.getLocalProperty(0, _AS_ELEMENT_KEY, null);
            if (o == null) {
                boolean asElement = !Boolean.TRUE.equals(this.getReadOnly(context, node)) && (OptionRenderer.supportsDisabledFormElements(context) || !Boolean.TRUE.equals(this.getDisabled(context, node)));
                context.setLocalProperty(_AS_ELEMENT_KEY, asElement ? Boolean.TRUE : Boolean.FALSE);
                return asElement;
            }
            return Boolean.TRUE == o;
        }

        @Override
        protected Object getNodeName(UIXRenderingContext context, UINode node) {
            OptionInfo info = this.getOptionInfo(context);
            return info.name;
        }

        @Override
        protected Object getTransformedName(UIXRenderingContext context, UINode node) {
            OptionInfo info = this.getOptionInfo(context);
            return info.transformedName;
        }

        protected Boolean isMultipleSelection(UIXRenderingContext context, UINode node) {
            OptionInfo info = this.getOptionInfo(context);
            return info.multiple;
        }

        protected Boolean getDisabled(UIXRenderingContext context, UINode node) {
            OptionInfo info = this.getOptionInfo(context);
            return info.disabled;
        }

        protected Boolean getReadOnly(UIXRenderingContext context, UINode node) {
            OptionInfo info = this.getOptionInfo(context);
            return info.readOnly;
        }

        @Override
        protected Object getStyleClass(UIXRenderingContext context, UINode node) {
            OptionInfo info = this.getOptionInfo(context);
            return info.styleClass;
        }

        @Override
        protected Object getText(UIXRenderingContext context, UINode node) {
            return BaseLafUtils.getLocalTextAttribute(context, node, TEXT_ATTR);
        }

        protected Object getValue(UIXRenderingContext context, UINode node) {
            return BaseLafUtils.getLocalTextAttribute(context, node, VALUE_ATTR);
        }

        protected Boolean getSelected(UIXRenderingContext context, UINode node) {
            return (Boolean)BaseLafUtils.getLocalAttribute(context, node, SELECTED_ATTR);
        }

        protected Object getOptionValue(UIXRenderingContext context, UINode node) {
            Object value = this.getValue(context, node);
            if (value == null) {
                value = this.getText(context, node);
            }
            return value;
        }

        protected Selection getSelection(UIXRenderingContext context, UINode node) {
            OptionInfo info = this.getOptionInfo(context);
            return info.selection;
        }

        protected Number getSelectedIndex(UIXRenderingContext context, UINode node) {
            OptionInfo info = this.getOptionInfo(context);
            return info.selectedIndex;
        }

        protected String getSelectedValue(UIXRenderingContext context, UINode node) {
            OptionInfo info = this.getOptionInfo(context);
            return info.selectedValue;
        }

        protected boolean isOptionSelected(UIXRenderingContext context, UINode node) {
            Boolean isOptionSelected = (Boolean)context.getLocalProperty(0, _OPTION_SELECTED_PROPERTY, null);
            if (isOptionSelected != null) {
                return isOptionSelected;
            }
            OptionInfo info = this.getOptionInfo(context);
            if (!Boolean.TRUE.equals(info.multiple) && info.selectedCount > 0) {
                return false;
            }
            Object value = this.getOptionValue(context, node);
            String valueString = value != null ? value.toString() : null;
            int childIndex = this._getChildIndex(context);
            boolean optionSelected = false;
            if (info.selection != null) {
                optionSelected = info.selection.isSelected(context, valueString, childIndex);
            } else {
                Boolean selected = this.getSelected(context, node);
                if (selected != null) {
                    optionSelected = selected;
                } else if (info.selectedValue != null) {
                    optionSelected = info.selectedValue.equals(valueString);
                } else if (info.selectedIndex != null) {
                    optionSelected = info.selectedIndex == childIndex;
                }
            }
            context.setLocalProperty(_OPTION_SELECTED_PROPERTY, optionSelected);
            if (optionSelected) {
                ++info.selectedCount;
            }
            return optionSelected;
        }

        private int _getChildIndex(UIXRenderingContext context) {
            Path path = context.getPath();
            if (path.getElementCount() == 0) {
                UIXRenderingContext parent = context.getParentContext();
                if (parent == null) {
                    return -1;
                }
                return this._getChildIndex(parent);
            }
            return path.getElementIndex(-1);
        }
    }
}

