/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.cairo.vm.api.MemoryW;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.LPSZ;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicLong;

public class TxReader
implements Closeable,
Mutable {
    public static final long PARTITION_FLAGS_MASK = 0x7FFFF00000000000L;
    public static final long PARTITION_SIZE_MASK = -9223354444668731393L;
    protected static final long DEFAULT_PARTITION_TIMESTAMP = 0L;
    protected static final int PARTITION_COLUMN_VERSION_OFFSET = 3;
    protected static final int PARTITION_MASKED_SIZE_OFFSET = 1;
    protected static final int PARTITION_MASK_READ_ONLY_BIT_OFFSET = 62;
    protected static final int PARTITION_NAME_TX_OFFSET = 2;
    protected static final int PARTITION_TS_OFFSET = 0;
    protected final LongList attachedPartitions = new LongList();
    protected final AtomicLong structureVersion = new AtomicLong();
    private final FilesFacade ff;
    private final IntList symbolCountSnapshot = new IntList();
    protected int attachedPartitionsSize = 0;
    protected long columnVersion;
    protected long dataVersion;
    protected long fixedRowCount;
    protected long maxTimestamp;
    protected long minTimestamp;
    protected int partitionBy;
    protected long partitionTableVersion;
    protected long seqTxn;
    protected int symbolColumnCount;
    protected long transientRowCount;
    protected long truncateVersion;
    protected long txn;
    private int baseOffset;
    private PartitionBy.PartitionFloorMethod partitionFloorMethod;
    private int partitionSegmentSize;
    private MemoryMR roTxMemBase;
    private long size;
    private int symbolsSize;
    private long version;

    public TxReader(FilesFacade ff) {
        this.ff = ff;
    }

    public boolean attachedPartitionsContains(long ts) {
        return (long)this.findAttachedPartitionIndex(ts) > -1L;
    }

    @Override
    public void clear() {
        this.clearData();
        Misc.free(this.roTxMemBase);
    }

    @Override
    public void close() {
        this.roTxMemBase = Misc.free(this.roTxMemBase);
        this.clear();
    }

    public void dumpTo(MemoryW mem) {
        mem.putLong(0L, this.version);
        boolean isA = (this.version & 1L) == 0L;
        int baseOffset = TableUtils.TX_BASE_HEADER_SIZE;
        mem.putInt(isA ? 8L : 32L, baseOffset);
        mem.putInt(isA ? 12L : 36L, this.symbolsSize);
        mem.putInt(isA ? 16L : 40L, this.partitionSegmentSize);
        mem.putLong((long)baseOffset + 0L, this.txn);
        mem.putLong((long)baseOffset + 8L, this.transientRowCount);
        mem.putLong((long)baseOffset + 16L, this.fixedRowCount);
        mem.putLong((long)baseOffset + 24L, this.minTimestamp);
        mem.putLong((long)baseOffset + 32L, this.maxTimestamp);
        mem.putLong((long)baseOffset + 40L, this.structureVersion.get());
        mem.putLong((long)baseOffset + 48L, this.dataVersion);
        mem.putLong((long)baseOffset + 56L, this.partitionTableVersion);
        mem.putLong((long)baseOffset + 64L, this.columnVersion);
        mem.putLong((long)baseOffset + 72L, this.truncateVersion);
        mem.putLong((long)baseOffset + 80L, this.seqTxn);
        mem.putInt((long)baseOffset + 128L, this.symbolColumnCount);
        int symbolMapCount = this.symbolCountSnapshot.size();
        for (int i = 0; i < symbolMapCount; ++i) {
            long offset = TableUtils.getSymbolWriterIndexOffset(i);
            int symCount = this.symbolCountSnapshot.getQuick(i);
            mem.putInt((long)baseOffset + offset, symCount);
            mem.putInt((long)baseOffset + (offset += 4L), symCount);
        }
        int size = this.attachedPartitions.size();
        long partitionTableOffset = TableUtils.getPartitionTableSizeOffset(symbolMapCount);
        mem.putInt((long)baseOffset + partitionTableOffset, size * 8);
        for (int i = 0; i < size; ++i) {
            long offset = TableUtils.getPartitionTableIndexOffset(partitionTableOffset, i);
            mem.putLong((long)baseOffset + offset, this.attachedPartitions.getQuick(i));
        }
    }

    public int getBaseOffset() {
        return this.baseOffset;
    }

    public long getColumnVersion() {
        return this.columnVersion;
    }

    public long getDataVersion() {
        return this.dataVersion;
    }

    public long getFixedRowCount() {
        return this.fixedRowCount;
    }

    public long getLastPartitionTimestamp() {
        if (PartitionBy.isPartitioned(this.partitionBy)) {
            return this.getPartitionTimestampLo(this.maxTimestamp);
        }
        return 0L;
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public long getPartitionColumnVersion(int i) {
        return this.getPartitionColumnVersionByIndex(i * 4);
    }

    public long getPartitionColumnVersionByIndex(int index) {
        return this.attachedPartitions.getQuick(index + 3);
    }

    public int getPartitionCount() {
        return this.attachedPartitions.size() / 4;
    }

    public int getPartitionIndex(long ts) {
        int index = this.findAttachedPartitionIndexByLoTimestamp(this.getPartitionTimestampLo(ts));
        if (index > -1) {
            return index / 4;
        }
        return -1;
    }

    public long getPartitionNameTxn(int i) {
        return this.getPartitionNameTxnByIndex(i * 4);
    }

    public long getPartitionNameTxnByIndex(int index) {
        return this.attachedPartitions.getQuick(index + 2);
    }

    public long getPartitionNameTxnByPartitionTimestamp(long ts) {
        return this.getPartitionNameTxnByPartitionTimestamp(ts, -1L);
    }

    public long getPartitionNameTxnByPartitionTimestamp(long ts, long defaultValue) {
        int index = this.findAttachedPartitionIndex(ts);
        if (index > -1) {
            return this.attachedPartitions.getQuick(index + 2);
        }
        return defaultValue;
    }

    public long getPartitionSize(int i) {
        return this.getPartitionSizeByIndex(i * 4);
    }

    public long getPartitionSizeByIndex(int index) {
        return this.attachedPartitions.getQuick(index + 1) & 0x80000FFFFFFFFFFFL;
    }

    public long getPartitionSizeByPartitionTimestamp(long ts) {
        int index = this.findAttachedPartitionIndex(ts);
        if (index > -1) {
            return this.attachedPartitions.getQuick(index + 1) & 0x80000FFFFFFFFFFFL;
        }
        return -1L;
    }

    public long getPartitionTableVersion() {
        return this.partitionTableVersion;
    }

    public long getPartitionTimestamp(int i) {
        return this.attachedPartitions.getQuick(i * 4 + 0);
    }

    public long getRecordSize() {
        return this.size;
    }

    public long getRowCount() {
        return this.transientRowCount + this.fixedRowCount;
    }

    public long getSeqTxn() {
        return this.seqTxn;
    }

    public long getStructureVersion() {
        return this.structureVersion.get();
    }

    public int getSymbolColumnCount() {
        return this.symbolColumnCount;
    }

    public int getSymbolValueCount(int i) {
        return this.symbolCountSnapshot.get(i);
    }

    public long getTransientRowCount() {
        return this.transientRowCount;
    }

    public long getTruncateVersion() {
        return this.truncateVersion;
    }

    public long getTxn() {
        return this.txn;
    }

    public long getVersion() {
        return this.version;
    }

    public void initRO(MemoryMR txnFile, int partitionBy) {
        this.roTxMemBase = txnFile;
        this.partitionFloorMethod = PartitionBy.getPartitionFloorMethod(partitionBy);
        this.partitionBy = partitionBy;
    }

    public boolean isPartitionReadOnly(int i) {
        return this.isPartitionReadOnlyByIndex(i * 4);
    }

    public boolean isPartitionReadOnlyByPartitionTimestamp(long ts) {
        int index = this.findAttachedPartitionIndex(ts);
        if (index > -1) {
            return this.isPartitionReadOnlyByIndex(index);
        }
        return false;
    }

    public TxReader ofRO(LPSZ path, int partitionBy) {
        this.clear();
        try {
            this.openTxnFile(this.ff, path);
            this.partitionFloorMethod = PartitionBy.getPartitionFloorMethod(partitionBy);
            this.partitionBy = partitionBy;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        return this;
    }

    public boolean unsafeLoadAll() {
        if (this.unsafeLoadBaseOffset()) {
            this.txn = this.version;
            if (this.txn != this.getLong(0L)) {
                return false;
            }
            this.transientRowCount = this.getLong(8L);
            this.fixedRowCount = this.getLong(16L);
            this.minTimestamp = this.getLong(24L);
            this.maxTimestamp = this.getLong(32L);
            this.dataVersion = this.getLong(48L);
            this.structureVersion.set(this.getLong(40L));
            long prevPartitionTableVersion = this.partitionTableVersion;
            this.partitionTableVersion = this.getLong(56L);
            long prevColumnVersion = this.columnVersion;
            this.columnVersion = this.unsafeReadColumnVersion();
            this.truncateVersion = this.getLong(72L);
            this.seqTxn = this.getLong(80L);
            this.symbolColumnCount = this.symbolsSize / 8;
            this.unsafeLoadSymbolCounts(this.symbolColumnCount);
            this.unsafeLoadPartitions(prevPartitionTableVersion, prevColumnVersion, this.partitionSegmentSize);
            Unsafe.getUnsafe().loadFence();
            if (this.version == this.unsafeReadVersion()) {
                return true;
            }
        }
        this.clearData();
        return false;
    }

    public boolean unsafeLoadBaseOffset() {
        this.version = this.unsafeReadVersion();
        Unsafe.getUnsafe().loadFence();
        boolean isA = (this.version & 1L) == 0L;
        this.baseOffset = isA ? this.roTxMemBase.getInt(8L) : this.roTxMemBase.getInt(32L);
        this.symbolsSize = isA ? this.roTxMemBase.getInt(12L) : this.roTxMemBase.getInt(36L);
        this.partitionSegmentSize = isA ? this.roTxMemBase.getInt(16L) : this.roTxMemBase.getInt(40L);
        Unsafe.getUnsafe().loadFence();
        if (this.unsafeReadVersion() != this.version) {
            return false;
        }
        this.size = TableUtils.calculateTxRecordSize(this.symbolsSize, this.partitionSegmentSize);
        if (this.size + (long)this.baseOffset > this.roTxMemBase.size()) {
            this.roTxMemBase.extend(this.size + (long)this.baseOffset);
        }
        return true;
    }

    public long unsafeReadColumnVersion() {
        return this.getLong(64L);
    }

    public int unsafeReadSymbolColumnCount() {
        return this.getInt(128L);
    }

    public int unsafeReadSymbolCount(int symbolIndex) {
        return this.getInt(TableUtils.getSymbolWriterIndexOffset(symbolIndex));
    }

    public int unsafeReadSymbolTransientCount(int symbolIndex) {
        return this.getInt(TableUtils.getSymbolWriterTransientIndexOffset(symbolIndex));
    }

    public long unsafeReadVersion() {
        return this.roTxMemBase.getLong(0L);
    }

    private void clearData() {
        this.baseOffset = 0;
        this.size = 0L;
        this.partitionTableVersion = -1L;
        this.attachedPartitionsSize = -1;
        this.attachedPartitions.clear();
        this.version = -1L;
        this.txn = -1L;
        this.seqTxn = -1L;
    }

    private int getInt(long readOffset) {
        assert (readOffset + 4L <= this.size) : "offset " + readOffset + ", size " + this.size + ", txn=" + this.txn;
        return this.roTxMemBase.getInt((long)this.baseOffset + readOffset);
    }

    private long getLong(long readOffset) {
        assert (readOffset + 8L <= this.size) : "offset " + readOffset + ", size " + this.size + ", txn=" + this.txn;
        return this.roTxMemBase.getLong((long)this.baseOffset + readOffset);
    }

    private boolean isPartitionReadOnlyByIndex(int index) {
        long maskedSize = this.attachedPartitions.getQuick(index + 1);
        return (maskedSize >>> 62 & 1L) == 1L;
    }

    private void openTxnFile(FilesFacade ff, LPSZ path) {
        if (ff.exists(path)) {
            if (this.roTxMemBase == null) {
                this.roTxMemBase = Vm.getMRInstance(ff, path, ff.length(path), 0);
            } else {
                this.roTxMemBase.of(ff, path, ff.getPageSize(), ff.length(path), 0);
            }
            return;
        }
        throw CairoException.critical(ff.errno()).put("Cannot append. File does not exist: ").put(path);
    }

    private void unsafeLoadPartitions(long prevPartitionTableVersion, long prevColumnVersion, int partitionTableSize) {
        if (PartitionBy.isPartitioned(this.partitionBy)) {
            int txAttachedPartitionsSize = partitionTableSize / 8;
            if (txAttachedPartitionsSize > 0) {
                if (prevPartitionTableVersion != this.partitionTableVersion || prevColumnVersion != this.columnVersion) {
                    this.attachedPartitions.clear();
                    this.unsafeLoadPartitions0(0, txAttachedPartitionsSize);
                } else if (this.attachedPartitionsSize < txAttachedPartitionsSize) {
                    this.unsafeLoadPartitions0(Math.max(this.attachedPartitionsSize - 4, 0), txAttachedPartitionsSize);
                }
                int offset = txAttachedPartitionsSize - 4 + 1;
                long mask = this.attachedPartitions.getQuick(offset) & 0x7FFFF00000000000L;
                this.attachedPartitions.setQuick(offset, mask | this.transientRowCount & 0x80000FFFFFFFFFFFL);
                this.attachedPartitions.setPos(txAttachedPartitionsSize);
            } else {
                this.attachedPartitionsSize = 0;
                this.attachedPartitions.clear();
            }
        } else {
            this.attachedPartitions.setPos(4);
            this.initPartitionAt(0, 0L, this.transientRowCount, -1L, this.columnVersion);
        }
    }

    private void unsafeLoadPartitions0(int lo, int hi) {
        this.attachedPartitions.setPos(hi);
        long baseOffset = TableUtils.getPartitionTableSizeOffset(this.symbolColumnCount) + 4L;
        for (int i = lo; i < hi; ++i) {
            this.attachedPartitions.setQuick(i, this.getLong(baseOffset + 8L * (long)i));
        }
        this.attachedPartitionsSize = hi;
    }

    private void unsafeLoadSymbolCounts(int symbolMapCount) {
        this.symbolCountSnapshot.clear();
        for (int i = 0; i < symbolMapCount; ++i) {
            this.symbolCountSnapshot.add(this.getInt(TableUtils.getSymbolWriterIndexOffset(i)));
        }
    }

    protected int findAttachedPartitionIndex(long ts) {
        return this.findAttachedPartitionIndexByLoTimestamp(this.getPartitionTimestampLo(ts));
    }

    int findAttachedPartitionIndexByLoTimestamp(long ts) {
        return this.attachedPartitions.binarySearchBlock(TableUtils.LONGS_PER_TX_ATTACHED_PARTITION_MSB, ts, -1);
    }

    protected long getPartitionTimestampLo(long timestamp) {
        return this.partitionFloorMethod != null ? (timestamp != Long.MIN_VALUE ? this.partitionFloorMethod.floor(timestamp) : Long.MIN_VALUE) : 0L;
    }

    protected void initPartitionAt(int index, long partitionTimestampLo, long partitionSize, long partitionNameTxn, long columnVersion) {
        this.attachedPartitions.setQuick(index + 0, partitionTimestampLo);
        this.attachedPartitions.setQuick(index + 1, partitionSize & 0x80000FFFFFFFFFFFL);
        this.attachedPartitions.setQuick(index + 2, partitionNameTxn);
        this.attachedPartitions.setQuick(index + 3, columnVersion);
    }

    protected void switchRecord(int readBaseOffset, long readRecordSize) {
        this.baseOffset = readBaseOffset;
        this.size = readRecordSize;
    }

    protected long unsafeReadFixedRowCount() {
        return this.getLong(16L);
    }

    protected int unsafeReadSymbolWriterIndexOffset(int denseSymbolIndex) {
        return this.getInt(TableUtils.getSymbolWriterIndexOffset(denseSymbolIndex));
    }
}

