/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.IOURing;
import io.questdb.std.IOURingFacade;
import io.questdb.std.IOURingImpl;
import io.questdb.std.IOUringAccessor;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Os;

public class IOURingFacadeImpl
implements IOURingFacade {
    public static final IOURingFacadeImpl INSTANCE = new IOURingFacadeImpl();
    private static final boolean available;

    @Override
    public void close(long ptr) {
        IOUringAccessor.close(ptr);
    }

    @Override
    public long create(int capacity) {
        return IOUringAccessor.create(capacity);
    }

    @Override
    public int errno() {
        return Os.errno();
    }

    @Override
    public boolean isAvailable() {
        return available;
    }

    @Override
    public IOURing newInstance(int capacity) {
        return new IOURingImpl(this, capacity);
    }

    @Override
    public int submit(long ptr) {
        return IOUringAccessor.submit(ptr);
    }

    @Override
    public int submitAndWait(long ptr, int waitNr) {
        return IOUringAccessor.submitAndWait(ptr, waitNr);
    }

    static boolean isAvailableOn(String kernelVersion) {
        int minor;
        int major;
        String[] versionParts = kernelVersion.split("\\.");
        if (versionParts.length < 3) {
            return false;
        }
        try {
            major = Numbers.parseInt(versionParts[0]);
        }
        catch (NumericException e) {
            return false;
        }
        if (major < 5) {
            return false;
        }
        if (major > 5) {
            return true;
        }
        try {
            minor = Numbers.parseInt(versionParts[1]);
        }
        catch (NumericException e) {
            return false;
        }
        return minor > 11;
    }

    static {
        if (Os.type != 2 && Os.type != 4) {
            available = false;
        } else {
            String kernelVersion = IOUringAccessor.kernelVersion();
            available = IOURingFacadeImpl.isAvailableOn(kernelVersion);
        }
    }
}

