/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.engine;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.nar.NarThreadContextClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlowEngine
extends ScheduledThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(FlowEngine.class);

    public FlowEngine(int corePoolSize, String threadNamePrefix) {
        this(corePoolSize, threadNamePrefix, false);
    }

    public FlowEngine(int corePoolSize, String threadNamePrefix, boolean daemon) {
        super(corePoolSize);
        AtomicInteger threadIndex = new AtomicInteger(0);
        ThreadFactory defaultThreadFactory = this.getThreadFactory();
        this.setThreadFactory(r -> {
            Thread t = defaultThreadFactory.newThread(r);
            if (daemon) {
                t.setDaemon(true);
            }
            t.setName(threadNamePrefix + " Thread-" + threadIndex.incrementAndGet());
            return t;
        });
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        thread.setContextClassLoader((ClassLoader)NarThreadContextClassLoader.getInstance());
        super.beforeExecute(thread, runnable);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return super.schedule(this.wrap(command), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return super.scheduleAtFixedRate(this.wrap(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelay(this.wrap(command), initialDelay, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return super.schedule(this.wrap(callable), delay, unit);
    }

    private Runnable wrap(Runnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                logger.error("Uncaught Exception in Runnable task", t);
            }
        };
    }

    private <T> Callable<T> wrap(Callable<T> callable) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Throwable t) {
                logger.error("Uncaught Exception in Callable task", t);
                throw t;
            }
        };
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        block10: {
            super.afterExecute(runnable, throwable);
            if (runnable instanceof FutureTask) {
                FutureTask task = (FutureTask)runnable;
                try {
                    if (!task.isDone()) break block10;
                    if (task.isCancelled()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("A flow controller execution task '{}' has been cancelled.", (Object)runnable);
                        }
                        break block10;
                    }
                    task.get();
                    logger.debug("A Flow Controller execution task '{}' has completed.", (Object)runnable);
                }
                catch (CancellationException ce) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("A flow controller execution task '{}' has been cancelled.", (Object)runnable);
                    }
                }
                catch (InterruptedException ie) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("A flow controller execution task has been interrupted.", (Throwable)ie);
                    }
                }
                catch (ExecutionException ee) {
                    logger.error("A flow controller task execution stopped abnormally", (Throwable)ee);
                }
            } else {
                logger.debug("A flow controller execution task '{}' has finished.", (Object)runnable);
            }
        }
    }

    @Override
    protected void terminated() {
        super.terminated();
    }
}

