/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.kafka;

import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.kafka.DefaultKafkaConsumerFactoryCustomizer;
import org.springframework.boot.autoconfigure.kafka.DefaultKafkaProducerFactoryCustomizer;
import org.springframework.boot.autoconfigure.kafka.KafkaAnnotationDrivenConfiguration;
import org.springframework.boot.autoconfigure.kafka.KafkaConnectionDetails;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.autoconfigure.kafka.KafkaStreamsAnnotationDrivenConfiguration;
import org.springframework.boot.autoconfigure.kafka.PropertiesKafkaConnectionDetails;
import org.springframework.boot.autoconfigure.kafka.SslBundleSslEngineFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaAdmin;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.retrytopic.RetryTopicConfiguration;
import org.springframework.kafka.retrytopic.RetryTopicConfigurationBuilder;
import org.springframework.kafka.security.jaas.KafkaJaasLoginModuleInitializer;
import org.springframework.kafka.support.LoggingProducerListener;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.kafka.transaction.KafkaTransactionManager;
import org.springframework.retry.backoff.BackOffPolicyBuilder;
import org.springframework.retry.backoff.SleepingBackOffPolicy;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={KafkaTemplate.class})
@EnableConfigurationProperties(value={KafkaProperties.class})
@Import(value={KafkaAnnotationDrivenConfiguration.class, KafkaStreamsAnnotationDrivenConfiguration.class})
@ImportRuntimeHints(value={KafkaRuntimeHints.class})
public class KafkaAutoConfiguration {
    private final KafkaProperties properties;

    KafkaAutoConfiguration(KafkaProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={KafkaConnectionDetails.class})
    PropertiesKafkaConnectionDetails kafkaConnectionDetails(ObjectProvider<SslBundles> sslBundles) {
        return new PropertiesKafkaConnectionDetails(this.properties, (SslBundles)sslBundles.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean(value={KafkaTemplate.class})
    public KafkaTemplate<?, ?> kafkaTemplate(ProducerFactory<Object, Object> kafkaProducerFactory, ProducerListener<Object, Object> kafkaProducerListener, ObjectProvider<RecordMessageConverter> messageConverter) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        KafkaTemplate kafkaTemplate = new KafkaTemplate(kafkaProducerFactory);
        messageConverter.ifUnique(arg_0 -> ((KafkaTemplate)kafkaTemplate).setMessageConverter(arg_0));
        map.from(kafkaProducerListener).to(arg_0 -> ((KafkaTemplate)kafkaTemplate).setProducerListener(arg_0));
        map.from((Object)this.properties.getTemplate().getDefaultTopic()).to(arg_0 -> ((KafkaTemplate)kafkaTemplate).setDefaultTopic(arg_0));
        map.from((Object)this.properties.getTemplate().getTransactionIdPrefix()).to(arg_0 -> ((KafkaTemplate)kafkaTemplate).setTransactionIdPrefix(arg_0));
        map.from((Object)this.properties.getTemplate().isObservationEnabled()).to(arg_0 -> ((KafkaTemplate)kafkaTemplate).setObservationEnabled(arg_0));
        return kafkaTemplate;
    }

    @Bean
    @ConditionalOnMissingBean(value={ProducerListener.class})
    public LoggingProducerListener<Object, Object> kafkaProducerListener() {
        return new LoggingProducerListener();
    }

    @Bean
    @ConditionalOnMissingBean(value={ConsumerFactory.class})
    DefaultKafkaConsumerFactory<?, ?> kafkaConsumerFactory(KafkaConnectionDetails connectionDetails, ObjectProvider<DefaultKafkaConsumerFactoryCustomizer> customizers) {
        Map<String, Object> properties = this.properties.buildConsumerProperties();
        this.applyKafkaConnectionDetailsForConsumer(properties, connectionDetails);
        DefaultKafkaConsumerFactory factory = new DefaultKafkaConsumerFactory(properties);
        customizers.orderedStream().forEach(customizer -> customizer.customize(factory));
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean(value={ProducerFactory.class})
    DefaultKafkaProducerFactory<?, ?> kafkaProducerFactory(KafkaConnectionDetails connectionDetails, ObjectProvider<DefaultKafkaProducerFactoryCustomizer> customizers) {
        Map<String, Object> properties = this.properties.buildProducerProperties();
        this.applyKafkaConnectionDetailsForProducer(properties, connectionDetails);
        DefaultKafkaProducerFactory factory = new DefaultKafkaProducerFactory(properties);
        String transactionIdPrefix = this.properties.getProducer().getTransactionIdPrefix();
        if (transactionIdPrefix != null) {
            factory.setTransactionIdPrefix(transactionIdPrefix);
        }
        customizers.orderedStream().forEach(customizer -> customizer.customize(factory));
        return factory;
    }

    @Bean
    @ConditionalOnProperty(name={"spring.kafka.producer.transaction-id-prefix"})
    @ConditionalOnMissingBean
    public KafkaTransactionManager<?, ?> kafkaTransactionManager(ProducerFactory<?, ?> producerFactory) {
        return new KafkaTransactionManager(producerFactory);
    }

    @Bean
    @ConditionalOnBooleanProperty(value={"spring.kafka.jaas.enabled"})
    @ConditionalOnMissingBean
    public KafkaJaasLoginModuleInitializer kafkaJaasInitializer() throws IOException {
        KafkaJaasLoginModuleInitializer jaas = new KafkaJaasLoginModuleInitializer();
        KafkaProperties.Jaas jaasProperties = this.properties.getJaas();
        if (jaasProperties.getControlFlag() != null) {
            jaas.setControlFlag(jaasProperties.getControlFlag());
        }
        if (jaasProperties.getLoginModule() != null) {
            jaas.setLoginModule(jaasProperties.getLoginModule());
        }
        jaas.setOptions(jaasProperties.getOptions());
        return jaas;
    }

    @Bean
    @ConditionalOnMissingBean
    KafkaAdmin kafkaAdmin(KafkaConnectionDetails connectionDetails) {
        Map<String, Object> properties = this.properties.buildAdminProperties(null);
        this.applyKafkaConnectionDetailsForAdmin(properties, connectionDetails);
        KafkaAdmin kafkaAdmin = new KafkaAdmin(properties);
        KafkaProperties.Admin admin = this.properties.getAdmin();
        if (admin.getCloseTimeout() != null) {
            kafkaAdmin.setCloseTimeout((int)admin.getCloseTimeout().getSeconds());
        }
        if (admin.getOperationTimeout() != null) {
            kafkaAdmin.setOperationTimeout((int)admin.getOperationTimeout().getSeconds());
        }
        kafkaAdmin.setFatalIfBrokerNotAvailable(admin.isFailFast());
        kafkaAdmin.setModifyTopicConfigs(admin.isModifyTopicConfigs());
        kafkaAdmin.setAutoCreate(admin.isAutoCreate());
        return kafkaAdmin;
    }

    @Bean
    @ConditionalOnBooleanProperty(value={"spring.kafka.retry.topic.enabled"})
    @ConditionalOnSingleCandidate(value=KafkaTemplate.class)
    public RetryTopicConfiguration kafkaRetryTopicConfiguration(KafkaTemplate<?, ?> kafkaTemplate) {
        KafkaProperties.Retry.Topic retryTopic = this.properties.getRetry().getTopic();
        RetryTopicConfigurationBuilder builder = RetryTopicConfigurationBuilder.newInstance().maxAttempts(retryTopic.getAttempts()).useSingleTopicForSameIntervals().suffixTopicsWithIndexValues().doNotAutoCreateRetryTopics();
        KafkaAutoConfiguration.setBackOffPolicy(builder, retryTopic.getBackoff());
        return builder.create(kafkaTemplate);
    }

    private void applyKafkaConnectionDetailsForConsumer(Map<String, Object> properties, KafkaConnectionDetails connectionDetails) {
        KafkaConnectionDetails.Configuration consumer = connectionDetails.getConsumer();
        properties.put("bootstrap.servers", consumer.getBootstrapServers());
        KafkaAutoConfiguration.applySecurityProtocol(properties, connectionDetails.getSecurityProtocol());
        KafkaAutoConfiguration.applySslBundle(properties, consumer.getSslBundle());
    }

    private void applyKafkaConnectionDetailsForProducer(Map<String, Object> properties, KafkaConnectionDetails connectionDetails) {
        KafkaConnectionDetails.Configuration producer = connectionDetails.getProducer();
        properties.put("bootstrap.servers", producer.getBootstrapServers());
        KafkaAutoConfiguration.applySecurityProtocol(properties, producer.getSecurityProtocol());
        KafkaAutoConfiguration.applySslBundle(properties, producer.getSslBundle());
    }

    private void applyKafkaConnectionDetailsForAdmin(Map<String, Object> properties, KafkaConnectionDetails connectionDetails) {
        KafkaConnectionDetails.Configuration admin = connectionDetails.getAdmin();
        properties.put("bootstrap.servers", admin.getBootstrapServers());
        KafkaAutoConfiguration.applySecurityProtocol(properties, admin.getSecurityProtocol());
        KafkaAutoConfiguration.applySslBundle(properties, admin.getSslBundle());
    }

    private static void setBackOffPolicy(RetryTopicConfigurationBuilder builder, KafkaProperties.Retry.Topic.Backoff retryTopicBackoff) {
        long delay;
        long l = delay = retryTopicBackoff.getDelay() != null ? retryTopicBackoff.getDelay().toMillis() : 0L;
        if (delay > 0L) {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            BackOffPolicyBuilder backOffPolicy = BackOffPolicyBuilder.newBuilder();
            map.from((Object)delay).to(arg_0 -> ((BackOffPolicyBuilder)backOffPolicy).delay(arg_0));
            map.from((Object)retryTopicBackoff.getMaxDelay()).as(Duration::toMillis).to(arg_0 -> ((BackOffPolicyBuilder)backOffPolicy).maxDelay(arg_0));
            map.from((Object)retryTopicBackoff.getMultiplier()).to(arg_0 -> ((BackOffPolicyBuilder)backOffPolicy).multiplier(arg_0));
            map.from((Object)retryTopicBackoff.isRandom()).to(arg_0 -> ((BackOffPolicyBuilder)backOffPolicy).random(arg_0));
            builder.customBackoff((SleepingBackOffPolicy)backOffPolicy.build());
        } else {
            builder.noBackoff();
        }
    }

    static void applySslBundle(Map<String, Object> properties, SslBundle sslBundle) {
        if (sslBundle != null) {
            properties.put("ssl.engine.factory.class", SslBundleSslEngineFactory.class);
            properties.put(SslBundle.class.getName(), sslBundle);
        }
    }

    static void applySecurityProtocol(Map<String, Object> properties, String securityProtocol) {
        if (StringUtils.hasLength((String)securityProtocol)) {
            properties.put("security.protocol", securityProtocol);
        }
    }

    static class KafkaRuntimeHints
    implements RuntimeHintsRegistrar {
        KafkaRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.reflection().registerType(SslBundleSslEngineFactory.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS});
        }
    }
}

