/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.activity;

import io.netty.channel.ChannelHandlerContext;
import java.time.Duration;
import java.util.Map;
import org.apache.rocketmq.common.attribute.TopicMessageType;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.proxy.processor.validator.DefaultTopicMessageTypeValidator;
import org.apache.rocketmq.proxy.processor.validator.TopicMessageTypeValidator;
import org.apache.rocketmq.proxy.remoting.activity.AbstractRemotingActivity;
import org.apache.rocketmq.proxy.remoting.pipeline.RequestPipeline;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.SendMessageRequestHeader;

public class SendMessageActivity
extends AbstractRemotingActivity {
    TopicMessageTypeValidator topicMessageTypeValidator = new DefaultTopicMessageTypeValidator();

    public SendMessageActivity(RequestPipeline requestPipeline, MessagingProcessor messagingProcessor) {
        super(requestPipeline, messagingProcessor);
    }

    @Override
    protected RemotingCommand processRequest0(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context) throws Exception {
        switch (request.getCode()) {
            case 10: 
            case 310: 
            case 320: {
                return this.sendMessage(ctx, request, context);
            }
            case 36: {
                return this.consumerSendMessage(ctx, request, context);
            }
        }
        return null;
    }

    protected RemotingCommand sendMessage(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context) throws Exception {
        SendMessageRequestHeader requestHeader = SendMessageRequestHeader.parseRequestHeader((RemotingCommand)request);
        String topic = requestHeader.getTopic();
        Map property = MessageDecoder.string2messageProperties((String)requestHeader.getProperties());
        TopicMessageType messageType = TopicMessageType.parseFromMessageProperty((Map)property);
        if (ConfigurationManager.getProxyConfig().isEnableTopicMessageTypeCheck() && this.topicMessageTypeValidator != null && !NamespaceUtil.isRetryTopic((String)topic) && !NamespaceUtil.isDLQTopic((String)topic)) {
            TopicMessageType topicMessageType = this.messagingProcessor.getMetadataService().getTopicMessageType(topic);
            this.topicMessageTypeValidator.validate(topicMessageType, messageType);
        }
        if (!NamespaceUtil.isRetryTopic((String)topic) && !NamespaceUtil.isDLQTopic((String)topic) && TopicMessageType.TRANSACTION.equals((Object)messageType)) {
            this.messagingProcessor.addTransactionSubscription(context, requestHeader.getProducerGroup(), requestHeader.getTopic());
        }
        return this.request(ctx, request, context, Duration.ofSeconds(3L).toMillis());
    }

    protected RemotingCommand consumerSendMessage(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context) throws Exception {
        return this.request(ctx, request, context, Duration.ofSeconds(3L).toMillis());
    }
}

