/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.container;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.common.TieredStoreExecutor;
import org.apache.rocketmq.tieredstore.container.TieredIndexFile;
import org.apache.rocketmq.tieredstore.container.TieredMessageQueueContainer;
import org.apache.rocketmq.tieredstore.metadata.TieredMetadataStore;
import org.apache.rocketmq.tieredstore.util.TieredStoreUtil;

public class TieredContainerManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    private static volatile TieredContainerManager instance;
    private static volatile TieredIndexFile indexFile;
    private final ConcurrentMap<MessageQueue, TieredMessageQueueContainer> messageQueueContainerMap;
    private final TieredMetadataStore metadataStore;
    private final TieredMessageStoreConfig storeConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TieredContainerManager getInstance(TieredMessageStoreConfig storeConfig) {
        if (storeConfig == null) {
            return instance;
        }
        if (instance != null) return instance;
        Class<TieredContainerManager> clazz = TieredContainerManager.class;
        synchronized (TieredContainerManager.class) {
            if (instance != null) return instance;
            try {
                instance = new TieredContainerManager(storeConfig);
            }
            catch (Exception e) {
                logger.error("TieredContainerManager#getInstance: create container manager failed", (Throwable)e);
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TieredIndexFile getIndexFile(TieredMessageStoreConfig storeConfig) {
        if (storeConfig == null) {
            return indexFile;
        }
        if (indexFile != null) return indexFile;
        Class<TieredContainerManager> clazz = TieredContainerManager.class;
        synchronized (TieredContainerManager.class) {
            if (indexFile != null) return indexFile;
            try {
                indexFile = new TieredIndexFile(storeConfig);
            }
            catch (Exception e) {
                logger.error("TieredContainerManager#getIndexFile: create index file failed", (Throwable)e);
            }
            return indexFile;
        }
    }

    public TieredContainerManager(TieredMessageStoreConfig storeConfig) {
        this.storeConfig = storeConfig;
        this.metadataStore = TieredStoreUtil.getMetadataStore(storeConfig);
        this.messageQueueContainerMap = new ConcurrentHashMap<MessageQueue, TieredMessageQueueContainer>();
        TieredStoreExecutor.commonScheduledExecutor.scheduleWithFixedDelay(() -> {
            try {
                Random random = new Random();
                for (TieredMessageQueueContainer container : this.getAllMQContainer()) {
                    int delay = random.nextInt(storeConfig.getMaxCommitJitter());
                    TieredStoreExecutor.commitExecutor.schedule(() -> {
                        try {
                            container.commitCommitLog();
                        }
                        catch (Throwable e) {
                            MessageQueue mq = container.getMessageQueue();
                            logger.error("commit commitLog periodically failed: topic: {}, queue: {}", new Object[]{mq.getTopic(), mq.getQueueId(), e});
                        }
                    }, (long)delay, TimeUnit.MILLISECONDS);
                    TieredStoreExecutor.commitExecutor.schedule(() -> {
                        try {
                            container.commitConsumeQueue();
                        }
                        catch (Throwable e) {
                            MessageQueue mq = container.getMessageQueue();
                            logger.error("commit consumeQueue periodically failed: topic: {}, queue: {}", new Object[]{mq.getTopic(), mq.getQueueId(), e});
                        }
                    }, (long)delay, TimeUnit.MILLISECONDS);
                }
                TieredStoreExecutor.commitExecutor.schedule(() -> {
                    try {
                        if (indexFile != null) {
                            indexFile.commit(true);
                        }
                    }
                    catch (Throwable e) {
                        logger.error("commit indexFile periodically failed", e);
                    }
                }, 0L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                logger.error("commit container periodically failed: ", e);
            }
        }, 60L, 60L, TimeUnit.SECONDS);
        TieredStoreExecutor.commonScheduledExecutor.scheduleWithFixedDelay(() -> {
            try {
                long expiredTimeStamp = System.currentTimeMillis() - (long)storeConfig.getTieredStoreFileReservedTime() * 60L * 60L * 1000L;
                Random random = new Random();
                for (TieredMessageQueueContainer container : this.getAllMQContainer()) {
                    int delay = random.nextInt(storeConfig.getMaxCommitJitter());
                    TieredStoreExecutor.cleanExpiredFileExecutor.schedule(() -> {
                        container.getQueueLock().lock();
                        try {
                            container.cleanExpiredFile(expiredTimeStamp);
                            container.destroyExpiredFile();
                            if (container.getConsumeQueueBaseOffset() == -1L) {
                                this.destroyContainer(container.getMessageQueue());
                            }
                        }
                        finally {
                            container.getQueueLock().unlock();
                        }
                    }, (long)delay, TimeUnit.MILLISECONDS);
                }
                if (indexFile != null) {
                    indexFile.cleanExpiredFile(expiredTimeStamp);
                    indexFile.destroyExpiredFile();
                }
            }
            catch (Throwable e) {
                logger.error("clean container expired file failed: ", e);
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    public boolean load() {
        try {
            AtomicInteger maxTopicId = new AtomicInteger();
            ArrayList futureList = new ArrayList();
            this.messageQueueContainerMap.clear();
            this.metadataStore.iterateTopic(topicMetadata -> {
                maxTopicId.set(Math.max(maxTopicId.get(), topicMetadata.getTopicId()));
                Future<?> future = TieredStoreExecutor.dispatchExecutor.submit(() -> {
                    if (topicMetadata.getStatus() != 0) {
                        return;
                    }
                    try {
                        this.metadataStore.iterateQueue(topicMetadata.getTopic(), queueMetadata -> this.getOrCreateMQContainer(new MessageQueue(topicMetadata.getTopic(), this.storeConfig.getBrokerName(), queueMetadata.getQueue().getQueueId())));
                    }
                    catch (Exception e) {
                        logger.error("load mq container from metadata failed", (Throwable)e);
                    }
                });
                futureList.add(future);
            });
            for (Future future : futureList) {
                future.get();
            }
            this.metadataStore.setMaxTopicId(maxTopicId.get() + 1);
        }
        catch (Exception e) {
            logger.error("load mq container from metadata failed", (Throwable)e);
            return false;
        }
        return true;
    }

    public void cleanup() {
        this.messageQueueContainerMap.clear();
        TieredContainerManager.cleanStaticReference();
    }

    private static void cleanStaticReference() {
        instance = null;
        indexFile = null;
    }

    @Nullable
    public TieredMessageQueueContainer getOrCreateMQContainer(MessageQueue messageQueue) {
        return this.messageQueueContainerMap.computeIfAbsent(messageQueue, mq -> {
            try {
                logger.info("TieredContainerManager#getOrCreateMQContainer: try to create new container: topic: {}, queueId: {}", (Object)messageQueue.getTopic(), (Object)messageQueue.getQueueId());
                return new TieredMessageQueueContainer((MessageQueue)mq, this.storeConfig);
            }
            catch (Exception e) {
                logger.error("TieredContainerManager#getOrCreateMQContainer: create new container failed: topic: {}, queueId: {}", new Object[]{messageQueue.getTopic(), messageQueue.getQueueId(), e});
                return null;
            }
        });
    }

    @Nullable
    public TieredMessageQueueContainer getMQContainer(MessageQueue messageQueue) {
        return (TieredMessageQueueContainer)this.messageQueueContainerMap.get(messageQueue);
    }

    public ImmutableList<TieredMessageQueueContainer> getAllMQContainer() {
        return ImmutableList.copyOf(this.messageQueueContainerMap.values());
    }

    public void shutdown() {
        if (indexFile != null) {
            indexFile.commit(true);
        }
        for (TieredMessageQueueContainer container : this.getAllMQContainer()) {
            container.shutdown();
        }
    }

    public void destroy() {
        if (indexFile != null) {
            indexFile.destroy();
        }
        ImmutableList<TieredMessageQueueContainer> containerList = this.getAllMQContainer();
        this.cleanup();
        for (TieredMessageQueueContainer container : containerList) {
            container.destroy();
        }
    }

    public void destroyContainer(MessageQueue mq) {
        TieredMessageQueueContainer container = (TieredMessageQueueContainer)this.messageQueueContainerMap.remove(mq);
        if (container != null) {
            MessageQueue messageQueue = container.getMessageQueue();
            logger.info("BlobContainerManager#destroyContainer: try to destroy container: topic: {}, queueId: {}", (Object)messageQueue.getTopic(), (Object)messageQueue.getQueueId());
            container.destroy();
        }
    }
}

