/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker;

import java.util.Properties;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.store.config.MessageStoreConfig;

public class ConfigContext {
    private String configFilePath;
    private Properties properties;
    private BrokerConfig brokerConfig;
    private NettyServerConfig nettyServerConfig;
    private NettyClientConfig nettyClientConfig;
    private MessageStoreConfig messageStoreConfig;
    private AuthConfig authConfig;

    private ConfigContext(Builder builder) {
        this.configFilePath = builder.configFilePath;
        this.properties = builder.properties;
        this.brokerConfig = builder.brokerConfig;
        this.nettyServerConfig = builder.nettyServerConfig;
        this.nettyClientConfig = builder.nettyClientConfig;
        this.messageStoreConfig = builder.messageStoreConfig;
        this.authConfig = builder.authConfig;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public BrokerConfig getBrokerConfig() {
        return this.brokerConfig;
    }

    public NettyServerConfig getNettyServerConfig() {
        return this.nettyServerConfig;
    }

    public NettyClientConfig getNettyClientConfig() {
        return this.nettyClientConfig;
    }

    public MessageStoreConfig getMessageStoreConfig() {
        return this.messageStoreConfig;
    }

    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public static class Builder {
        private String configFilePath;
        private Properties properties;
        private BrokerConfig brokerConfig;
        private NettyServerConfig nettyServerConfig;
        private NettyClientConfig nettyClientConfig;
        private MessageStoreConfig messageStoreConfig;
        private AuthConfig authConfig;

        public Builder configFilePath(String configFilePath) {
            this.configFilePath = configFilePath;
            return this;
        }

        public Builder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public Builder brokerConfig(BrokerConfig brokerConfig) {
            this.brokerConfig = brokerConfig;
            return this;
        }

        public Builder nettyServerConfig(NettyServerConfig nettyServerConfig) {
            this.nettyServerConfig = nettyServerConfig;
            return this;
        }

        public Builder nettyClientConfig(NettyClientConfig nettyClientConfig) {
            this.nettyClientConfig = nettyClientConfig;
            return this;
        }

        public Builder messageStoreConfig(MessageStoreConfig messageStoreConfig) {
            this.messageStoreConfig = messageStoreConfig;
            return this;
        }

        public Builder authConfig(AuthConfig authConfig) {
            this.authConfig = authConfig;
            return this;
        }

        public ConfigContext build() {
            return new ConfigContext(this);
        }
    }
}

