/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.store.AllocateMappedFileService;
import org.apache.rocketmq.store.MappedFileQueue;
import org.apache.rocketmq.store.RunningFlags;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.logfile.MappedFile;

public class MultiPathMappedFileQueue
extends MappedFileQueue {
    private final MessageStoreConfig config;
    private final Supplier<Set<String>> fullStorePathsSupplier;

    public MultiPathMappedFileQueue(MessageStoreConfig messageStoreConfig, int mappedFileSize, AllocateMappedFileService allocateMappedFileService, Supplier<Set<String>> fullStorePathsSupplier) {
        this(messageStoreConfig, mappedFileSize, allocateMappedFileService, fullStorePathsSupplier, null);
    }

    public MultiPathMappedFileQueue(MessageStoreConfig messageStoreConfig, int mappedFileSize, AllocateMappedFileService allocateMappedFileService, Supplier<Set<String>> fullStorePathsSupplier, RunningFlags runningFlags) {
        super(messageStoreConfig.getStorePathCommitLog(), mappedFileSize, allocateMappedFileService, runningFlags, messageStoreConfig.isWriteWithoutMmap());
        this.config = messageStoreConfig;
        this.fullStorePathsSupplier = fullStorePathsSupplier;
    }

    private Set<String> getPaths() {
        String[] paths = this.config.getStorePathCommitLog().trim().split(MixAll.MULTI_PATH_SPLITTER);
        return new HashSet<String>(Arrays.asList(paths));
    }

    private Set<String> getReadonlyPaths() {
        String pathStr = this.config.getReadOnlyCommitLogStorePaths();
        if (StringUtils.isBlank((CharSequence)pathStr)) {
            return Collections.emptySet();
        }
        String[] paths = pathStr.trim().split(MixAll.MULTI_PATH_SPLITTER);
        return new HashSet<String>(Arrays.asList(paths));
    }

    @Override
    public boolean load() {
        Set<String> storePathSet = this.getPaths();
        storePathSet.addAll(this.getReadonlyPaths());
        ArrayList<File> files = new ArrayList<File>();
        for (String path : storePathSet) {
            File dir = new File(path);
            File[] ls = dir.listFiles();
            if (ls == null) continue;
            Collections.addAll(files, ls);
        }
        return this.doLoad(files);
    }

    @Override
    public MappedFile tryCreateMappedFile(long createOffset) {
        long fileIdx = createOffset / (long)this.mappedFileSize;
        Set<String> storePath = this.getPaths();
        Set<String> readonlyPathSet = this.getReadonlyPaths();
        Set fullStorePaths = this.fullStorePathsSupplier == null ? Collections.emptySet() : this.fullStorePathsSupplier.get();
        HashSet<String> availableStorePath = new HashSet<String>(storePath);
        availableStorePath.removeAll(readonlyPathSet);
        availableStorePath.removeAll(fullStorePaths);
        if (availableStorePath.isEmpty()) {
            availableStorePath = new HashSet<String>(storePath);
            availableStorePath.removeAll(readonlyPathSet);
        }
        Object[] paths = availableStorePath.toArray(new String[0]);
        Arrays.sort(paths);
        String nextFilePath = (String)paths[(int)(fileIdx % (long)paths.length)] + File.separator + UtilAll.offset2FileName((long)createOffset);
        String nextNextFilePath = (String)paths[(int)((fileIdx + 1L) % (long)paths.length)] + File.separator + UtilAll.offset2FileName((long)(createOffset + (long)this.mappedFileSize));
        return this.doCreateMappedFile(nextFilePath, nextNextFilePath);
    }

    @Override
    public void destroy() {
        for (MappedFile mf : this.mappedFiles) {
            mf.destroy(3000L);
        }
        this.mappedFiles.clear();
        this.setFlushedWhere(0L);
        Set<String> storePathSet = this.getPaths();
        storePathSet.addAll(this.getReadonlyPaths());
        for (String path : storePathSet) {
            File file = new File(path);
            if (!file.isDirectory()) continue;
            file.delete();
        }
    }
}

