/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.semantics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.abc.semantics.Nsset;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IAccessorDefinition;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IConstantDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.IInterfaceDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IParameterDefinition;
import org.apache.royale.compiler.definitions.IScopedDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.definitions.metadata.IDeprecationInfo;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.exceptions.MissingBuiltinException;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.as.codegen.Binding;
import org.apache.royale.compiler.internal.as.codegen.LexicalScope;
import org.apache.royale.compiler.internal.definitions.AmbiguousDefinition;
import org.apache.royale.compiler.internal.definitions.AppliedVectorDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.ConstantDefinition;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.GetterDefinition;
import org.apache.royale.compiler.internal.definitions.InterfaceDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.definitions.PackageDefinition;
import org.apache.royale.compiler.internal.definitions.ParameterDefinition;
import org.apache.royale.compiler.internal.definitions.ScopedDefinitionBase;
import org.apache.royale.compiler.internal.definitions.SetterDefinition;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.definitions.VariableDefinition;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.ASScopeBase;
import org.apache.royale.compiler.internal.scopes.FunctionScope;
import org.apache.royale.compiler.internal.scopes.ScopeView;
import org.apache.royale.compiler.internal.scopes.TypeScope;
import org.apache.royale.compiler.internal.tree.as.BaseDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.BaseTypedDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BlockNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.ImportNode;
import org.apache.royale.compiler.internal.tree.as.IterationFlowNode;
import org.apache.royale.compiler.internal.tree.as.LiteralNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.TypedExpressionNode;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorAtNode;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorNodeBase;
import org.apache.royale.compiler.internal.tree.as.VariableExpressionNode;
import org.apache.royale.compiler.internal.tree.as.VariableNode;
import org.apache.royale.compiler.internal.tree.as.WithNode;
import org.apache.royale.compiler.problems.AbstractDeprecatedAPIProblem;
import org.apache.royale.compiler.problems.AmbiguousReferenceProblem;
import org.apache.royale.compiler.problems.BaseClassIsFinalProblem;
import org.apache.royale.compiler.problems.CannotExtendInterfaceProblem;
import org.apache.royale.compiler.problems.CircularTypeReferenceProblem;
import org.apache.royale.compiler.problems.DeprecatedAPIProblem;
import org.apache.royale.compiler.problems.DeprecatedAPIWithMessageProblem;
import org.apache.royale.compiler.problems.DeprecatedAPIWithReplacementProblem;
import org.apache.royale.compiler.problems.DeprecatedAPIWithSinceAndReplacementProblem;
import org.apache.royale.compiler.problems.DeprecatedAPIWithSinceProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.ParameterHasNoTypeDeclarationProblem;
import org.apache.royale.compiler.problems.ReturnValueHasNoTypeDeclarationProblem;
import org.apache.royale.compiler.problems.ScopedToDefaultNamespaceProblem;
import org.apache.royale.compiler.problems.UnknownSuperclassProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.scopes.IDefinitionSet;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.ICommonClassNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IDynamicAccessNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFileNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IImportNode;
import org.apache.royale.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceDecorationNode;
import org.apache.royale.compiler.tree.as.INumericLiteralNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.as.ITryNode;
import org.apache.royale.compiler.tree.as.IUnaryOperatorNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.tree.mxml.IMXMLEventSpecifierNode;

public class SemanticUtils {
    private final ICompilerProject project;
    public static final boolean ASSERT_ON_UNKNOWN_INODE = false;
    public static final boolean ALLOW_UNKNOWN_INODE = true;

    public SemanticUtils(ICompilerProject project) {
        this.project = project;
    }

    public static int isSuperThisForFieldAccess(IASNode n) {
        if (n.getParent() instanceof FunctionCallNode) {
            return Integer.MAX_VALUE;
        }
        MemberAccessExpressionNode memberAccessNode = (MemberAccessExpressionNode)n;
        FunctionCallNode callNode = (FunctionCallNode)memberAccessNode.getLeftOperandNode();
        IdentifierNode idNode = (IdentifierNode)callNode.getArgumentsNode().getChild(0);
        if (idNode.getName().equals("this")) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private static boolean isValidTypeConversion(IDefinition expected, IDefinition actual, ICompilerProject project) {
        if (actual == null || expected == null || actual.equals(SemanticUtils.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE, project)) || expected.equals(SemanticUtils.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE, project)) || SemanticUtils.isInstanceOf(actual, expected, project) || SemanticUtils.isBuiltin(actual, IASLanguageConstants.BuiltinType.NULL, project) || SemanticUtils.isBuiltin(expected, IASLanguageConstants.BuiltinType.BOOLEAN, project) || SemanticUtils.isBuiltin(expected, IASLanguageConstants.BuiltinType.VOID, project)) {
            return true;
        }
        if (SemanticUtils.isBuiltin(expected, IASLanguageConstants.BuiltinType.STRING, project) && (SemanticUtils.isBuiltin(actual, IASLanguageConstants.BuiltinType.XML, project) || SemanticUtils.isBuiltin(actual, IASLanguageConstants.BuiltinType.XMLLIST, project))) {
            return true;
        }
        return SemanticUtils.isNumericType(expected, project) && SemanticUtils.isNumericType(actual, project);
    }

    public static boolean isValidImplicitOpAssignment(IDefinition lhsType, IDefinition rhsType, int opcode, ICompilerProject project, boolean compareNormalized) {
        boolean result = SemanticUtils.isValidTypeConversion(lhsType, rhsType, project, compareNormalized);
        if (!result) {
            switch (opcode) {
                case 160: {
                    result = SemanticUtils.isBuiltin(lhsType, IASLanguageConstants.BuiltinType.STRING, project) || SemanticUtils.isBuiltin(lhsType, IASLanguageConstants.BuiltinType.XMLLIST, project) && SemanticUtils.isBuiltin(rhsType, IASLanguageConstants.BuiltinType.XML, project);
                }
            }
        }
        return result;
    }

    private static IDefinition normalizeDefinition(IDefinition def, ICompilerProject project) {
        assert (!(def.getContainingScope() instanceof FunctionScope));
        assert (!(def.getContainingScope() instanceof ScopeView));
        assert (!(def.getContainingScope() instanceof TypeScope));
        assert (!(def instanceof ParameterDefinition));
        INamespaceReference qualifier = def.getNamespaceReference();
        if (!qualifier.isPublicOrInternalNamespace()) {
            return def;
        }
        INamespaceDefinition qualifierDef = (INamespaceDefinition)((Object)qualifier);
        IResolvedQualifiersReference refToDefinition = ReferenceFactory.resolvedQualifierQualifiedReference(project.getWorkspace(), qualifierDef, def.getBaseName());
        return refToDefinition.resolve(project);
    }

    public static boolean isValidTypeConversion(IDefinition expected, IDefinition actual, ICompilerProject project, boolean normalizeDefinitions) {
        if (SemanticUtils.isValidTypeConversion(expected, actual, project)) {
            return true;
        }
        if (!normalizeDefinitions) {
            return false;
        }
        IDefinition normalizedExpected = SemanticUtils.normalizeDefinition(expected, project);
        if (normalizedExpected == null) {
            return false;
        }
        IDefinition normalizedActual = SemanticUtils.normalizeDefinition(actual, project);
        if (normalizedActual == null) {
            return false;
        }
        if (normalizedExpected == expected && normalizedActual == actual) {
            return false;
        }
        return SemanticUtils.isValidTypeConversion(normalizedExpected, normalizedActual, project);
    }

    public static IASNode getFunctionProblemNode(IFunctionNode iNode) {
        IASNode result = iNode;
        IExpressionNode nameExpression = iNode.getNameExpressionNode();
        if (nameExpression != null) {
            result = nameExpression;
        }
        return result;
    }

    public static boolean isRefToClassBeingInited(IdentifierNode id, IDefinition def) {
        boolean refToClassBeingInited = false;
        if (def instanceof IClassDefinition) {
            ScopedDefinitionBase containingDef = null;
            for (ASScope scope = id.getASScope(); scope != null; scope = scope.getContainingScope()) {
                if (containingDef == null) {
                    containingDef = scope.getDefinition();
                }
                if (!(scope instanceof ScopeView)) continue;
                if (((ScopeView)scope).isInstanceScope()) break;
                if (!((ScopeView)scope).isStaticScope() || def != scope.getDefinition()) continue;
                refToClassBeingInited = true;
                break;
            }
        }
        return refToClassBeingInited;
    }

    public static boolean isBuiltin(IDefinition def, IASLanguageConstants.BuiltinType builtin, ICompilerProject project) {
        return def != null && def.equals(project.getBuiltinType(builtin));
    }

    public static List<IDefinition> findPotentialFunctionConflicts(ICompilerProject project, IFunctionDefinition funcDef) {
        ASScope scope = (ASScope)funcDef.getContainingScope();
        INamespaceDefinition qualifier = funcDef.getNamespaceReference().resolveNamespaceReference(project);
        Set<INamespaceDefinition> namespaceSet = Collections.singleton(qualifier);
        return scope.getPropertiesByNameForMemberAccess((CompilerProject)project, funcDef.getBaseName(), namespaceSet);
    }

    public static boolean isArgumentsReference(Binding b) {
        Name name = b.getName();
        if (name != null && "arguments".equals(name.getBaseName())) {
            IDefinition definition = b.getDefinition();
            if (definition != null) {
                return definition.isImplicit();
            }
            IASNode node = b.getNode();
            return node instanceof IdentifierNode && !((IdentifierNode)node).isMemberRef();
        }
        return false;
    }

    public boolean isBuiltin(IDefinition def, IASLanguageConstants.BuiltinType builtin) {
        return SemanticUtils.isBuiltin(def, builtin, this.project);
    }

    public static boolean isNumericType(IDefinition def, ICompilerProject project) {
        return SemanticUtils.isBuiltin(def, IASLanguageConstants.BuiltinType.INT, project) || SemanticUtils.isBuiltin(def, IASLanguageConstants.BuiltinType.UINT, project) || SemanticUtils.isBuiltin(def, IASLanguageConstants.BuiltinType.NUMBER, project);
    }

    public static boolean isNumericTypeOrBoolean(IDefinition def, ICompilerProject project) {
        return SemanticUtils.isNumericType(def, project) || SemanticUtils.isBuiltin(def, IASLanguageConstants.BuiltinType.BOOLEAN, project);
    }

    public boolean isNumericType(IDefinition def) {
        return SemanticUtils.isNumericType(def, this.project);
    }

    public static boolean isInstanceOf(IDefinition maybe_derived, IDefinition maybe_base, ICompilerProject project) {
        if (!(maybe_base instanceof ITypeDefinition)) {
            return false;
        }
        if (!(maybe_derived instanceof ITypeDefinition)) {
            return false;
        }
        ITypeDefinition derived = (ITypeDefinition)maybe_derived;
        ITypeDefinition base = (ITypeDefinition)maybe_base;
        if (derived.isInstanceOf(base, project)) {
            return true;
        }
        boolean base_is_object = SemanticUtils.isInstanceOf(base, SemanticUtils.getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT, project), project);
        if (base_is_object && derived.equals(SemanticUtils.getBuiltinType(IASLanguageConstants.BuiltinType.NULL, project))) {
            return true;
        }
        return AppliedVectorDefinition.vectorInstanceOfCheck(base, derived);
    }

    public boolean isInstanceOf(IDefinition maybe_derived, IDefinition maybe_base) {
        return SemanticUtils.isInstanceOf(maybe_derived, maybe_base, this.project);
    }

    public static IDefinition getBuiltinType(IASLanguageConstants.BuiltinType builtin, ICompilerProject project) {
        return project.getBuiltinType(builtin);
    }

    public IDefinition getBuiltinType(IASLanguageConstants.BuiltinType builtin) {
        return SemanticUtils.getBuiltinType(builtin, this.project);
    }

    public static IDefinition numberType(ICompilerProject project) {
        return SemanticUtils.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER, project);
    }

    public IDefinition numberType() {
        return SemanticUtils.numberType(this.project);
    }

    public static IDefinition resolveCorrespondingAccessor(IDefinition def, ICompilerProject project) {
        if (def instanceof GetterDefinition) {
            return ((GetterDefinition)def).resolveCorrespondingAccessor(project);
        }
        if (def instanceof SetterDefinition) {
            return ((SetterDefinition)def).resolveCorrespondingAccessor(project);
        }
        throw new IllegalArgumentException("Definition " + def + " was not a getter or setter.");
    }

    public IDefinition resolveCorrespondingAccessor(IDefinition def) {
        return SemanticUtils.resolveCorrespondingAccessor(def, this.project);
    }

    public static boolean isInWith(IASNode iNode) {
        if (iNode instanceof ExpressionNodeBase) {
            return ((ExpressionNodeBase)iNode).inWith();
        }
        return iNode.getAncestorOfType(WithNode.class) != null;
    }

    public static boolean isInFilter(IASNode iNode) {
        if (iNode instanceof ExpressionNodeBase) {
            return ((ExpressionNodeBase)iNode).inFilter();
        }
        return false;
    }

    public static boolean canNestedFunctionBeHoisted(IASNode iNode) {
        for (IASNode n = iNode.getParent(); n != null && !(n instanceof FunctionNode); n = n.getParent()) {
            if (n instanceof BlockNode) continue;
            return false;
        }
        return true;
    }

    public static boolean isMemberDefinition(IDefinition def) {
        return def != null && def.getParent() instanceof ClassDefinition;
    }

    public static boolean isPackageDefinition(IDefinition def) {
        return def != null && def.getParent() instanceof PackageDefinition;
    }

    public static boolean isMethodBinding(IDefinition def) {
        return def instanceof IFunctionDefinition && (SemanticUtils.isMemberDefinition(def) || SemanticUtils.isPackageDefinition(def));
    }

    public boolean isReadOnlyDefinition(IDefinition def) {
        boolean result = false;
        if (def instanceof GetterDefinition) {
            IDefinition otherDef = this.resolveCorrespondingAccessor(def);
            if (otherDef == null) {
                return true;
            }
            if (otherDef.getNamespaceReference().getBaseName() != def.getNamespaceReference().getBaseName()) {
                return true;
            }
        } else if (def instanceof ConstantDefinition) {
            result = true;
        }
        return result;
    }

    public static boolean definitionCanBeAnalyzed(Binding binding, ICompilerProject project) {
        ExpressionNodeBase expressionNode;
        assert (binding.getNode() != null);
        IASNode node = binding.getNode();
        if (node instanceof ExpressionNodeBase && ((expressionNode = (ExpressionNodeBase)node).inWith() || expressionNode.inFilter())) {
            return false;
        }
        if (binding.getName() != null && binding.getName().isAttributeName()) {
            return false;
        }
        return !SemanticUtils.hasDynamicBase(binding, project);
    }

    public boolean definitionCanBeAnalyzed(Binding binding) {
        return SemanticUtils.definitionCanBeAnalyzed(binding, this.project);
    }

    public boolean isWriteOnlyDefinition(IDefinition def) {
        return def instanceof SetterDefinition && this.resolveCorrespondingAccessor(def) == null;
    }

    public static boolean hasDynamicBase(Binding binding, ICompilerProject project) {
        ExpressionNodeBase base = SemanticUtils.getBaseNode(binding);
        if (base != null && base.isDynamicExpression(project)) {
            return true;
        }
        return base != null && base.getNodeID() == ASTNodeID.IdentifierID && SemanticUtils.isXMLish(base.resolveType(project), project);
    }

    public boolean hasDynamicBase(Binding binding) {
        return SemanticUtils.hasDynamicBase(binding, this.project);
    }

    public static ExpressionNodeBase getBaseNode(Binding binding) {
        if (binding.getNode() instanceof ExpressionNodeBase) {
            return ((ExpressionNodeBase)binding.getNode()).getBaseExpression();
        }
        return null;
    }

    public IDefinition getDefinition(IASNode iNode) {
        return SemanticUtils.getDefinition(iNode, this.project);
    }

    public static IDefinition getDefinition(IASNode iNode, ICompilerProject project) {
        if (iNode instanceof ExpressionNodeBase) {
            return ((ExpressionNodeBase)iNode).resolve(project);
        }
        if (iNode instanceof BaseTypedDefinitionNode) {
            return ((BaseTypedDefinitionNode)iNode).getDefinition();
        }
        if (iNode instanceof NamespaceNode) {
            return ((NamespaceNode)iNode).getDefinition();
        }
        return null;
    }

    public static IDefinition resolveType(IASNode iNode, ICompilerProject project) {
        if (iNode instanceof ExpressionNodeBase) {
            return ((ExpressionNodeBase)iNode).resolveType(project);
        }
        if (iNode instanceof BaseTypedDefinitionNode) {
            return ((BaseTypedDefinitionNode)iNode).getDefinition().resolveType(project);
        }
        return null;
    }

    public IDefinition resolveType(IASNode iNode) {
        return SemanticUtils.resolveType(iNode, this.project);
    }

    public static IDefinition resolveUnaryExprType(IASNode iNode, ICompilerProject project) {
        if (iNode instanceof UnaryOperatorNodeBase) {
            return ((UnaryOperatorNodeBase)iNode).getOperandNode().resolveType(project);
        }
        return null;
    }

    public static IDefinition resolveTypeXML(IExpressionNode iNode, ICompilerProject project) {
        IDefinition def = SemanticUtils.resolveXML(iNode, project);
        if (def == null) {
            return null;
        }
        if (def instanceof IFunctionDefinition) {
            IFunctionDefinition functionDef = (IFunctionDefinition)def;
            return functionDef.resolveReturnType(project);
        }
        return def.resolveType(project);
    }

    public static IDefinition resolveXML(IExpressionNode iNode, ICompilerProject project) {
        if (iNode.getNodeID().equals((Object)ASTNodeID.E4XFilterID)) {
            return project.getBuiltinType(IASLanguageConstants.BuiltinType.XMLLIST);
        }
        if (iNode instanceof IFunctionCallNode) {
            IFunctionCallNode functionCall = (IFunctionCallNode)iNode;
            IExpressionNode nameNode = functionCall.getNameNode();
            IMemberAccessExpressionNode memberAccess = null;
            if (nameNode instanceof IMemberAccessExpressionNode) {
                memberAccess = (IMemberAccessExpressionNode)nameNode;
                nameNode = memberAccess.getRightOperandNode();
            }
            if (nameNode instanceof IIdentifierNode) {
                IFunctionDefinition funcDef;
                IClassDefinition xmlish;
                IDefinitionSet funcDefs;
                IDefinition leftDef;
                IIdentifierNode identifierNode = (IIdentifierNode)nameNode;
                IDefinition resolvedDef = identifierNode.resolve(project);
                if (resolvedDef != null && SemanticUtils.isXMLish(resolvedDef.getParent(), project)) {
                    if (resolvedDef instanceof IFunctionDefinition && !(resolvedDef instanceof IAccessorDefinition)) {
                        resolvedDef = SemanticUtils.methodXMLishReturnType((IFunctionDefinition)resolvedDef, project);
                        return resolvedDef;
                    }
                } else {
                    resolvedDef = functionCall.resolveType(project);
                    if (resolvedDef != null && SemanticUtils.isXMLish(resolvedDef, project)) {
                        return resolvedDef;
                    }
                }
                if (memberAccess != null && (leftDef = SemanticUtils.resolveXML(memberAccess.getLeftOperandNode(), project)) != null && (funcDefs = (xmlish = (IClassDefinition)leftDef).getContainedScope().getLocalDefinitionSetByName(identifierNode.getName())) != null && funcDefs.getSize() == 1 && (resolvedDef = SemanticUtils.methodXMLishReturnType(funcDef = (IFunctionDefinition)funcDefs.getDefinition(0), project)) != null) {
                    return resolvedDef;
                }
            }
            return null;
        }
        if (iNode instanceof IIdentifierNode) {
            IIdentifierNode identifierNode = (IIdentifierNode)iNode;
            IDefinition resolvedDef = identifierNode.resolve(project);
            if (resolvedDef instanceof IVariableDefinition ? (resolvedDef = resolvedDef.resolveType(project)) != null && SemanticUtils.isXMLish(resolvedDef, project) : (resolvedDef = identifierNode.resolveType(project)) != null && SemanticUtils.isXMLish(resolvedDef, project)) {
                return resolvedDef;
            }
        } else {
            IBinaryOperatorNode binaryOperatorNode;
            if (iNode instanceof IMemberAccessExpressionNode) {
                IDefinition lhs;
                IMemberAccessExpressionNode memberAccess = (IMemberAccessExpressionNode)iNode;
                IExpressionNode nameNode = memberAccess.getRightOperandNode();
                IDefinition resolvedDef = SemanticUtils.resolveXML(nameNode, project);
                if (resolvedDef == null && (lhs = SemanticUtils.resolveXML(memberAccess.getLeftOperandNode(), project)) != null && (nameNode instanceof IUnaryOperatorNode && nameNode.getNodeID().equals((Object)ASTNodeID.Op_AtID) || nameNode instanceof IIdentifierNode)) {
                    return project.getBuiltinType(IASLanguageConstants.BuiltinType.XMLLIST);
                }
                return resolvedDef;
            }
            if (iNode instanceof IDynamicAccessNode) {
                IDefinition lhs;
                IDynamicAccessNode dynAccess = (IDynamicAccessNode)iNode;
                boolean isNumericAccess = SemanticUtils.isNumericType(dynAccess.getRightOperandNode().resolveType(project), project);
                IExpressionNode leftSideExpressioNode = dynAccess.getLeftOperandNode();
                if (!isNumericAccess && leftSideExpressioNode.getNodeID().equals((Object)ASTNodeID.Op_AtID) && dynAccess.getParent() instanceof IMemberAccessExpressionNode) {
                    IMemberAccessExpressionNode mae = (IMemberAccessExpressionNode)dynAccess.getParent();
                    leftSideExpressioNode = mae.getLeftOperandNode();
                }
                if ((lhs = SemanticUtils.resolveXML(leftSideExpressioNode, project)) != null) {
                    return isNumericAccess ? project.getBuiltinType(IASLanguageConstants.BuiltinType.XML) : project.getBuiltinType(IASLanguageConstants.BuiltinType.XMLLIST);
                }
            } else if (iNode instanceof IBinaryOperatorNode && (binaryOperatorNode = (IBinaryOperatorNode)iNode).getNodeID().equals((Object)ASTNodeID.Op_AddID) && SemanticUtils.resolveXML(binaryOperatorNode.getLeftOperandNode(), project) != null && SemanticUtils.resolveXML(binaryOperatorNode.getRightOperandNode(), project) != null) {
                return project.getBuiltinType(IASLanguageConstants.BuiltinType.XMLLIST);
            }
        }
        return null;
    }

    public static boolean isXMLish(IExpressionNode iNode, ICompilerProject project) {
        return SemanticUtils.isXMLish(SemanticUtils.resolveXML(iNode, project), project);
    }

    public static boolean isXMLish(IDefinition def, ICompilerProject project) {
        ITypeDefinition xmlDef = project.getBuiltinType(IASLanguageConstants.BuiltinType.XML);
        ITypeDefinition xmlListDef = project.getBuiltinType(IASLanguageConstants.BuiltinType.XMLLIST);
        return xmlDef != null && def == xmlDef || xmlListDef != null && def == xmlListDef;
    }

    private static IDefinition methodXMLishReturnType(IFunctionDefinition method, ICompilerProject project) {
        ITypeDefinition returnType = method.resolveReturnType(project);
        if (returnType.equals(project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE)) && project.getBuiltinType(IASLanguageConstants.BuiltinType.XML).equals(method.getParent()) && method.getBaseName().matches("parent|insertChildAfter|insertChildBefore")) {
            return project.getBuiltinType(IASLanguageConstants.BuiltinType.XML);
        }
        if (SemanticUtils.isXMLish(returnType, project)) {
            return returnType;
        }
        return null;
    }

    public static boolean isToStringFunctionCall(IExpressionNode node, ICompilerProject project) {
        IMemberAccessExpressionNode memberAccess;
        IExpressionNode rightNode;
        if (!(node instanceof IFunctionCallNode)) {
            return false;
        }
        IFunctionCallNode functionCall = (IFunctionCallNode)node;
        IExpressionNode nameExpression = functionCall.getNameNode();
        if (nameExpression instanceof IMemberAccessExpressionNode && (rightNode = (memberAccess = (IMemberAccessExpressionNode)nameExpression).getRightOperandNode()) instanceof IIdentifierNode) {
            IIdentifierNode rightIdentifier = (IIdentifierNode)rightNode;
            return rightIdentifier.getName().equals("toString");
        }
        return false;
    }

    public String getTypeOfBase(IASNode node) {
        return SemanticUtils.getTypeOfBase(node, this.project);
    }

    public static String getTypeOfBase(IASNode node, ICompilerProject project) {
        if (!(node instanceof ExpressionNodeBase)) {
            return null;
        }
        ExpressionNodeBase base = ((ExpressionNodeBase)node).getBaseExpression();
        if (base == null) {
            return null;
        }
        IDefinition def = base.resolve(project);
        if (def == null) {
            return null;
        }
        return def.getTypeAsDisplayString();
    }

    public static String getTypeOfStem(IASNode iNode, ICompilerProject project) {
        IDefinition type_def = SemanticUtils.getDefinitionOfUnderlyingType(iNode, false, project);
        return type_def != null ? type_def.getBaseName() : "?";
    }

    public String getTypeOfStem(IASNode node) {
        return SemanticUtils.getTypeOfStem(node, this.project);
    }

    public static IDefinition getDefinitionOfUnderlyingType(IASNode iNode, boolean allow_unknown_iNode, ICompilerProject project) {
        IDefinition result;
        if (iNode instanceof MemberAccessExpressionNode) {
            MemberAccessExpressionNode member_node = (MemberAccessExpressionNode)iNode;
            result = member_node.getLeftOperandNode().resolveType(project);
        } else if (iNode instanceof FunctionCallNode && ((FunctionCallNode)iNode).getNameNode() instanceof MemberAccessExpressionNode) {
            MemberAccessExpressionNode member_node = (MemberAccessExpressionNode)((FunctionCallNode)iNode).getNameNode();
            result = member_node.getLeftOperandNode().resolveType(project);
        } else if (SemanticUtils.isInInstanceFunction(iNode, project)) {
            result = SemanticUtils.getEnclosingFunctionDefinition(iNode, project).getAncestorOfType(ClassDefinition.class);
        } else if (SemanticUtils.isInStaticClassFunction(iNode, project)) {
            result = SemanticUtils.getEnclosingFunctionDefinition(iNode, project).getAncestorOfType(ClassDefinition.class);
        } else {
            assert (allow_unknown_iNode) : "Unknown iNode:" + iNode;
            result = null;
        }
        return result;
    }

    public IDefinition getDefinitionOfUnderlyingType(IASNode iNode, boolean allow_unknown_iNode) {
        return SemanticUtils.getDefinitionOfUnderlyingType(iNode, allow_unknown_iNode, this.project);
    }

    public static boolean hasUnderlyingType(IASNode iNode, ICompilerProject project) {
        return SemanticUtils.getDefinitionOfUnderlyingType(iNode, true, project) != null;
    }

    public boolean hasUnderlyingType(IASNode iNode) {
        return SemanticUtils.hasUnderlyingType(iNode, this.project);
    }

    public static boolean hasExplicitStem(IASNode iNode) {
        return iNode instanceof MemberAccessExpressionNode || iNode instanceof FunctionCallNode && ((FunctionCallNode)iNode).getNameNode() instanceof MemberAccessExpressionNode;
    }

    public static boolean hasBaseNode(Binding binding) {
        return SemanticUtils.getBaseNode(binding) != null;
    }

    public static boolean isInFunction(IASNode iNode) {
        return iNode.getAncestorOfType(FunctionNode.class) != null;
    }

    public static boolean isNestedClassProperty(IASNode iNode, VariableDefinition def) {
        if (def != null && def.getParent() instanceof IClassDefinition) {
            return def.declaredInControlFlow();
        }
        return false;
    }

    public static boolean isImplicitContainer(IASNode iNode) {
        if (iNode instanceof IContainerNode) {
            // empty if block
        }
        return false;
    }

    public static MultiDefinitionType getMultiDefinitionType(IDefinition def, ICompilerProject project) {
        if (def == null) {
            return MultiDefinitionType.NONE;
        }
        IDefinition found = SemanticUtils.findPropertyQualified(def, project);
        if (AmbiguousDefinition.isAmbiguous(found)) {
            return MultiDefinitionType.AMBIGUOUS;
        }
        if (def != found && found != null && !SemanticUtils.isGetterSetterPair(def, found, project)) {
            return found instanceof IParameterDefinition ? MultiDefinitionType.SHADOWS_PARAM : MultiDefinitionType.MULTIPLE;
        }
        return MultiDefinitionType.NONE;
    }

    public static boolean isAmbiguousReference(Binding b) {
        return AmbiguousDefinition.isAmbiguous(b.getDefinition());
    }

    public static boolean isThisKeyword(IASNode iNode) {
        return iNode instanceof ILanguageIdentifierNode && ((ILanguageIdentifierNode)((Object)iNode)).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.THIS;
    }

    public static boolean isFunctionClosure(IFunctionNode functionNode) {
        IScopedNode containingScope = functionNode.getContainingScope();
        if (containingScope == null) {
            return false;
        }
        return containingScope.getParent() instanceof IFunctionNode;
    }

    public boolean hasBaseClassDefinition(IASNode iNode) {
        return SemanticUtils.hasBaseClassDefinition(iNode, this.project);
    }

    public static boolean hasBaseClassDefinition(IASNode iNode, ICompilerProject project) {
        return SemanticUtils.getBaseClassDefinition(iNode, project) != null;
    }

    public static IDefinition getBaseClassDefinition(IASNode iNode, ICompilerProject project) {
        ASScope super_scope;
        IDefinition result = null;
        IDefinition member_def = SemanticUtils.getDefinition(iNode, project);
        if (member_def != null && (super_scope = SemanticUtils.getSuperClassScope(project, member_def)) != null) {
            result = SemanticUtils.getPropertyQualified(super_scope, SemanticUtils.getNamespaceInClassContext(member_def, project), member_def.getBaseName(), project);
        }
        return result;
    }

    public static INamespaceDefinition getNamespaceInClassContext(IDefinition def, ICompilerProject project) {
        INamespaceDefinition protectedNS;
        ClassDefinition cls;
        ClassDefinition base;
        INamespaceDefinition namespace = def.resolveNamespace(project);
        IDefinition parent = def.getParent();
        if (namespace != null && parent instanceof ClassDefinition && (base = (ClassDefinition)(cls = (ClassDefinition)parent).resolveBaseClass(project)) != null && namespace.equals(protectedNS = cls.getProtectedNamespaceReference().resolveNamespaceReference(project))) {
            namespace = base.getProtectedNamespaceReference().resolveNamespaceReference(project);
        }
        return namespace;
    }

    public static ASScope getSuperClassScope(ICompilerProject project, IDefinition member_def) {
        IASScope containingScope = member_def.getContainingScope();
        if (containingScope instanceof ScopeView) {
            return ((ScopeView)containingScope).resolveSuperScope(project);
        }
        return null;
    }

    public static IDefinition findMemberByName(IASNode iNode, String member_name, boolean match_static_to_static, ICompilerProject project) {
        ASScope starting_scope = null;
        boolean is_static_reference = false;
        if (iNode instanceof MemberAccessExpressionNode) {
            TypeDefinitionBase type = (TypeDefinitionBase)((MemberAccessExpressionNode)iNode).getLeftOperandNode().resolveType(project);
            if (type != null) {
                starting_scope = ((TypeDefinitionBase)((MemberAccessExpressionNode)iNode).getLeftOperandNode().resolveType(project)).getContainedScope();
                is_static_reference = ((MemberAccessExpressionNode)iNode).getLeftOperandNode().resolve(project) instanceof ClassDefinition;
            }
        } else if (iNode instanceof FunctionCallNode && ((FunctionCallNode)iNode).getNameNode() instanceof MemberAccessExpressionNode) {
            MemberAccessExpressionNode member_node = (MemberAccessExpressionNode)((FunctionCallNode)iNode).getNameNode();
            TypeDefinitionBase type = (TypeDefinitionBase)member_node.getLeftOperandNode().resolveType(project);
            if (type != null) {
                starting_scope = type.getContainedScope();
                is_static_reference = member_node.getLeftOperandNode().resolve(project) instanceof ClassDefinition;
            }
        } else if (SemanticUtils.isInInstanceFunction(iNode, project)) {
            starting_scope = SemanticUtils.getClassScope(iNode, project);
            is_static_reference = false;
        } else if (SemanticUtils.isInStaticClassFunction(iNode, project)) {
            starting_scope = SemanticUtils.getClassScope(iNode, project);
            is_static_reference = true;
        }
        if (starting_scope != null) {
            return SemanticUtils.findMemberByName(starting_scope, member_name, match_static_to_static, is_static_reference, project);
        }
        return null;
    }

    public static ASScope getClassScope(IASNode iNode, ICompilerProject project) {
        ClassDefinition class_def;
        if ((SemanticUtils.isInInstanceFunction(iNode, project) || SemanticUtils.isInStaticClassFunction(iNode, project)) && (class_def = (ClassDefinition)SemanticUtils.getEnclosingFunctionDefinition(iNode, project).getAncestorOfType(ClassDefinition.class)) != null) {
            return class_def.getContainedScope();
        }
        return null;
    }

    public ASScope getClassScope(IASNode iNode) {
        return SemanticUtils.getClassScope(iNode, this.project);
    }

    public static IDefinition findMemberByName(IASScope scope, String member_name, boolean match_static_to_static, boolean is_static_reference, ICompilerProject project) {
        if (scope == null) {
            return null;
        }
        IDefinition result = null;
        IDefinition possible_result = null;
        for (IDefinition def : SemanticUtils.getPropertiesByNameForMemberAccess(scope, member_name, project)) {
            if (is_static_reference) {
                if (def.isStatic()) {
                    result = def;
                    break;
                }
                if (!match_static_to_static || possible_result == null) continue;
                possible_result = def;
                continue;
            }
            if (def.isStatic()) continue;
            result = def;
            break;
        }
        return result != null ? result : possible_result;
    }

    public static boolean isInaccessible(IASNode iNode, Binding member, ICompilerProject project) {
        assert (member.getName() != null);
        return member.getDefinition() == null && SemanticUtils.findMemberByName(iNode, member.getName().getBaseName(), true, project) != null;
    }

    public boolean isInaccessible(IASNode iNode, Binding member) {
        return SemanticUtils.isInaccessible(iNode, member, this.project);
    }

    public IDefinition getBaseClassDefinition(IASNode iNode) {
        return SemanticUtils.getBaseClassDefinition(iNode, this.project);
    }

    public static IDefinition findPropertyQualified(IDefinition member_def, ICompilerProject project) {
        ASScope containingScope = (ASScope)member_def.getContainingScope();
        return SemanticUtils.findPropertyQualified(containingScope, member_def, project);
    }

    public IDefinition findPropertyQualified(IDefinition member_def) {
        return SemanticUtils.findPropertyQualified(member_def, this.project);
    }

    public static IDefinition findPropertyQualified(IScopedDefinition enclosing_def, IDefinition member_def, ICompilerProject project) {
        return SemanticUtils.findPropertyQualified((ASScope)enclosing_def.getContainedScope(), member_def, project);
    }

    public static IDefinition getPropertyQualified(IScopedDefinition enclosing_def, IDefinition member_def, ICompilerProject project) {
        return SemanticUtils.getPropertyQualified((ASScope)enclosing_def.getContainedScope(), member_def, project);
    }

    public IDefinition findPropertyQualified(IScopedDefinition enclosing_def, IDefinition member_def) {
        return SemanticUtils.findPropertyQualified(enclosing_def, member_def, this.project);
    }

    public static IDefinition findPropertyQualified(ASScope scope, IDefinition member_def, ICompilerProject project) {
        INamespaceDefinition namespace;
        IDefinition result = null;
        if (scope != null && member_def != null && member_def.getNamespaceReference() != null && (namespace = member_def.getNamespaceReference().resolveNamespaceReference(project)) != null) {
            String baseName = member_def.getBaseName();
            result = scope.findPropertyQualified(project, namespace, baseName, DependencyType.EXPRESSION);
        }
        return result;
    }

    public static IDefinition getPropertyQualified(ASScope scope, IDefinition member_def, ICompilerProject project) {
        INamespaceDefinition namespace;
        IDefinition result = null;
        if (scope != null && member_def != null && member_def.getNamespaceReference() != null && (namespace = member_def.getNamespaceReference().resolveNamespaceReference(project)) != null) {
            result = SemanticUtils.getPropertyQualified(scope, namespace, member_def.getBaseName(), project);
        }
        return result;
    }

    public static IDefinition getPropertyQualified(ASScope scope, INamespaceDefinition namespace, String baseName, ICompilerProject project) {
        IDefinition result = null;
        if (scope != null && namespace != null && baseName != null) {
            result = scope.getPropertyByNameForMemberAccess((CompilerProject)project, baseName, Collections.singleton(namespace));
        }
        return result;
    }

    public static IDefinition findProperty(ASScope scope, String member_name, ICompilerProject project, boolean lookForStatics) {
        IDefinition result = null;
        if (scope != null) {
            result = scope.findProperty(project, member_name, DependencyType.EXPRESSION, false);
        }
        return result;
    }

    public static FunctionDefinition getEnclosingFunctionDefinition(IASNode iNode, ICompilerProject project) {
        IASNode func_node = iNode.getAncestorOfType(FunctionNode.class);
        if (func_node != null) {
            return (FunctionDefinition)SemanticUtils.getDefinition(func_node, project);
        }
        return null;
    }

    public FunctionDefinition getEnclosingFunctionDefinition(IASNode iNode) {
        return SemanticUtils.getEnclosingFunctionDefinition(iNode, this.project);
    }

    public static boolean isInInstanceFunction(IASNode iNode, ICompilerProject project) {
        FunctionDefinition func_def = SemanticUtils.getEnclosingFunctionDefinition(iNode, project);
        return func_def != null && func_def.getFunctionClassification() == IFunctionDefinition.FunctionClassification.CLASS_MEMBER && !func_def.isStatic();
    }

    public boolean isInInstanceFunction(IASNode iNode) {
        return SemanticUtils.isInInstanceFunction(iNode, this.project);
    }

    public static boolean isInStaticClassFunction(IASNode iNode, ICompilerProject project) {
        FunctionDefinition func_def = SemanticUtils.getEnclosingFunctionDefinition(iNode, project);
        return func_def != null && func_def.getFunctionClassification() == IFunctionDefinition.FunctionClassification.CLASS_MEMBER && func_def.isStatic();
    }

    private static boolean isInaccessible(IASScope scope, Binding b, ICompilerProject project) {
        return b.getDefinition() == null && SemanticUtils.findMemberByName(scope, b.getName().getBaseName(), true, false, project) != null;
    }

    public boolean isInaccessible(ASScope containingScope, Binding b) {
        return SemanticUtils.isInaccessible(containingScope, b, this.project);
    }

    public static String getEnclosingClassName(IASNode iNode, ICompilerProject project) {
        assert (SemanticUtils.isInInstanceFunction(iNode, project));
        IDefinition class_def = SemanticUtils.getEnclosingFunctionDefinition(iNode, project).getAncestorOfType(ClassDefinition.class);
        return class_def.getBaseName();
    }

    public String getEnclosingClassName(IASNode iNode) {
        return SemanticUtils.getEnclosingClassName(iNode, this.project);
    }

    public static Collection<IDefinition> getPropertiesByNameForMemberAccess(IASScope scope, String member_name, ICompilerProject project) {
        assert (scope != null);
        return ((ASScope)scope).getPropertiesByNameForMemberAccess((CompilerProject)project, member_name, ASScopeBase.allNamespacesSet);
    }

    public static String getDiagnosticString(IASNode iNode) {
        String content = null;
        switch (iNode.getNodeID()) {
            case IdentifierID: 
            case NamespaceIdentifierID: 
            case NonResolvingIdentifierID: 
            case QualifiedNameExpressionID: {
                content = ((IdentifierNode)iNode).getName();
                break;
            }
            case FunctionCallID: {
                FunctionCallNode func = (FunctionCallNode)iNode;
                if (func.getNameNode() != null) {
                    return SemanticUtils.getDiagnosticString(func.getNameNode());
                }
                content = iNode.getNodeID().getParaphrase();
                break;
            }
            case LiteralArrayID: 
            case LiteralBooleanID: 
            case LiteralNumberID: 
            case LiteralObjectID: 
            case LiteralRegexID: 
            case LiteralStringID: 
            case LiteralXMLID: 
            case LiteralID: {
                content = ((LiteralNode)iNode).getValue();
                break;
            }
            case LiteralNullID: {
                content = "null";
                break;
            }
            case LiteralVoidID: {
                content = "void";
                break;
            }
            case MemberAccessExpressionID: {
                content = ((MemberAccessExpressionNode)iNode).getDisplayString();
                break;
            }
            default: {
                content = iNode.getNodeID().getParaphrase();
            }
        }
        return "'" + content + "'";
    }

    public static Nsset getOpenNamespaces(IASNode iNode, ICompilerProject project) {
        ASScope scope = SemanticUtils.getASScope(iNode);
        if (scope == null) {
            return null;
        }
        Set<INamespaceDefinition> namespaceSet = scope.getNamespaceSet(project);
        Nsset nsSet = SemanticUtils.convertSetINamespaceToNsset(namespaceSet);
        return nsSet;
    }

    public static Nsset getOpenNamespacesForSuper(IASNode iNode, ICompilerProject project, IDefinition superDef) {
        ASScope scope = SemanticUtils.getASScope(iNode);
        if (scope == null) {
            return null;
        }
        Set<INamespaceDefinition> namespaceSet = scope.getNamespaceSetForSuper(project, superDef);
        Nsset nsSet = SemanticUtils.convertSetINamespaceToNsset(namespaceSet);
        return nsSet;
    }

    public static Nsset convertSetINamespaceToNsset(Set<INamespaceDefinition> namespaceSet) {
        ArrayList<Namespace> ns_set = new ArrayList<Namespace>(namespaceSet.size());
        for (INamespaceDefinition namespace : namespaceSet) {
            Namespace aetNamespace = ((NamespaceDefinition)namespace).getAETNamespace();
            ns_set.add(aetNamespace);
        }
        return new Nsset(ns_set);
    }

    public static ASScope getASScope(IASNode iNode) {
        return ((NodeBase)iNode).getASScope();
    }

    public static boolean isConst(IASNode iNode, ICompilerProject project) {
        return SemanticUtils.isConstDefinition(SemanticUtils.getDefinition(iNode, project));
    }

    public boolean isConst(IASNode iNode) {
        return SemanticUtils.isConst(iNode, this.project);
    }

    public static boolean isConstDefinition(IDefinition def) {
        return def instanceof IConstantDefinition;
    }

    public static boolean isInConstructor(IASNode iNode) {
        FunctionNode fnode = (FunctionNode)SemanticUtils.searchUpForType(iNode, FunctionNode.class);
        return fnode != null && fnode.isConstructor();
    }

    public static boolean isInVariableDeclaration(IASNode iNode) {
        return SemanticUtils.searchUpForType(iNode, VariableNode.class, VariableExpressionNode.class) != null;
    }

    private static IASNode searchUpForType(IASNode iNode, Class<? extends IASNode> ... desired) {
        Class<? extends IASNode> candidate;
        if (iNode == null) {
            return null;
        }
        IASNode found = null;
        Class<? extends IASNode>[] classArray = desired;
        int n = classArray.length;
        for (int i = 0; i < n && (found = (candidate = classArray[i]).isInstance(iNode) ? iNode : iNode.getAncestorOfType(candidate)) == null; ++i) {
        }
        return found;
    }

    public IASNode getPotentiallyParameterizedType(IASNode iNode) {
        IASNode result = iNode;
        if (iNode instanceof TypedExpressionNode) {
            result = ((TypedExpressionNode)iNode).getTypeNode();
        }
        return result;
    }

    public static IASNode getNthChild(IASNode node, int index) {
        IASNode result = null;
        block0 : switch (node.getNodeID()) {
            case BindableVariableID: 
            case VariableID: {
                IVariableNode var = (IVariableNode)node;
                switch (index) {
                    case 0: {
                        result = var.getNameExpressionNode();
                        break block0;
                    }
                }
                int lastFoundChildPos = 0;
                result = var.getVariableTypeNode();
                if (result != null && index == ++lastFoundChildPos || (result = var.getAssignedValueNode()) != null && index == ++lastFoundChildPos) break;
                int needle = 0;
                while (needle < node.getChildCount() && lastFoundChildPos < index) {
                    if (node.getChild(needle) instanceof IVariableNode) {
                        ++lastFoundChildPos;
                    }
                    if (lastFoundChildPos >= index) continue;
                    ++needle;
                }
                assert (lastFoundChildPos == index) : "getNthChild() failed, should have been constrained by getChildCount(node)";
                return node.getChild(needle);
            }
            case FunctionID: 
            case GetterID: 
            case SetterID: {
                FunctionNode func = (FunctionNode)node;
                switch (index) {
                    case 0: {
                        result = func.getNameExpressionNode();
                        break;
                    }
                    case 1: {
                        result = func.getParametersContainerNode();
                        break;
                    }
                    case 2: {
                        result = func.getReturnTypeNode();
                        if (result != null) break;
                    }
                    case 3: {
                        assert (func.hasBeenParsed()) : "getScopedNode() called on a function before the body has been parsed";
                        result = func.getScopedNode();
                    }
                }
                break;
            }
            case Op_CommaID: {
                switch (index) {
                    case 0: {
                        result = node.getChild(node.getChildCount() - 1);
                        break block0;
                    }
                }
                result = node.getChild(index - 1);
                break;
            }
            case TryID: {
                ITryNode tryNode = (ITryNode)node;
                switch (index) {
                    case 0: {
                        result = tryNode.getStatementContentsNode();
                        break block0;
                    }
                    case 1: {
                        if (tryNode.getFinallyNode() != null) {
                            result = tryNode.getFinallyNode();
                            break block0;
                        }
                        assert (tryNode.getCatchNodeCount() > 0);
                        result = tryNode.getCatchNode(0);
                        break block0;
                    }
                }
                if (tryNode.getStatementContentsNode() != null) {
                    --index;
                }
                if (tryNode.getFinallyNode() != null) {
                    --index;
                }
                result = tryNode.getCatchNode(index);
                break;
            }
            case NamespaceID: {
                NamespaceNode nsNode = (NamespaceNode)node;
                IExpressionNode nsName = nsNode.getNameExpressionNode();
                ExpressionNodeBase nsURI = nsNode.getNamespaceURINode();
                switch (index) {
                    case 0: {
                        if (nsName != null) {
                            result = nsName;
                            break block0;
                        }
                        result = nsURI;
                        break block0;
                    }
                    case 1: {
                        if (nsName != null && nsURI != null) {
                            result = nsURI;
                            break block0;
                        }
                        throw new ArrayIndexOutOfBoundsException(index);
                    }
                }
                throw new ArrayIndexOutOfBoundsException(index);
            }
            default: {
                result = node.getChild(index);
            }
        }
        assert (result != null) : String.format("getNthChild(%s,%d) null result", new Object[]{node.getNodeID(), index});
        return result;
    }

    public static int getChildCount(IASNode node) {
        int result = 0;
        switch (node.getNodeID()) {
            case BindableVariableID: 
            case VariableID: {
                IVariableNode var = (IVariableNode)node;
                assert (var.getNameExpressionNode() != null) : "Variable has null name expression.";
                result = 1;
                if (var.getVariableTypeNode() != null) {
                    ++result;
                }
                if (var.getAssignedValueNode() != null) {
                    ++result;
                }
                for (int i = 0; i < node.getChildCount(); ++i) {
                    if (!(node.getChild(i) instanceof IVariableNode)) continue;
                    ++result;
                }
                break;
            }
            case FunctionID: 
            case GetterID: 
            case SetterID: {
                FunctionNode func = (FunctionNode)node;
                assert (func.getNameExpressionNode() != null) : "Function has null name expression";
                assert (func.getParametersContainerNode() != null) : "Function has null parameters";
                result = 2;
                if (func.getReturnTypeNode() != null) {
                    ++result;
                }
                if (func.getScopedNode() == null) break;
                ++result;
                break;
            }
            case NamespaceID: {
                NamespaceNode nsNode = (NamespaceNode)node;
                assert (nsNode.getNameExpressionNode() != null) : "'name' node is required";
                result = 1;
                if (nsNode.getNamespaceURINode() == null) break;
                result = 2;
                break;
            }
            default: {
                result = node.getChildCount();
            }
        }
        return result;
    }

    public static IDefinition getParameterContent(IASNode iNode) {
        return ((IParameterNode)iNode).getDefinition();
    }

    public static String getStringLiteralContent(IASNode iNode) {
        return ((ILiteralNode)iNode).getValue();
    }

    public static Long getUintContent(IASNode iNode) {
        return ((INumericLiteralNode)((Object)iNode)).getNumericValue().toUint32();
    }

    public static Double getDoubleContent(IASNode iNode) {
        return ((INumericLiteralNode)((Object)iNode)).getNumericValue().toNumber();
    }

    public static Boolean getBooleanContent(IASNode iNode) {
        if ("true".equalsIgnoreCase(SemanticUtils.getStringLiteralContent(iNode))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String getIdentifierContent(IASNode iNode) {
        return ((IIdentifierNode)iNode).getName();
    }

    public static Integer getIntegerContent(IASNode iNode) {
        return ((INumericLiteralNode)((Object)iNode)).getNumericValue().toInt32();
    }

    public static IMXMLEventSpecifierNode getMXMLEventSpecifierContent(IASNode iNode) {
        return (IMXMLEventSpecifierNode)iNode;
    }

    public static int isDottedName(IASNode n) {
        if (n instanceof MemberAccessExpressionNode && ((MemberAccessExpressionNode)n).stemIsPackage()) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    public static int qualifierIsCompileTimeConstant(IASNode iNode, ICompilerProject project) {
        IdentifierNode qualifier = (IdentifierNode)SemanticUtils.getNthChild(iNode, 0);
        IDefinition def = qualifier.resolve(project);
        if (def instanceof NamespaceDefinition) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    public int qualifierIsCompileTimeConstant(IASNode iNode) {
        return SemanticUtils.qualifierIsCompileTimeConstant(iNode, this.project);
    }

    public static int qualifierIsInterface(IASNode iNode, ICompilerProject project) {
        IdentifierNode qualifier = (IdentifierNode)SemanticUtils.getNthChild(iNode, 0);
        IDefinition def = qualifier.resolve(project);
        if (def instanceof InterfaceDefinition) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    public int qualifierIsInterface(IASNode iNode) {
        return SemanticUtils.qualifierIsInterface(iNode, this.project);
    }

    public static Object transformNameToConstantValue(IASNode iNode, ICompilerProject project) {
        Object result = null;
        if (iNode instanceof ExpressionNodeBase) {
            IDefinition val;
            IterationFlowNode parentIterationFlowNode;
            IASNode parentNode = iNode.getParent();
            if (parentNode instanceof BaseTypedDefinitionNode) {
                BaseTypedDefinitionNode parentDefinitionNode = (BaseTypedDefinitionNode)parentNode;
                if (parentDefinitionNode.getNameExpressionNode() == iNode) {
                    return null;
                }
                if (parentDefinitionNode.getTypeNode() == iNode) {
                    return null;
                }
            } else if (parentNode instanceof IterationFlowNode && (parentIterationFlowNode = (IterationFlowNode)parentNode).getLabelNode() == iNode) {
                return null;
            }
            if ((val = ((ExpressionNodeBase)iNode).resolve(project)) instanceof NamespaceDefinition) {
                NamespaceDefinition ns = (NamespaceDefinition)val;
                result = ns.resolveAETNamespace(project);
            } else if (val instanceof ConstantDefinition) {
                ConstantDefinition cd = (ConstantDefinition)val;
                result = cd.resolveValueFrom(project, (NodeBase)iNode);
            }
        }
        return result;
    }

    public Object transformNameToConstantValue(IASNode iNode) {
        return SemanticUtils.transformNameToConstantValue(iNode, this.project);
    }

    public static void checkScopedToDefaultNamespaceProblem(LexicalScope scope, BaseDefinitionNode node, IDefinition definition, String className) {
        if (node == null) {
            return;
        }
        INamespaceReference nsref = definition.getNamespaceReference();
        INamespaceDecorationNode dec = node.getNamespaceNode();
        if (dec == null && nsref instanceof INamespaceDefinition.IInternalNamespaceDefinition) {
            String type = "declaration";
            if (definition instanceof IFunctionDefinition) {
                type = "function";
            } else if (definition instanceof IClassDefinition) {
                type = "class";
            } else if (definition instanceof IInterfaceDefinition) {
                type = "interface";
            }
            String identifierName = type + " '" + definition.getBaseName() + "'";
            scope.addProblem(new ScopedToDefaultNamespaceProblem(node, identifierName, className));
        }
    }

    public static void checkParametersHaveNoTypeDeclaration(LexicalScope scope, IFunctionNode node, IFunctionDefinition func) {
        for (IParameterNode paramNode : node.getParameterNodes()) {
            ILanguageIdentifierNode identifier;
            IExpressionNode paramType = paramNode.getVariableTypeNode();
            if (paramType == null) {
                scope.addProblem(new ParameterHasNoTypeDeclarationProblem(paramNode, paramNode.getName(), node.getName()));
                continue;
            }
            if (paramType.getAbsoluteStart() != -1 || paramType.getAbsoluteEnd() != -1 || !(paramType instanceof ILanguageIdentifierNode) || !(identifier = (ILanguageIdentifierNode)((Object)paramType)).getKind().equals((Object)ILanguageIdentifierNode.LanguageIdentifierKind.ANY_TYPE)) continue;
            scope.addProblem(new ParameterHasNoTypeDeclarationProblem(paramNode, paramNode.getName(), node.getName()));
        }
    }

    public static void checkReturnValueHasNoTypeDeclaration(LexicalScope scope, IFunctionNode node, IFunctionDefinition func) {
        if (node.isConstructor()) {
            return;
        }
        if (node.getStart() == node.getEnd()) {
            return;
        }
        IExpressionNode returnType = node.getReturnTypeNode();
        if (returnType == null) {
            IASNode sourceLoc = node;
            IExpressionNode nameNode = node.getNameExpressionNode();
            if (nameNode != null) {
                sourceLoc = nameNode;
            }
            scope.addProblem(new ReturnValueHasNoTypeDeclarationProblem(sourceLoc, func.getBaseName()));
        }
    }

    public static boolean isGetterSetterPair(List<IDefinition> defs, ICompilerProject project) {
        if (defs.size() != 2) {
            return false;
        }
        IDefinition def0 = defs.get(0);
        IDefinition def1 = defs.get(1);
        return SemanticUtils.isGetterSetterPair(def0, def1, project);
    }

    public static boolean isGetterSetterPair(IDefinition def0, IDefinition def1, ICompilerProject project) {
        if (!(def0 instanceof IAccessorDefinition)) {
            return false;
        }
        if (!(def1 instanceof IAccessorDefinition)) {
            return false;
        }
        return ((IAccessorDefinition)def0).resolveCorrespondingAccessor(project) == def1;
    }

    public static ClassDefinition resolveBaseClass(ICommonClassNode classNode, ClassDefinition classDefinition, ICompilerProject project, Collection<ICompilerProblem> problems) {
        IASNode problemNode;
        IReference baseClassReference = classDefinition.getBaseClassReference();
        if (baseClassReference == null) {
            return null;
        }
        ITypeDefinition superclassDefinition = classDefinition.resolveType(baseClassReference, project, DependencyType.INHERITANCE);
        if (superclassDefinition == null) {
            problemNode = SemanticUtils.getBaseClassProblemNode(classNode, classDefinition);
            String baseClassReferenceName = baseClassReference.getName();
            IDefinition foundDefinition = baseClassReference.resolve(project, (ASScope)classDefinition.getContainingScope(), DependencyType.INHERITANCE, true);
            if (AmbiguousDefinition.isAmbiguous(foundDefinition)) {
                problems.add(new AmbiguousReferenceProblem(problemNode, baseClassReferenceName));
            } else {
                problems.add(new UnknownSuperclassProblem(problemNode, baseClassReferenceName));
            }
            superclassDefinition = SemanticUtils.getObjectDefinition(project);
        } else if (superclassDefinition instanceof IInterfaceDefinition) {
            problemNode = SemanticUtils.getBaseClassProblemNode(classNode, classDefinition);
            problems.add(new CannotExtendInterfaceProblem(problemNode));
            superclassDefinition = SemanticUtils.getObjectDefinition(project);
        } else if (superclassDefinition.isFinal()) {
            problemNode = SemanticUtils.getBaseClassProblemNode(classNode, classDefinition);
            problems.add(new BaseClassIsFinalProblem(problemNode));
            superclassDefinition = SemanticUtils.getObjectDefinition(project);
        } else if (superclassDefinition == classDefinition) {
            problems.add(new CircularTypeReferenceProblem(classDefinition, classDefinition.getQualifiedName()));
            superclassDefinition = SemanticUtils.getObjectDefinition(project);
        }
        if (superclassDefinition != null && superclassDefinition.isDeprecated() && !SemanticUtils.hasDeprecatedAncestor(problemNode = SemanticUtils.getBaseClassProblemNode(classNode, classDefinition))) {
            ICompilerProblem problem = SemanticUtils.createDeprecationProblem(superclassDefinition, problemNode);
            problems.add(problem);
        }
        return (ClassDefinition)superclassDefinition;
    }

    private static IASNode getBaseClassProblemNode(ICommonClassNode classNode, ClassDefinition classDefinition) {
        if (classNode instanceof IClassNode) {
            return ((IClassNode)classNode).getBaseClassExpressionNode();
        }
        return classDefinition.getNode();
    }

    private static IClassDefinition getObjectDefinition(ICompilerProject project) {
        IClassDefinition objectDefinition = (IClassDefinition)project.getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT);
        if (objectDefinition == null) {
            throw new MissingBuiltinException("Object");
        }
        return objectDefinition;
    }

    public static boolean isValidImport(IImportNode importNode, ICompilerProject project, boolean inInvisibleCompilationUnit) {
        String importName = importNode.getImportName();
        importName = project.getActualPackageName(importName);
        ASProjectScope projectScope = (ASProjectScope)project.getScope();
        if (projectScope.isValidImport(importName)) {
            return true;
        }
        if (inInvisibleCompilationUnit) {
            IDefinition[] externallyVisibleDefinitionsInThisFile;
            IFileNode fileNode = (IFileNode)importNode.getAncestorOfType(IFileNode.class);
            for (IDefinition d : externallyVisibleDefinitionsInThisFile = fileNode.getTopLevelDefinitions(false, true)) {
                String qName = d.getQualifiedName();
                if (qName.equals(importName)) {
                    return true;
                }
                String wildcardQName = ImportNode.makeWildcardName(qName);
                if (!wildcardQName.equals(importName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isType(IDefinition d) {
        return d instanceof ITypeDefinition;
    }

    public static boolean isE4XWildcardProperty(IdentifierNode node) {
        assert (node != null) : "node can't be null";
        IASNode blockOrFilterNode = node.getParent();
        if (blockOrFilterNode instanceof MemberAccessExpressionNode || blockOrFilterNode instanceof UnaryOperatorAtNode) {
            return false;
        }
        while (blockOrFilterNode != null && blockOrFilterNode.getNodeID() != ASTNodeID.BlockID && blockOrFilterNode.getNodeID() != ASTNodeID.E4XFilterID) {
            blockOrFilterNode = blockOrFilterNode.getParent();
        }
        return blockOrFilterNode != null && blockOrFilterNode.getNodeID() == ASTNodeID.E4XFilterID;
    }

    public static boolean isUnprotectedAssignmentInConditional(IASNode node) {
        IASNode current = node;
        IASNode parent = current.getParent();
        block6: while (parent != null) {
            switch (parent.getNodeID()) {
                case Op_LogicalAndID: 
                case Op_LogicalOrID: 
                case Op_LogicalNotID: 
                case ContainerID: 
                case ConditionalID: {
                    current = parent;
                    parent = current.getParent();
                    continue block6;
                }
                case WhileLoopID: {
                    return current == SemanticUtils.getNthChild(parent, 0);
                }
                case DoWhileLoopID: {
                    return current == SemanticUtils.getNthChild(parent, 1);
                }
                case IfStatementID: {
                    return current == SemanticUtils.getNthChild(parent, 0);
                }
            }
            return false;
        }
        return false;
    }

    public static Name getAETName(IDefinition def, ICompilerProject project) {
        return ((DefinitionBase)def).getMName(project);
    }

    public Name getAETName(IDefinition def) {
        return ((DefinitionBase)def).getMName(this.project);
    }

    public static boolean hasDeprecatedAncestor(IASNode node) {
        for (IASNode ancestor = node.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            IDefinition definition;
            if (!(ancestor instanceof IDefinitionNode) || !(definition = ((IDefinitionNode)ancestor).getDefinition()).isDeprecated()) continue;
            return true;
        }
        return false;
    }

    public static ICompilerProblem createDeprecationProblem(IDefinition definition, IASNode site) {
        AbstractDeprecatedAPIProblem problem = null;
        IDeprecationInfo deprecationInfo = definition.getDeprecationInfo();
        String message = deprecationInfo.getMessage();
        if (message != null) {
            problem = new DeprecatedAPIWithMessageProblem(site, message);
        } else {
            String name = definition.getBaseName();
            String since = deprecationInfo.getSince();
            String replacement = deprecationInfo.getReplacement();
            if (since == null && replacement == null) {
                problem = new DeprecatedAPIProblem(site, name);
            } else if (since != null && replacement == null) {
                problem = new DeprecatedAPIWithSinceProblem(site, name, since);
            } else if (since == null && replacement != null) {
                problem = new DeprecatedAPIWithReplacementProblem(site, name, replacement);
            } else if (since != null && replacement != null) {
                problem = new DeprecatedAPIWithSinceAndReplacementProblem(site, name, since, replacement);
            }
        }
        return problem;
    }

    public static FunctionDefinition getFunctionDefinition(IASNode iNode) {
        FunctionNode func_node = iNode instanceof FunctionNode ? (FunctionNode)iNode : (FunctionNode)iNode.getAncestorOfType(FunctionNode.class);
        if (func_node != null) {
            return func_node.getDefinition();
        }
        return null;
    }

    public static boolean canBeAbstract(IASNode iNode, ICompilerProject project) {
        if (iNode instanceof IClassNode) {
            IClassNode classNode = (IClassNode)iNode;
            IClassDefinition classDef = classNode.getDefinition();
            return !classDef.isFinal();
        }
        if (iNode instanceof IFunctionNode) {
            IFunctionNode funcNode = (IFunctionNode)iNode;
            IFunctionDefinition funcDef = funcNode.getDefinition();
            IDefinition parentDef = funcDef.getParent();
            if (parentDef instanceof IClassDefinition) {
                return parentDef.isAbstract() && !funcDef.isStatic() && !funcDef.isFinal() && !funcDef.isConstructor() && !(funcDef instanceof IAccessorDefinition);
            }
            return false;
        }
        return false;
    }

    public static boolean functionMustReturnValue(IASNode iNode, boolean allowAbstract, ICompilerProject project) {
        FunctionDefinition func_def = SemanticUtils.getFunctionDefinition(iNode);
        if (func_def != null) {
            ITypeDefinition return_type = func_def.resolveReturnType(project);
            return return_type != null && !return_type.equals(ClassDefinition.getVoidClassDefinition()) && !return_type.equals(ClassDefinition.getAnyTypeClassDefinition()) && !func_def.isConstructor() && (!allowAbstract || !SemanticUtils.canBeAbstract(iNode, project) || !func_def.isAbstract());
        }
        return false;
    }

    public static ITypeDefinition resolveRHSTypeOfAssignment(ICompilerProject project, IASNode iNode) {
        ITypeDefinition srcType = null;
        if (iNode instanceof BinaryOperatorAssignmentNode) {
            if (iNode.getChildCount() > 1 && iNode.getChild(1) instanceof IExpressionNode) {
                IExpressionNode rhs = (IExpressionNode)iNode.getChild(1);
                srcType = rhs.resolveType(project);
            }
        } else if (iNode instanceof IVariableNode) {
            IExpressionNode rhs = ((IVariableNode)iNode).getAssignedValueNode();
            srcType = rhs != null ? rhs.resolveType(project) : null;
        }
        return srcType;
    }

    public static String getFileName(IASNode iNode) {
        String file_name = iNode.getSourcePath();
        if (file_name == null) {
            try {
                IFileSpecification fs = iNode.getFileSpecification();
                if (fs != null) {
                    file_name = fs.getPath();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return file_name;
    }

    public static enum MultiDefinitionType {
        NONE,
        AMBIGUOUS,
        MULTIPLE,
        SHADOWS_PARAM;

    }
}

