/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions.references;

import org.apache.royale.abc.semantics.Name;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.AppliedVectorDefinitionFactory;
import org.apache.royale.compiler.definitions.IAppliedVectorDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.definitions.references.IReferenceMName;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;

public class ParameterizedReference
implements IReferenceMName {
    private final IReferenceMName name;
    private final IReferenceMName param;

    public ParameterizedReference(IReference name, IReference param) {
        this.name = (IReferenceMName)name;
        this.param = (IReferenceMName)param;
    }

    @Override
    public String getName() {
        return this.name.getName();
    }

    @Override
    public IDefinition resolve(ICompilerProject project, IASScope scope, DependencyType dependencyType, boolean canEscapeWith) {
        ITypeDefinition vectorType;
        ITypeDefinition baseType;
        IDefinition base = this.name.resolve(project, scope, dependencyType, canEscapeWith);
        IDefinition typeParam = this.param.resolve(project, scope, dependencyType, canEscapeWith);
        IAppliedVectorDefinition resolvedType = null;
        if (base instanceof ITypeDefinition && typeParam instanceof ITypeDefinition && (baseType = (ITypeDefinition)base) == (vectorType = project.getBuiltinType(IASLanguageConstants.BuiltinType.VECTOR))) {
            resolvedType = AppliedVectorDefinitionFactory.newVector(project, (ITypeDefinition)typeParam);
        }
        return resolvedType;
    }

    @Override
    public String getDisplayString() {
        return this.name.getDisplayString() + ".<" + (this.param == null ? "" : this.param.getDisplayString()) + ">";
    }

    @Override
    public Name getMName(ICompilerProject project, IASScope scope) {
        Name baseName = this.name.getMName(project, scope);
        Name paramName = this.param.getMName(project, scope);
        return new Name(baseName, paramName);
    }
}

