/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.testing;

import java.net.URLEncoder;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.tree.as.IASNode;

public class NodesToXMLStringFormatter {
    StringBuffer buffer = new StringBuffer();
    int level = 0;
    boolean escapeDescriptions;

    public NodesToXMLStringFormatter(IASNode n, boolean escape_descriptions) {
        this.escapeDescriptions = escape_descriptions;
        this.traverse(n);
    }

    public NodesToXMLStringFormatter(IASNode n) {
        this(n, true);
    }

    void traverse(IASNode n) {
        if (n == null) {
            return;
        }
        String node_name = n.getNodeID().toString();
        boolean has_kids = n.getChildCount() > 0;
        this.startLine();
        this.buffer.append("<");
        this.buffer.append(node_name);
        this.buffer.append(" location=\"");
        this.buffer.append(n.getLine());
        this.buffer.append(",");
        this.buffer.append(n.getColumn());
        this.buffer.append("\"");
        this.buffer.append(" description=\"");
        String node_description = ((NodeBase)n).getInnerString();
        if (node_description.startsWith("\"") && node_description.endsWith("\"")) {
            node_description = node_description.substring(1, node_description.length() - 2);
        }
        if (this.escapeDescriptions) {
            try {
                node_description = URLEncoder.encode(node_description, "UTF-8");
            }
            catch (Exception cant_encode) {
                node_description = "";
            }
        }
        this.buffer.append(node_description);
        this.buffer.append("\"");
        if (has_kids) {
            this.buffer.append(">\n");
            ++this.level;
            for (int i = 0; i < n.getChildCount(); ++i) {
                this.traverse(n.getChild(i));
            }
            --this.level;
            this.startLine();
            this.buffer.append("</" + node_name + ">");
        } else {
            this.buffer.append("/>");
        }
        this.buffer.append("\n");
    }

    public String toString() {
        return this.buffer != null ? this.buffer.toString() : "-nothing-";
    }

    private void startLine() {
        for (int i = 0; i < this.level; ++i) {
            this.buffer.append("  ");
        }
    }
}

