/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.proxy;

import com.netflix.client.config.ClientConfigFactory;
import com.netflix.ribbon.DefaultResourceFactory;
import com.netflix.ribbon.RibbonResourceFactory;
import com.netflix.ribbon.RibbonTransportFactory;
import com.netflix.ribbon.http.HttpResourceGroup;
import com.netflix.ribbon.proxy.ClassTemplate;
import com.netflix.ribbon.proxy.MethodTemplateExecutor;
import com.netflix.ribbon.proxy.ProxyHttpResourceGroupFactory;
import com.netflix.ribbon.proxy.ProxyLifeCycle;
import com.netflix.ribbon.proxy.RibbonProxyException;
import com.netflix.ribbon.proxy.Utils;
import com.netflix.ribbon.proxy.processor.AnnotationProcessorsProvider;
import com.netflix.ribbon.proxy.processor.CacheProviderAnnotationProcessor;
import com.netflix.ribbon.proxy.processor.ClientPropertiesProcessor;
import com.netflix.ribbon.proxy.processor.HttpAnnotationProcessor;
import com.netflix.ribbon.proxy.processor.HystrixAnnotationProcessor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

public class RibbonDynamicProxy<T>
implements InvocationHandler {
    private final ProxyLifeCycle lifeCycle;
    private final Map<Method, MethodTemplateExecutor> templateExecutorMap;

    RibbonDynamicProxy(Class<T> clientInterface, HttpResourceGroup httpResourceGroup) {
        AnnotationProcessorsProvider processors = AnnotationProcessorsProvider.DEFAULT;
        RibbonDynamicProxy.registerAnnotationProcessors(processors);
        this.lifeCycle = new ProxyLifecycleImpl(httpResourceGroup);
        this.templateExecutorMap = MethodTemplateExecutor.from(httpResourceGroup, clientInterface, processors);
    }

    public RibbonDynamicProxy(Class<T> clientInterface, RibbonResourceFactory resourceGroupFactory, ClientConfigFactory configFactory, RibbonTransportFactory transportFactory, AnnotationProcessorsProvider processors) {
        RibbonDynamicProxy.registerAnnotationProcessors(processors);
        ClassTemplate<T> classTemplate = ClassTemplate.from(clientInterface);
        HttpResourceGroup httpResourceGroup = new ProxyHttpResourceGroupFactory<T>(classTemplate, resourceGroupFactory, processors).createResourceGroup();
        this.templateExecutorMap = MethodTemplateExecutor.from(httpResourceGroup, clientInterface, processors);
        this.lifeCycle = new ProxyLifecycleImpl(httpResourceGroup);
    }

    static void registerAnnotationProcessors(AnnotationProcessorsProvider processors) {
        processors.register(new HttpAnnotationProcessor());
        processors.register(new HystrixAnnotationProcessor());
        processors.register(new CacheProviderAnnotationProcessor());
        processors.register(new ClientPropertiesProcessor());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodTemplateExecutor template = this.templateExecutorMap.get(method);
        if (template != null) {
            return template.executeFromTemplate(args);
        }
        if (ProxyLifeCycle.class.isAssignableFrom(method.getDeclaringClass())) {
            return this.handleProxyLifeCycle(method, args);
        }
        return Utils.executeOnInstance(this, method, args);
    }

    private Object handleProxyLifeCycle(Method method, Object[] args) {
        try {
            return method.invoke((Object)this.lifeCycle, args);
        }
        catch (Exception e) {
            throw new RibbonProxyException("ProxyLifeCycle call failure on method " + method.getName(), e);
        }
    }

    public String toString() {
        return "RibbonDynamicProxy{...}";
    }

    public static <T> T newInstance(Class<T> clientInterface) {
        return RibbonDynamicProxy.newInstance(clientInterface, new DefaultResourceFactory(ClientConfigFactory.DEFAULT, RibbonTransportFactory.DEFAULT, AnnotationProcessorsProvider.DEFAULT), ClientConfigFactory.DEFAULT, RibbonTransportFactory.DEFAULT, AnnotationProcessorsProvider.DEFAULT);
    }

    static <T> T newInstance(Class<T> clientInterface, HttpResourceGroup httpResourceGroup) {
        if (!clientInterface.isInterface()) {
            throw new IllegalArgumentException(clientInterface.getName() + " is a class not interface");
        }
        if (httpResourceGroup == null) {
            throw new NullPointerException("HttpResourceGroup is null");
        }
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clientInterface, ProxyLifeCycle.class}, new RibbonDynamicProxy<T>(clientInterface, httpResourceGroup));
    }

    public static <T> T newInstance(Class<T> clientInterface, RibbonResourceFactory resourceGroupFactory, ClientConfigFactory configFactory, RibbonTransportFactory transportFactory, AnnotationProcessorsProvider processors) {
        if (!clientInterface.isInterface()) {
            throw new IllegalArgumentException(clientInterface.getName() + " is a class not interface");
        }
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clientInterface, ProxyLifeCycle.class}, new RibbonDynamicProxy<T>(clientInterface, resourceGroupFactory, configFactory, transportFactory, processors));
    }

    public static <T> T newInstance(Class<T> clientInterface, RibbonResourceFactory resourceGroupFactory, ClientConfigFactory configFactory, RibbonTransportFactory transportFactory) {
        return RibbonDynamicProxy.newInstance(clientInterface, resourceGroupFactory, configFactory, transportFactory, AnnotationProcessorsProvider.DEFAULT);
    }

    private static class ProxyLifecycleImpl
    implements ProxyLifeCycle {
        private final HttpResourceGroup httpResourceGroup;
        private volatile boolean shutdownFlag;

        ProxyLifecycleImpl(HttpResourceGroup httpResourceGroup) {
            this.httpResourceGroup = httpResourceGroup;
        }

        @Override
        public boolean isShutDown() {
            return this.shutdownFlag;
        }

        @Override
        public synchronized void shutdown() {
            if (!this.shutdownFlag) {
                this.httpResourceGroup.getClient().shutdown();
                this.shutdownFlag = true;
            }
        }
    }
}

