/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.router.custom;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.filter.HttpServerFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class RouterAddHeaderFilter
implements HttpServerFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouterAddHeaderFilter.class);
    private static final String SERVICECOMB_ROUTER_HEADER = "servicecomb.router.header";
    private static List<String> allHeader = new ArrayList<String>();

    public int getOrder() {
        return -90;
    }

    public boolean enabled() {
        return true;
    }

    public boolean enabledForTransport(String transport) {
        return super.enabledForTransport(transport) || "websocket".equals(transport);
    }

    public Response afterReceiveRequest(Invocation invocation, HttpServletRequestEx httpServletRequestEx) {
        if (!StringUtils.isEmpty((CharSequence)invocation.getContext("X-RouterContext"))) {
            return null;
        }
        if (!this.isHaveHeadersRule()) {
            return null;
        }
        if (this.loadHeaders()) {
            Map<String, String> headerMap = this.getHeaderMap(httpServletRequestEx);
            try {
                invocation.addContext("X-RouterContext", JsonUtils.OBJ_MAPPER.writeValueAsString(headerMap));
            }
            catch (JsonProcessingException e) {
                LOGGER.error("canary context serialization failed");
            }
        }
        return null;
    }

    private boolean loadHeaders() {
        if (!CollectionUtils.isEmpty(allHeader)) {
            return true;
        }
        DynamicStringProperty headerStr = DynamicPropertyFactory.getInstance().getStringProperty(SERVICECOMB_ROUTER_HEADER, null, () -> {
            DynamicStringProperty temHeader = DynamicPropertyFactory.getInstance().getStringProperty(SERVICECOMB_ROUTER_HEADER, null);
            if (!this.addAllHeaders(temHeader.get())) {
                allHeader = new ArrayList<String>();
            }
        });
        return this.addAllHeaders(headerStr.get());
    }

    private boolean isHaveHeadersRule() {
        DynamicStringProperty headerStr = DynamicPropertyFactory.getInstance().getStringProperty(SERVICECOMB_ROUTER_HEADER, null);
        return StringUtils.isNotEmpty((CharSequence)headerStr.get());
    }

    private boolean addAllHeaders(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        try {
            if (CollectionUtils.isEmpty(allHeader)) {
                allHeader = Arrays.asList(str.split(","));
            }
        }
        catch (Exception e) {
            LOGGER.error("route management Serialization failed: {}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private Map<String, String> getHeaderMap(HttpServletRequestEx httpServletRequestEx) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        allHeader.forEach(headerKey -> {
            String val = httpServletRequestEx.getHeader(headerKey);
            if (!StringUtils.isEmpty((CharSequence)val)) {
                headerMap.put((String)headerKey, httpServletRequestEx.getHeader(headerKey));
            }
        });
        return headerMap;
    }
}

