/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client;

import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketClient;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.WebSocketTransportContext;
import org.apache.servicecomb.common.rest.definition.RestMetaUtils;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.ConsumerFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientOptionsSPI;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClients;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.TransportContext;
import org.apache.servicecomb.transport.rest.client.Http2TransportHttpClientOptionsSPI;
import org.apache.servicecomb.transport.rest.client.HttpTransportHttpClientOptionsSPI;
import org.apache.servicecomb.transport.rest.client.WebSocketClientTransportContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClientCodecFilter
extends AbstractFilter
implements ConsumerFilter,
EdgeFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketClientCodecFilter.class);
    public static final String NAME = "websocket-client";

    public String getName() {
        return NAME;
    }

    public boolean enabledForTransport(String transport) {
        return "websocket".equals(transport);
    }

    public int getOrder() {
        return 2000;
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        invocation.getInvocationStageTrace().startConsumerConnection();
        CompletableFuture<Response> createWebSocket = new CompletableFuture<Response>();
        URIEndpointObject endpoint = (URIEndpointObject)invocation.getEndpoint().getAddress();
        HttpClientOptionsSPI optionsSPI = endpoint.isHttp2Enabled() ? (HttpClientOptionsSPI)SPIServiceUtils.getTargetService(HttpClientOptionsSPI.class, HttpTransportHttpClientOptionsSPI.class) : (HttpClientOptionsSPI)SPIServiceUtils.getTargetService(HttpClientOptionsSPI.class, Http2TransportHttpClientOptionsSPI.class);
        WebSocketClient webSocketClient = HttpClients.createWebSocketClient((HttpClientOptionsSPI)optionsSPI, (boolean)endpoint.isSslEnabled());
        try {
            webSocketClient.connect(endpoint.getPort(), endpoint.getHostOrIp(), this.createRequestPath(invocation, RestMetaUtils.getRestOperationMeta((OperationMeta)invocation.getOperationMeta()))).onComplete(asyncResult -> {
                invocation.getInvocationStageTrace().finishConsumerConnection();
                if (asyncResult.failed()) {
                    createWebSocket.completeExceptionally(asyncResult.cause());
                    return;
                }
                if (invocation.isEdge()) {
                    WebSocketTransportContext parentContext = (WebSocketTransportContext)invocation.getTransportContext();
                    ServerWebSocket serverWebSocket = parentContext.getServerWebSocket();
                    WebSocket clientWebSocket = (WebSocket)asyncResult.result();
                    serverWebSocket.closeHandler(v -> {
                        if (!clientWebSocket.isClosed()) {
                            clientWebSocket.close();
                        }
                    });
                    serverWebSocket.textMessageHandler(arg_0 -> ((WebSocket)clientWebSocket).writeTextMessage(arg_0));
                    serverWebSocket.binaryMessageHandler(arg_0 -> ((WebSocket)clientWebSocket).writeBinaryMessage(arg_0));
                    serverWebSocket.exceptionHandler(e -> {
                        LOGGER.warn("consumer exception.", e);
                        if (!serverWebSocket.isClosed()) {
                            serverWebSocket.close();
                        }
                    });
                    clientWebSocket.closeHandler(v -> {
                        if (!serverWebSocket.isClosed()) {
                            serverWebSocket.close();
                        }
                    });
                    clientWebSocket.textMessageHandler(arg_0 -> ((ServerWebSocket)serverWebSocket).writeTextMessage(arg_0));
                    clientWebSocket.binaryMessageHandler(arg_0 -> ((ServerWebSocket)serverWebSocket).writeBinaryMessage(arg_0));
                    clientWebSocket.exceptionHandler(e -> {
                        LOGGER.warn("producer exception.", e);
                        if (!clientWebSocket.isClosed()) {
                            clientWebSocket.close();
                        }
                    });
                }
                invocation.setTransportContext((TransportContext)new WebSocketClientTransportContext((WebSocket)asyncResult.result()));
                createWebSocket.complete(Response.createSuccess((Object)asyncResult.result()));
            });
        }
        catch (Exception e) {
            createWebSocket.completeExceptionally(e);
        }
        return createWebSocket;
    }

    protected String createRequestPath(Invocation invocation, RestOperationMeta restOperationMeta) throws Exception {
        URIEndpointObject endpoint;
        String urlPrefix;
        String path = (String)invocation.getLocalContext("rest-client-request-path");
        if (path == null) {
            path = restOperationMeta.getPathBuilder().createRequestPath(invocation.getSwaggerArguments());
        }
        if (StringUtils.isEmpty((CharSequence)(urlPrefix = (endpoint = (URIEndpointObject)invocation.getEndpoint().getAddress()).getFirst("urlPrefix"))) || path.startsWith(urlPrefix)) {
            return path;
        }
        return urlPrefix + path;
    }
}

